/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractLeakProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public abstract class MethodLeakDetector
extends AbstractLeakProblemDetector {
    public MethodLeakDetector(Set<String> nonApiPackageNames) {
        super(nonApiPackageNames);
    }

    @Override
    protected int getElementType(IReference reference) {
        return 6;
    }

    @Override
    protected int getProblemKind() {
        return 6;
    }

    @Override
    protected String getSeverityKey() {
        return "LEAK_METHOD_RETURN_TYPE";
    }

    @Override
    protected boolean isProblem(IReference reference, IProgressMonitor monitor) {
        block7: {
            IApiType type;
            IApiMethod method;
            block6: {
                method = (IApiMethod)reference.getMember();
                type = (IApiType)reference.getResolvedReference();
                IApiAnnotations annotations = type.getApiComponent().getApiDescription().resolveAnnotations(type.getHandle());
                if (annotations == null) break block6;
                if (VisibilityModifiers.isPrivate(annotations.getVisibility())) {
                    IApiDescription description;
                    return (4 & method.getModifiers()) <= 0 || (annotations = (description = method.getApiComponent().getApiDescription()).resolveAnnotations(method.getHandle().getEnclosingType())) != null && !RestrictionModifiers.isExtendRestriction(annotations.getRestrictions());
                }
            }
            try {
                if (this.isEnclosingTypeVisible(type)) {
                    String typeName = type.getName();
                    if (typeName != null && !typeName.startsWith("javax.")) {
                        ApiPlugin.log(Status.info((String)MessageFormat.format(BuilderMessages.AbstractTypeLeakDetector_vis_type_has_no_api_description, typeName)));
                    }
                    break block7;
                }
                return true;
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
                MethodLeakDetector.checkIfDisposed(method.getApiComponent(), monitor);
            }
        }
        return false;
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiMethod method = (IApiMethod)reference.getMember();
        IApiType type = (IApiType)reference.getResolvedReference();
        return new String[]{this.getSimpleTypeName(type), this.getSimpleTypeName(method), Signatures.getMethodSignature(method)};
    }

    @Override
    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiMethod method = (IApiMethod)reference.getMember();
        IApiType type = (IApiType)reference.getResolvedReference();
        return new String[]{this.getQualifiedTypeName(type), this.getQualifiedTypeName(method), Signatures.getMethodSignature(method)};
    }

    @Override
    protected Position getSourceRange(IType type, IDocument doc, IReference reference) throws CoreException, BadLocationException {
        return this.getSourceRangeForMethod(type, reference, (IApiMethod)reference.getMember());
    }

    @Override
    public boolean considerReference(IReference reference, IProgressMonitor monitor) {
        IApiMember member;
        if (super.considerReference(reference, monitor) && this.isNonAPIReference(reference) && (member = reference.getMember()) != null && this.matchesSourceModifiers(member) && this.matchesSourceApiRestrictions(member)) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    protected boolean matchesSourceApiRestrictions(IApiMember member) {
        block8: {
            IApiComponent apiComponent = member.getApiComponent();
            try {
                IApiMethod method = (IApiMethod)member;
                IApiAnnotations annotations = apiComponent.getApiDescription().resolveAnnotations(method.getHandle());
                if (annotations != null) {
                    if (VisibilityModifiers.isAPI(annotations.getVisibility())) {
                        int ares = annotations.getRestrictions();
                        if (ares != 0) {
                            if (method.isConstructor()) {
                                return (ares & 8) == 0;
                            }
                            if ((ares & 0x10) == 0) {
                                IApiAnnotations annot = apiComponent.getApiDescription().resolveAnnotations(method.getEnclosingType().getHandle());
                                int pres = 0;
                                if (annot != null) {
                                    pres = annot.getRestrictions();
                                }
                                return (ares & 8) != 0 && !Flags.isFinal((int)method.getModifiers()) && !Flags.isStatic((int)method.getModifiers()) && !Flags.isFinal((int)method.getEnclosingType().getModifiers()) && (pres & 2) == 0;
                            }
                            return (ares & 8) == 0;
                        }
                        return !Flags.isProtected((int)method.getModifiers()) || !Flags.isFinal((int)method.getEnclosingType().getModifiers());
                    }
                    break block8;
                }
                return true;
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        return false;
    }

    protected boolean matchesSourceModifiers(IApiMember member) {
        for (IApiMember lmember = member; lmember != null; lmember = lmember.getEnclosingType()) {
            int modifiers = lmember.getModifiers();
            if (Flags.isPublic((int)modifiers) || Flags.isProtected((int)modifiers)) {
                try {
                    continue;
                }
                catch (CoreException e) {
                    ApiPlugin.log(e.getStatus());
                    return false;
                }
            }
            return false;
        }
        return true;
    }
}

