/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDString;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDObjectStringImpl
extends AbstractCDOID
implements InternalCDOIDObject,
CDOIDString {
    private static final long serialVersionUID = 1L;
    private static final StringInterner INTERNER = new StringInterner();
    private final String value;

    private CDOIDObjectStringImpl(String value) {
        CheckUtil.checkArg((Object)value, (String)"Null not allowed");
        this.value = value;
    }

    private CDOIDObjectStringImpl() {
        this.value = null;
    }

    @Override
    public void write(CDODataOutput out) throws IOException {
        out.writeString(this.value);
    }

    @Override
    public String toURIFragment() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    @Override
    public CDOID.ObjectType getSubType() {
        return CDOID.ObjectType.STRING;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return "OID" + this.value;
    }

    @Override
    protected int doCompareTo(CDOID o) throws ClassCastException {
        return this.value.compareTo(((CDOIDObjectStringImpl)o).value);
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDObjectStringImpl.create(this.value);
    }

    private static int getHashCode(String value) {
        return value.hashCode();
    }

    public static CDOIDObjectStringImpl create(String value) {
        return INTERNER.intern(value);
    }

    public static CDOIDObjectStringImpl create(CDODataInput in) throws IOException {
        String value = in.readString();
        return CDOIDObjectStringImpl.create(value);
    }

    /* synthetic */ CDOIDObjectStringImpl(String string, CDOIDObjectStringImpl cDOIDObjectStringImpl) {
        this(string);
    }

    private static final class StringInterner
    extends Interner<CDOIDObjectStringImpl> {
        private StringInterner() {
        }

        public synchronized CDOIDObjectStringImpl intern(String value) {
            int hashCode = CDOIDObjectStringImpl.getHashCode(value);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDObjectStringImpl id = (CDOIDObjectStringImpl)entry.get();
                if (id != null && id.value.equals(value)) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDObjectStringImpl id = new CDOIDObjectStringImpl(value, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDObjectStringImpl id) {
            return CDOIDObjectStringImpl.getHashCode(id.value);
        }
    }
}

