/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncFeature;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.policy.ISyncPolicy;

public abstract class MasterSlaveSyncBucket<M, T, X>
extends SyncBucket<M, T, X> {
    protected SyncItem<M, T> master;

    public MasterSlaveSyncBucket(M model, T master) {
        super(model);
        this.master = this.encapsulate(master);
    }

    public SyncItem<M, T> getMaster() {
        return this.master;
    }

    @Override
    protected void onNew(SyncItem<M, T> item) {
        ISyncPolicy policy = this.getSyncService().getSyncPolicy();
        for (SyncFeature<M, T, Object> syncFeature : policy.filter(this.master, item, this.getFeatures())) {
            policy.observe(item, syncFeature);
            syncFeature.synchronize(this.master, item, null);
        }
    }

    @Override
    protected void onNew(SyncFeature<M, T, X> feature) {
        feature.observe(this.master);
        ISyncPolicy policy = this.getSyncService().getSyncPolicy();
        for (SyncItem<M, T> item : policy.filter(this.master, this.getItems(), feature)) {
            policy.observe(item, feature);
            feature.synchronize(this.master, item, null);
        }
    }
}

