/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container.delegate;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.delegate.AbstractDelegator;
import org.eclipse.net4j.util.container.delegate.ContainerCollection;
import org.eclipse.net4j.util.container.delegate.IContainerList;
import org.eclipse.net4j.util.event.IListener;

public class ContainerList<E>
extends ContainerCollection<E>
implements IContainerList<E> {
    public ContainerList(List<E> delegate) {
        super(delegate);
    }

    @Override
    public List<E> getDelegate() {
        return (List)super.getDelegate();
    }

    @Override
    public void add(int index, E element) {
        this.getDelegate().add(index, element);
        this.fireAddedEvent(element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ContainerEvent event = this.createEvent(this.getDelegate(), IContainerDelta.Kind.ADDED);
        this.getDelegate().addAll(index, c);
        return this.dispatchEvent(event);
    }

    @Override
    public E get(int index) {
        return this.getDelegate().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getDelegate().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new DelegatingListIterator(this.getDelegate().listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new DelegatingListIterator(this.getDelegate().listIterator(index));
    }

    @Override
    public E remove(int index) {
        Object removed = this.getDelegate().remove(index);
        if (removed != null) {
            this.fireRemovedEvent(removed);
        }
        return removed;
    }

    @Override
    public E set(int index, E element) {
        E removed = this.getDelegate().set(index, element);
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            ContainerEvent<E> event = new ContainerEvent<E>(this);
            event.addDelta(removed, IContainerDelta.Kind.REMOVED);
            event.addDelta(element, IContainerDelta.Kind.ADDED);
            this.fireEvent(event, listeners);
        }
        return removed;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    public class DelegatingListIterator
    extends AbstractDelegator.DelegatingIterator
    implements ListIterator<E> {
        public DelegatingListIterator(ListIterator<E> delegate) {
            super(ContainerList.this, delegate);
        }

        public ListIterator<E> getDelegate() {
            return (ListIterator)super.getDelegate();
        }

        @Override
        public void add(E o) {
            this.getDelegate().add(o);
            ContainerList.this.fireAddedEvent(o);
            this.last = o;
        }

        @Override
        public void set(E o) {
            this.getDelegate().set(o);
            IListener[] listeners = ContainerList.this.getListeners();
            if (listeners.length != 0) {
                ContainerEvent<Object> event = new ContainerEvent<Object>(ContainerList.this);
                event.addDelta(this.last, IContainerDelta.Kind.REMOVED);
                event.addDelta(o, IContainerDelta.Kind.ADDED);
                ContainerList.this.fireEvent(event, listeners);
            }
            this.last = o;
        }

        @Override
        public boolean hasPrevious() {
            return this.getDelegate().hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.getDelegate().nextIndex();
        }

        @Override
        public E previous() {
            return this.getDelegate().previous();
        }

        @Override
        public int previousIndex() {
            return this.getDelegate().previousIndex();
        }
    }
}

