/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOLocalAdapter;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.lock.InternalCDOLockState;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.LockTimeoutException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.util.StaleRevisionLockException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDOInvalidationPolicy;
import org.eclipse.emf.cdo.view.CDOLockStatePrefetcher;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.cdo.view.CDOStaleReferencePolicy;
import org.eclipse.emf.cdo.view.CDOUnit;
import org.eclipse.emf.cdo.view.CDOUnitManager;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewDurabilityChangedEvent;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.cdo.view.CDOViewLocksChangedEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDODeltaNotificationImpl;
import org.eclipse.emf.internal.cdo.object.CDOInvalidationNotificationImpl;
import org.eclipse.emf.internal.cdo.object.CDONotificationBuilder;
import org.eclipse.emf.internal.cdo.object.CDOObjectWrapperBase;
import org.eclipse.emf.internal.cdo.session.SessionUtil;
import org.eclipse.emf.internal.cdo.util.DefaultLocksChangedEvent;
import org.eclipse.emf.internal.cdo.view.AbstractCDOView;
import org.eclipse.emf.internal.cdo.view.CDOLockStateLoadingPolicy;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.internal.cdo.view.CDOViewRegistryImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RunnableWithName;
import org.eclipse.net4j.util.concurrent.SerializingExecutor;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.event.ThrowableEvent;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.ref.ReferenceType;
import org.eclipse.net4j.util.ref.ReferenceValueMap;

public class CDOViewImpl
extends AbstractCDOView {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, CDOViewImpl.class);
    private int viewID;
    private InternalCDOSession session;
    private String durableLockingID;
    private final CDOUnitManagerImpl unitManager = new CDOUnitManagerImpl();
    private final CommitInfoDistributor commitInfoDistributor = new CommitInfoDistributor();
    private ChangeSubscriptionManager changeSubscriptionManager = new ChangeSubscriptionManager();
    private AdapterManager adapterManager = new AdapterManager();
    private OptionsImpl options;
    private long lastUpdateTime;
    private CDOLockOwner lockOwner;
    private Map<CDOObject, CDOLockState> lockStates = new WeakHashMap<CDOObject, CDOLockState>();
    private ViewInvalidator invalidator = new ViewInvalidator();
    private volatile boolean invalidating;

    public CDOViewImpl(CDOSession session, CDOBranch branch, long timeStamp) {
        super(session, branch.getPoint(timeStamp));
        this.options = this.createOptions();
    }

    public CDOViewImpl(CDOSession session, String durableLockingID) {
        super(session);
        this.durableLockingID = durableLockingID;
        this.options = this.createOptions();
    }

    @Override
    public OptionsImpl options() {
        return this.options;
    }

    public int getViewID() {
        return this.viewID;
    }

    @Override
    public void setViewID(int viewId) {
        this.viewID = viewId;
    }

    public ExecutorService getExecutorService() {
        return ConcurrencyUtil.getExecutorService((Object)this.session);
    }

    @Override
    public InternalCDOSession getSession() {
        return this.session;
    }

    @Override
    public void setSession(InternalCDOSession session) {
        super.setSession(session);
        this.session = session;
    }

    public int getSessionID() {
        return this.session.getSessionID();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setBranchPoint(CDOBranchPoint branchPoint, IProgressMonitor progressMonitor) {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                branchPoint = this.adjustBranchPoint(branchPoint);
                long timeStamp = branchPoint.getTimeStamp();
                long creationTimeStamp = this.session.getRepositoryInfo().getCreationTime();
                if (timeStamp != 0L && timeStamp < creationTimeStamp) {
                    throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) < repository creation time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)creationTimeStamp)));
                }
                CDOBranchPoint oldBranchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)this.getBranchPoint());
                if (branchPoint.equals(oldBranchPoint)) {
                    return false;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Changing view target to {0}", new Object[]{branchPoint});
                }
                Map oldRevisions = CDOIDUtil.createMap();
                ArrayList<CDORevisionKey> allChangedObjects = new ArrayList<CDORevisionKey>();
                ArrayList<CDOIDAndVersion> allDetachedObjects = new ArrayList<CDOIDAndVersion>();
                List<InternalCDOObject> invalidObjects = this.getInvalidObjects(branchPoint);
                for (InternalCDOObject object2 : invalidObjects) {
                    InternalCDORevision revision = object2.cdoRevision();
                    if (revision == null) continue;
                    oldRevisions.put(object2.cdoID(), revision);
                }
                CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                sessionProtocol.switchTarget(this.viewID, branchPoint, invalidObjects, allChangedObjects, allDetachedObjects, EclipseMonitor.convert((IProgressMonitor)progressMonitor));
                this.basicSetBranchPoint(branchPoint);
                try {
                    CDOStateMachine.SWITCHING_TARGET.set(Boolean.TRUE);
                    InternalCDOView.ViewInvalidationData invalidationData = new InternalCDOView.ViewInvalidationData();
                    invalidationData.setLastUpdateTime(0L);
                    invalidationData.setBranch(branchPoint.getBranch());
                    invalidationData.setAllChangedObjects(allChangedObjects);
                    invalidationData.setAllDetachedObjects(allDetachedObjects);
                    invalidationData.setOldRevisions(oldRevisions);
                    invalidationData.setClearResourcePathCache(true);
                    this.doInvalidate(invalidationData);
                }
                finally {
                    CDOStateMachine.SWITCHING_TARGET.remove();
                }
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireViewTargetChangedEvent(oldBranchPoint, listeners);
                }
                return true;
            }
            finally {
                this.unlockView();
            }
        }
    }

    private List<InternalCDOObject> getInvalidObjects(CDOBranchPoint branchPoint) {
        ArrayList<InternalCDOObject> result = new ArrayList<InternalCDOObject>();
        for (InternalCDOObject object : this.getModifiableObjects().values()) {
            InternalCDORevision revision = object.cdoRevision(false);
            if (revision != null && revision.isValid(branchPoint)) continue;
            result.add(object);
        }
        return result;
    }

    private Set<? extends CDOObject> getSet(Collection<? extends CDOObject> objects) {
        if (objects instanceof Set) {
            return (Set)objects;
        }
        return new HashSet<CDOObject>(objects);
    }

    @Override
    public void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
        this.lockObjects(objects, lockType, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout, boolean recursive) throws InterruptedException {
        this.checkActive();
        this.checkState(this.getTimeStamp() == 0L, "Locking not supported for historial views");
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                void var11_15;
                int locksOnNewObjectsCount;
                Set<? extends CDOObject> uniqueObjects = this.getSet(objects);
                int size = uniqueObjects.size();
                ArrayList<CDORevisionKey> revisionKeys = new ArrayList<CDORevisionKey>(size);
                ArrayList<InternalCDOLockState> locksOnNewObjects = new ArrayList<InternalCDOLockState>(size);
                for (CDOObject cDOObject : uniqueObjects) {
                    if (FSMUtil.isNew(cDOObject)) {
                        InternalCDOLockState lockState = this.createUpdatedLockStateForNewObject(cDOObject, lockType, true);
                        locksOnNewObjects.add(lockState);
                        if (!recursive) continue;
                        TreeIterator it = cDOObject.eAllContents();
                        while (it.hasNext()) {
                            CDOObject child = CDOUtil.getCDOObject((EObject)it.next());
                            lockState = this.createUpdatedLockStateForNewObject(child, lockType, true);
                            locksOnNewObjects.add(lockState);
                        }
                        continue;
                    }
                    InternalCDORevision revision = this.getRevision(cDOObject);
                    if (revision == null) continue;
                    revisionKeys.add((CDORevisionKey)revision);
                }
                Object var11_13 = null;
                if (!revisionKeys.isEmpty()) {
                    CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                    CDOSessionProtocol.LockObjectsResult lockObjectsResult = sessionProtocol.lockObjects2(revisionKeys, this.viewID, this.getBranch(), lockType, recursive, timeout);
                    if (!lockObjectsResult.isSuccessful()) {
                        if (lockObjectsResult.isTimedOut()) {
                            throw new LockTimeoutException();
                        }
                        CDORevisionKey[] staleRevisions = lockObjectsResult.getStaleRevisions();
                        if (staleRevisions != null) {
                            throw new StaleRevisionLockException(staleRevisions);
                        }
                        throw new AssertionError((Object)"Unexpected lock result state");
                    }
                    if (lockObjectsResult.isWaitForUpdate()) {
                        if (!this.session.options().isPassiveUpdateEnabled()) {
                            throw new AssertionError((Object)"Lock result requires client to wait, but client does not have passiveUpdates enabled");
                        }
                        long requiredTimestamp = lockObjectsResult.getRequiredTimestamp();
                        if (!this.waitForUpdate(requiredTimestamp, 10000L)) {
                            throw new AssertionError((Object)("Lock result requires client to wait for commit " + requiredTimestamp + ", but client did not receive invalidations after " + this.lastUpdateTime));
                        }
                        InternalCDOSession session = this.session;
                        InternalCDORevisionManager revisionManager = session.getRevisionManager();
                        CDORevisionKey[] cDORevisionKeyArray = lockObjectsResult.getStaleRevisions();
                        int n = cDORevisionKeyArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CDORevisionKey requiredKey = cDORevisionKeyArray[n2];
                            CDOID id = requiredKey.getID();
                            InternalCDOObject object3 = this.getObject(id);
                            InternalCDORevision revision = object3.cdoRevision(true);
                            if (!requiredKey.equals(revision)) {
                                InternalCDORevision requiredRevision = revisionManager.getRevisionByVersion(id, (CDOBranchVersion)requiredKey, -1, true);
                                InternalCDORevisionDelta revisionDelta = requiredRevision.compare((CDORevision)revision);
                                CDOStateMachine.INSTANCE.invalidate(object3, (CDORevisionKey)revisionDelta);
                            }
                            ++n2;
                        }
                    }
                }
                if ((locksOnNewObjectsCount = locksOnNewObjects.size()) != 0) {
                    CDOLockState[] locksOnNewObjectsArray = locksOnNewObjects.toArray(new CDOLockState[locksOnNewObjectsCount]);
                    this.updateAndNotifyLockStates(CDOLockChangeInfo.Operation.LOCK, lockType, this.getTimeStamp(), locksOnNewObjectsArray);
                }
                if (var11_15 != null) {
                    this.updateAndNotifyLockStates(CDOLockChangeInfo.Operation.LOCK, lockType, var11_15.getTimestamp(), var11_15.getNewLockStates());
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected void updateAndNotifyLockStates(CDOLockChangeInfo.Operation op, IRWLockManager.LockType type, long timestamp, CDOLockState[] newLockStates) {
        this.updateLockStates(newLockStates);
        this.notifyOtherViewsAboutLockChanges(op, type, timestamp, newLockStates);
    }

    protected void updateLockStates(CDOLockState[] newLockStates) {
        this.updateLockStates(newLockStates, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLockStates(CDOLockState[] newLockStates, boolean loadObjectsOnDemand, Consumer<CDOLockState> consumer) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOLockState[] cDOLockStateArray = newLockStates;
                int n = newLockStates.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOLockState newLockState = cDOLockStateArray[n2];
                    Object lockedObject = newLockState.getLockedObject();
                    CDOID id = CDOLockUtil.getLockedObjectID((Object)lockedObject);
                    if (id == null && lockedObject instanceof EObject) {
                        CDOObject newObj = CDOUtil.getCDOObject((EObject)lockedObject);
                        id = newObj.cdoID();
                    }
                    if (id == null) {
                        throw new IllegalStateException("Unexpected: " + lockedObject.getClass().getSimpleName());
                    }
                    InternalCDOObject object2 = this.getObject(id, loadObjectsOnDemand);
                    if (object2 != null) {
                        InternalCDOLockState oldLockState = (InternalCDOLockState)this.lockStates.get(object2);
                        if (oldLockState != null) {
                            oldLockState.updateFrom(newLockState);
                            newLockState = oldLockState;
                        } else {
                            newLockState = CDOLockUtil.copyLockState((CDOLockState)newLockState);
                            this.lockStates.put(object2, newLockState);
                        }
                        if (consumer != null) {
                            consumer.accept(newLockState);
                        }
                    }
                    ++n2;
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected void notifyOtherViewsAboutLockChanges(CDOLockChangeInfo.Operation op, IRWLockManager.LockType type, long timestamp, CDOLockState[] lockStates) {
        if (lockStates.length > 0) {
            CDOLockChangeInfo lockChangeInfo = this.makeLockChangeInfo(op, type, timestamp, lockStates);
            this.session.handleLockNotification(lockChangeInfo, this, true);
            if (this.isActive()) {
                this.fireLocksChangedEvent(this, lockChangeInfo);
            }
        }
    }

    protected final CDOLockChangeInfo makeLockChangeInfo(CDOLockChangeInfo.Operation op, IRWLockManager.LockType type, long timestamp, CDOLockState[] newLockStates) {
        return CDOLockUtil.createLockChangeInfo((long)timestamp, (CDOCommonView)this, (CDOBranch)this.getBranch(), (CDOLockChangeInfo.Operation)op, (IRWLockManager.LockType)type, (CDOLockState[])newLockStates);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleLockNotification(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final void fireLocksChangedEvent(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.fireEvent(new ViewLocksChangedEvent(sender, lockChangeInfo), listeners);
        }
    }

    @Override
    public void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType) {
        this.unlockObjects(objects, lockType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, boolean recursive) {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                void var7_11;
                ArrayList<CDOID> objectIDs = null;
                LinkedList<Object> locksOnNewObjects = new LinkedList<Object>();
                if (objects != null) {
                    objectIDs = new ArrayList<CDOID>();
                    for (CDOObject cDOObject : this.getSet(objects)) {
                        if (FSMUtil.isNew(cDOObject)) {
                            InternalCDOLockState lockState = this.createUpdatedLockStateForNewObject(cDOObject, lockType, false);
                            locksOnNewObjects.add(lockState);
                            if (!recursive) continue;
                            TreeIterator it = cDOObject.eAllContents();
                            while (it.hasNext()) {
                                CDOObject child = CDOUtil.getCDOObject((EObject)it.next());
                                lockState = this.createUpdatedLockStateForNewObject(child, lockType, false);
                                locksOnNewObjects.add(lockState);
                            }
                            continue;
                        }
                        if (FSMUtil.isTransient(cDOObject)) {
                            CDOID id = this.getID((InternalCDOObject)cDOObject, true);
                            if (id == null) continue;
                            objectIDs.add(id);
                            continue;
                        }
                        objectIDs.add(cDOObject.cdoID());
                    }
                } else {
                    locksOnNewObjects.addAll(this.createUnlockedLockStatesForAllNewObjects());
                }
                Object var7_9 = null;
                if (objectIDs == null || !objectIDs.isEmpty()) {
                    CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                    CDOSessionProtocol.UnlockObjectsResult unlockObjectsResult = sessionProtocol.unlockObjects2(this, objectIDs, lockType, recursive);
                }
                CDOLockState[] locksOnNewObjectsArray = locksOnNewObjects.toArray(new CDOLockState[locksOnNewObjects.size()]);
                this.updateLockStates(locksOnNewObjectsArray);
                if (var7_11 != null) {
                    this.updateAndNotifyLockStates(CDOLockChangeInfo.Operation.UNLOCK, lockType, var7_11.getTimestamp(), var7_11.getNewLockStates());
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected InternalCDOLockState createUpdatedLockStateForNewObject(CDOObject object, IRWLockManager.LockType lockType, boolean on) {
        throw new ReadOnlyException();
    }

    protected Collection<CDOLockState> createUnlockedLockStatesForAllNewObjects() {
        return Collections.emptyList();
    }

    @Override
    public void unlockObjects() {
        this.unlockObjects(null, null);
    }

    @Override
    public boolean isObjectLocked(CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
        this.checkActive();
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            boolean bl;
            this.lockView();
            try {
                CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                bl = sessionProtocol.isObjectLocked(this, object, lockType, byOthers);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return bl;
        }
    }

    public boolean isDurableView() {
        return this.durableLockingID != null;
    }

    public String getDurableLockingID() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            String string;
            this.lockView();
            try {
                string = this.durableLockingID;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return string;
        }
    }

    @Override
    @Deprecated
    public String enableDurableLocking(boolean enable) {
        if (enable) {
            return this.enableDurableLocking();
        }
        this.disableDurableLocking(false);
        return null;
    }

    @Override
    public String enableDurableLocking() {
        String oldID = this.durableLockingID;
        try {
            Object object = this.getViewMonitor();
            synchronized (object) {
                String string;
                this.lockView();
                try {
                    if (this.durableLockingID == null) {
                        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                        this.durableLockingID = sessionProtocol.changeLockArea(this, true);
                    }
                    this.lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
                    string = this.durableLockingID;
                }
                catch (Throwable throwable) {
                    this.unlockView();
                    throw throwable;
                }
                this.unlockView();
                return string;
            }
        }
        finally {
            this.fireDurabilityChangedEvent(oldID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableDurableLocking(boolean releaseLocks) {
        String oldID = this.durableLockingID;
        try {
            Object object = this.getViewMonitor();
            synchronized (object) {
                this.lockView();
                try {
                    CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                    if (this.durableLockingID != null) {
                        sessionProtocol.changeLockArea(this, false);
                        this.durableLockingID = null;
                        this.lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
                        if (releaseLocks) {
                            this.unlockObjects();
                        }
                    }
                }
                finally {
                    this.unlockView();
                }
            }
        }
        finally {
            this.fireDurabilityChangedEvent(oldID);
        }
    }

    private void fireDurabilityChangedEvent(final String oldID) {
        if (!ObjectUtil.equals((Object)oldID, (Object)this.durableLockingID)) {
            this.fireEvent(new CDOViewDurabilityChangedEvent(){

                @Override
                public CDOView getSource() {
                    return CDOViewImpl.this;
                }

                @Override
                public String getOldDurableLockingID() {
                    return oldID;
                }

                @Override
                public String getNewDurableLockingID() {
                    return CDOViewImpl.this.durableLockingID;
                }
            });
        }
    }

    @Override
    @Deprecated
    public CDOFeatureAnalyzer getFeatureAnalyzer() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOFeatureAnalyzer cDOFeatureAnalyzer;
            this.lockView();
            try {
                cDOFeatureAnalyzer = this.options().getFeatureAnalyzer();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOFeatureAnalyzer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.options.setFeatureAnalyzer(featureAnalyzer);
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public InternalCDOTransaction toTransaction() {
        this.checkActive();
        if (this instanceof InternalCDOTransaction) {
            return (InternalCDOTransaction)((Object)this);
        }
        throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.0"), this));
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, boolean loadOnDemand) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            InternalCDORevision internalCDORevision;
            this.lockView();
            try {
                InternalCDORevisionManager revisionManager = this.session.getRevisionManager();
                int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
                CDOBranchPoint branchPoint = this.getBranchPointForID(id);
                internalCDORevision = revisionManager.getRevision(id, branchPoint, initialChunkSize, 0, loadOnDemand);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return internalCDORevision;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapObject(CDOID oldID) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                InternalCDOObject object2 = this.remapObjectSynced(oldID);
                InternalCDOLockState oldLockState = (InternalCDOLockState)this.lockStates.remove(object2);
                if (oldLockState != null) {
                    Object lockedObject = CDOViewImpl.getLockTarget(object2);
                    InternalCDOLockState newLockState = (InternalCDOLockState)CDOLockUtil.createLockState((Object)lockedObject);
                    newLockState.updateFrom((CDOLockState)oldLockState);
                    this.lockStates.put(object2, (CDOLockState)newLockState);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    protected void objectRegistered(InternalCDOObject object) {
        super.objectRegistered(object);
        this.unitManager.addObject(object);
    }

    @Override
    protected void objectDeregistered(InternalCDOObject object) {
        this.lockStates.remove(object);
        super.objectDeregistered(object);
    }

    @Override
    public CDOLockOwner getLockOwner() {
        return this.lockOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLockStates(Consumer<CDOLockState> consumer) {
        this.checkActive();
        this.checkState(this.getTimeStamp() == 0L, "Locking not supported for historial views");
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOSessionProtocol sessionProtocol;
                CDOLockState[] loadedLockStates;
                if (this.options().isLockNotificationEnabled()) {
                    return;
                }
                ArrayList<CDOID> ids = new ArrayList<CDOID>();
                for (CDOObject object2 : this.lockStates.keySet()) {
                    ids.add(object2.cdoID());
                }
                if (!ids.isEmpty() && (loadedLockStates = (sessionProtocol = this.session.getSessionProtocol()).getLockStates(this.viewID, ids, 0)) != null && loadedLockStates.length != 0) {
                    this.updateLockStates(loadedLockStates);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOLockState[] getLockStates(Collection<CDOID> ids) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOLockState[] cDOLockStateArray;
            this.lockView();
            try {
                cDOLockStateArray = this.getLockStates(ids, true);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOLockStateArray;
        }
    }

    public CDOLockState[] getLockStates(Collection<CDOID> ids, boolean loadOnDemand) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOLockState[] cDOLockStateArray;
            this.lockView();
            try {
                CDOLockState newLockState;
                ArrayList<CDOLockState> result = new ArrayList<CDOLockState>();
                ArrayList<CDOLockState> lockStatesToUpdate = new ArrayList<CDOLockState>();
                LinkedHashSet<CDOID> missingIDs = new LinkedHashSet<CDOID>();
                for (CDOID id : ids) {
                    InternalCDOObject object2 = this.getObject(id, false);
                    if (object2 != null) {
                        CDOLockState lockState = this.lockStates.get(object2);
                        if (lockState != null) {
                            result.add(lockState);
                            continue;
                        }
                        if (loadOnDemand && FSMUtil.isNew(object2)) {
                            Object lockTarget = CDOViewImpl.getLockTarget(this, id);
                            newLockState = CDOLockUtil.createLockState((Object)lockTarget);
                            result.add(newLockState);
                            lockStatesToUpdate.add(newLockState);
                            continue;
                        }
                    }
                    missingIDs.add(id);
                }
                if (loadOnDemand && (!missingIDs.isEmpty() || ids.isEmpty())) {
                    CDOLockState loadedLockStates;
                    CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                    newLockState = loadedLockStates = sessionProtocol.getLockStates(this.viewID, missingIDs, 0);
                    int lockTarget = ((CDOLockState[])newLockState).length;
                    int n = 0;
                    while (n < lockTarget) {
                        CDOLockState loadedLockState = newLockState[n];
                        result.add(loadedLockState);
                        lockStatesToUpdate.add(loadedLockState);
                        CDOID id = CDOIDUtil.getCDOID((Object)loadedLockState.getLockedObject());
                        if (id != null) {
                            missingIDs.remove(id);
                        }
                        ++n;
                    }
                    for (CDOID missingID : missingIDs) {
                        Object lockTarget2 = CDOViewImpl.getLockTarget(this, missingID);
                        CDOLockState defaultLockState = CDOLockUtil.createLockState((Object)lockTarget2);
                        result.add(defaultLockState);
                        lockStatesToUpdate.add(defaultLockState);
                    }
                }
                if (!lockStatesToUpdate.isEmpty()) {
                    this.updateLockStates(lockStatesToUpdate.toArray(new CDOLockState[lockStatesToUpdate.size()]));
                }
                cDOLockStateArray = result.toArray(new CDOLockState[result.size()]);
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return cDOLockStateArray;
        }
    }

    public Map<CDOObject, CDOLockState> getLockStates() {
        return this.lockStates;
    }

    private CDOBranchPoint getBranchPointForID(CDOID id) {
        CDOBranchPoint branchPoint = this.getNormalizedBranchPoint();
        if (branchPoint.getTimeStamp() != 0L) {
            return branchPoint;
        }
        if (this.session.isSticky()) {
            branchPoint = this.session.getCommittedSinceLastRefresh(id);
            if (branchPoint == null) {
                branchPoint = this.getBranch().getPoint(this.session.getLastUpdateTime());
            }
            return branchPoint;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prefetchRevisions(CDOID id, int depth) {
        this.checkArg(depth != 0, "Prefetch depth must not be zero");
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
                this.prefetchRevisions(id, depth, initialChunkSize);
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected void prefetchRevisions(CDOID id, int depth, int initialChunkSize) {
        InternalCDORevisionManager revisionManager = this.session.getRevisionManager();
        revisionManager.getRevision(id, (CDOBranchPoint)this, initialChunkSize, depth, true);
    }

    @Override
    @Deprecated
    public void invalidate(CDOBranch branch, long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions, boolean async) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void invalidate(CDOBranch branch, long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions, boolean async, boolean clearResourcePathCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(InternalCDOView.ViewInvalidationData invalidationData) {
        if (invalidationData.isAsync()) {
            ViewInvalidation work = new ViewInvalidation(invalidationData);
            this.invalidator.execute((Runnable)((Object)work));
        } else {
            this.doInvalidate(invalidationData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvalidate(InternalCDOView.ViewInvalidationData invalidationData) {
        long timeStamp = invalidationData.getLastUpdateTime();
        try {
            Object object = this.getViewMonitor();
            synchronized (object) {
                this.lockView();
                try {
                    this.doInvalidateSynced(invalidationData);
                }
                finally {
                    this.unlockView();
                }
            }
            this.commitInfoDistributor.distribute(timeStamp);
        }
        catch (Error | RuntimeException ex) {
            this.commitInfoDistributor.error(timeStamp, ex);
        }
    }

    private void doInvalidateSynced(InternalCDOView.ViewInvalidationData invalidationData) {
        CDOBranchPoint head;
        if (invalidationData.getSecurityImpact() != 0 && !(head = this.session.getBranchManager().getMainBranch().getHead()).equals(this)) {
            throw new IllegalStateException("Security not supported with auditing or branching");
        }
        if (this.getTimeStamp() != 0L && CDOStateMachine.SWITCHING_TARGET.get() != Boolean.TRUE) {
            return;
        }
        long lastUpdateTime = invalidationData.getLastUpdateTime();
        try {
            try {
                if (invalidationData.getBranch() == this.getBranch()) {
                    if (invalidationData.isClearResourcePathCache()) {
                        this.clearResourcePathCacheIfNecessary(null);
                    }
                    ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>();
                    HashMap<CDOObject, CDORevisionDelta> revisionDeltas = new HashMap<CDOObject, CDORevisionDelta>();
                    HashSet<CDOObject> detachedObjects = new HashSet<CDOObject>();
                    Map oldRevisions = invalidationData.getOldRevisions();
                    if (oldRevisions == null) {
                        oldRevisions = CDOIDUtil.createMap();
                    }
                    Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts = this.invalidate(invalidationData.getAllChangedObjects(), invalidationData.getAllDetachedObjects(), deltas, revisionDeltas, detachedObjects, oldRevisions);
                    this.handleConflicts(lastUpdateTime, conflicts, deltas);
                    this.sendInvalidationNotifications(revisionDeltas.keySet(), detachedObjects);
                    this.fireInvalidationEvent(lastUpdateTime, Collections.unmodifiableMap(revisionDeltas), Collections.unmodifiableSet(detachedObjects));
                    if (!deltas.isEmpty() || !detachedObjects.isEmpty()) {
                        this.sendDeltaNotifications(deltas, detachedObjects, oldRevisions);
                    }
                    this.fireAdaptersNotifiedEvent(lastUpdateTime);
                    CDOLockChangeInfo lockChangeInfo = invalidationData.getLockChangeInfo();
                    if (lockChangeInfo != null) {
                        this.updateLockStates(lockChangeInfo.getLockStates());
                        this.fireLocksChangedEvent(null, lockChangeInfo);
                    }
                }
            }
            catch (RuntimeException ex) {
                if (this.isActive()) {
                    this.fireEvent((IEvent)new ThrowableEvent((INotifier)this, (Throwable)ex));
                    throw ex;
                }
                this.setLastUpdateTime(lastUpdateTime);
            }
        }
        finally {
            this.setLastUpdateTime(lastUpdateTime);
        }
    }

    public ViewInvalidator getInvalidator() {
        return this.invalidator;
    }

    @Override
    @Deprecated
    public boolean isInvalidationRunnerActive() {
        return this.isInvalidating();
    }

    @Override
    public boolean isInvalidating() {
        return this.invalidating;
    }

    private void sendInvalidationNotifications(Set<CDOObject> dirtyObjects, Set<CDOObject> detachedObjects) {
        if (this.options().isInvalidationNotificationEnabled()) {
            CDOInvalidationNotificationImpl notification;
            for (CDOObject dirtyObject : dirtyObjects) {
                if (!((InternalCDOObject)dirtyObject).eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(dirtyObject);
                dirtyObject.eNotify(notification);
            }
            for (CDOObject detachedObject : detachedObjects) {
                if (!((InternalCDOObject)detachedObject).eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(detachedObject);
                detachedObject.eNotify(notification);
            }
        }
    }

    private void fireInvalidationEvent(long timeStamp, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects) {
        IListener[] listeners;
        if (!(revisionDeltas.isEmpty() && detachedObjects.isEmpty() || (listeners = this.getListeners()) == null)) {
            this.fireEvent(new ViewInvalidationEvent(timeStamp, revisionDeltas, detachedObjects), listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDeltaNotifications(Collection<CDORevisionDelta> deltas, Set<CDOObject> detachedObjects, Map<CDOID, InternalCDORevision> oldRevisions) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (deltas != null) {
                    CDONotificationBuilder builder = new CDONotificationBuilder(this);
                    Map<CDOID, InternalCDOObject> objects = this.getModifiableObjects();
                    for (CDORevisionDelta delta : deltas) {
                        NotificationChain notification;
                        CDOID id = delta.getID();
                        InternalCDOObject object2 = objects.get(id);
                        if (object2 == null || !object2.eNotificationRequired()) continue;
                        InternalCDORevision oldRevision = null;
                        if (oldRevisions != null) {
                            oldRevision = oldRevisions.get(id);
                        }
                        if ((notification = builder.buildNotification(object2, oldRevision, delta, detachedObjects)) == null) continue;
                        notification.dispatch();
                    }
                }
                if (detachedObjects != null && !detachedObjects.isEmpty()) {
                    if (this.options().isDetachmentNotificationEnabled()) {
                        for (CDOObject detachedObject : detachedObjects) {
                            InternalCDOObject object3 = (InternalCDOObject)detachedObject;
                            if (!object3.eNotificationRequired()) continue;
                            new CDODeltaNotificationImpl((InternalEObject)object3, 111, null, null, null).dispatch();
                        }
                    }
                    this.changeSubscriptionManager.handleDetachedObjects(detachedObjects);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    private boolean isLocked(InternalCDOObject object) {
        if (object.cdoWriteLock().isLocked()) {
            return true;
        }
        return object.cdoReadLock().isLocked();
    }

    protected final AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAddAdapter(InternalCDOObject eObject, Adapter adapter) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (!FSMUtil.isNew(eObject)) {
                    this.subscribe(eObject, adapter);
                }
                this.adapterManager.attachAdapter(eObject, adapter);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoveAdapter(InternalCDOObject eObject, Adapter adapter) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (!FSMUtil.isNew(eObject)) {
                    this.unsubscribe(eObject, adapter);
                }
                this.adapterManager.detachAdapter(eObject, adapter);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(EObject eObject, Adapter adapter) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.changeSubscriptionManager != null) {
                    this.changeSubscriptionManager.subscribe(eObject, adapter);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(EObject eObject, Adapter adapter) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.changeSubscriptionManager != null) {
                    this.changeSubscriptionManager.unsubscribe(eObject, adapter);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasSubscription(CDOID id) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.changeSubscriptionManager != null) {
                    boolean bl = this.changeSubscriptionManager.getSubcribeObject(id) != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected final ChangeSubscriptionManager getChangeSubscriptionManager() {
        return this.changeSubscriptionManager;
    }

    protected void listenerAdded(IListener listener) {
        if (listener instanceof CDOCommitInfoHandler) {
            CDOCommitInfoHandler handler = (CDOCommitInfoHandler)listener;
            this.commitInfoDistributor.register(handler);
        }
    }

    protected void listenerRemoved(IListener listener) {
        if (listener instanceof CDOCommitInfoHandler) {
            CDOCommitInfoHandler handler = (CDOCommitInfoHandler)listener;
            this.commitInfoDistributor.deregister(handler);
        }
    }

    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.session, "session");
        this.checkState(this.viewID > 0, "viewID");
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        if (this.durableLockingID != null) {
            CDOBranchPoint branchPoint = sessionProtocol.openView(this.viewID, this.isReadOnly(), this.durableLockingID);
            this.basicSetBranchPoint(branchPoint);
        } else {
            sessionProtocol.openView(this.viewID, this.isReadOnly(), (CDOBranchPoint)this);
        }
        CDOViewRegistryImpl.INSTANCE.register(this);
        Runnable runnable = SessionUtil.getTestDelayInViewActivation();
        if (runnable != null) {
            runnable.run();
        }
        this.lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
        if (this.viewLock != null && Boolean.getBoolean("org.eclipse.emf.cdo.sync.tester")) {
            new SyncTester().start();
        }
        this.unitManager.activate();
    }

    protected void doAfterActivate() throws Exception {
        block2: {
            super.doAfterActivate();
            ExecutorService executorService = this.getExecutorService();
            this.invalidator.setDelegate(executorService);
            try {
                LifecycleUtil.activate((Object)((Object)this.invalidator));
            }
            catch (LifecycleException ex) {
                if (ex.getCause() instanceof InterruptedException) break block2;
                throw ex;
            }
        }
    }

    protected void doBeforeDeactivate() throws Exception {
        InternalCDOViewSet viewSet = this.getViewSet();
        viewSet.remove(this);
        CDOAdapterPolicy clearAdapterPolicy = this.options.getClearAdapterPolicy();
        if (clearAdapterPolicy == null) {
            clearAdapterPolicy = viewSet.getDefaultClearAdapterPolicy();
        }
        if (clearAdapterPolicy != null && clearAdapterPolicy != CDOAdapterPolicy.NONE) {
            this.clearAdapters(clearAdapterPolicy);
        }
        super.doBeforeDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeactivate() throws Exception {
        block36: {
            block34: {
                this.unitManager.deactivate();
                this.commitInfoDistributor.deactivate();
                CDOViewRegistryImpl.INSTANCE.deregister(this);
                LifecycleUtil.deactivate((Object)((Object)this.invalidator), (OMLogger.Level)OMLogger.Level.WARN);
                try {
                    try {
                        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                        if (LifecycleUtil.isActive((Object)sessionProtocol)) {
                            sessionProtocol.closeView(this.viewID);
                        }
                        break block34;
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        Object object = this.getViewMonitor();
                        synchronized (object) {
                            this.lockView();
                            try {
                                if (this.session.isActive() && !this.lockStates.isEmpty() && !this.isDurableView()) {
                                    ArrayList<CDOLockState> result = new ArrayList<CDOLockState>();
                                    for (CDOLockState lockState : this.lockStates.values()) {
                                        if (!((InternalCDOLockState)lockState).removeOwner(this.lockOwner)) continue;
                                        result.add(lockState);
                                    }
                                    if (!result.isEmpty()) {
                                        CDOLockState[] deactivateLockStates = result.toArray(new CDOLockState[result.size()]);
                                        long timeStamp = this.session.getLastUpdateTime();
                                        this.notifyOtherViewsAboutLockChanges(CDOLockChangeInfo.Operation.UNLOCK, null, timeStamp, deactivateLockStates);
                                    }
                                    this.lockStates.clear();
                                    this.lockOwner = null;
                                }
                            }
                            finally {
                                this.unlockView();
                            }
                            break block36;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = this.getViewMonitor();
                    synchronized (object) {
                        this.lockView();
                        try {
                            if (this.session.isActive() && !this.lockStates.isEmpty() && !this.isDurableView()) {
                                ArrayList<CDOLockState> result = new ArrayList<CDOLockState>();
                                for (CDOLockState lockState : this.lockStates.values()) {
                                    if (!((InternalCDOLockState)lockState).removeOwner(this.lockOwner)) continue;
                                    result.add(lockState);
                                }
                                if (!result.isEmpty()) {
                                    CDOLockState[] deactivateLockStates = result.toArray(new CDOLockState[result.size()]);
                                    long timeStamp = this.session.getLastUpdateTime();
                                    this.notifyOtherViewsAboutLockChanges(CDOLockChangeInfo.Operation.UNLOCK, null, timeStamp, deactivateLockStates);
                                }
                                this.lockStates.clear();
                                this.lockOwner = null;
                            }
                        }
                        finally {
                            this.unlockView();
                        }
                    }
                }
                throw throwable;
            }
            Object object = this.getViewMonitor();
            synchronized (object) {
                this.lockView();
                try {
                    if (this.session.isActive() && !this.lockStates.isEmpty() && !this.isDurableView()) {
                        ArrayList<CDOLockState> result = new ArrayList<CDOLockState>();
                        for (CDOLockState lockState : this.lockStates.values()) {
                            if (!((InternalCDOLockState)lockState).removeOwner(this.lockOwner)) continue;
                            result.add(lockState);
                        }
                        if (!result.isEmpty()) {
                            CDOLockState[] deactivateLockStates = result.toArray(new CDOLockState[result.size()]);
                            long timeStamp = this.session.getLastUpdateTime();
                            this.notifyOtherViewsAboutLockChanges(CDOLockChangeInfo.Operation.UNLOCK, null, timeStamp, deactivateLockStates);
                        }
                        this.lockStates.clear();
                        this.lockOwner = null;
                    }
                }
                finally {
                    this.unlockView();
                }
            }
        }
        try {
            this.session.viewDetached(this);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        this.changeSubscriptionManager = null;
        super.doDeactivate();
    }

    private void clearAdapters(CDOAdapterPolicy adapterPolicy) {
        try {
            for (CDOObject cDOObject : this.getModifiableObjects().values()) {
                EList adapters = cDOObject.eAdapters();
                if (adapters.isEmpty()) continue;
                Iterator it = adapters.iterator();
                while (it.hasNext()) {
                    boolean validAdapter;
                    Adapter adapter = (Adapter)it.next();
                    if (adapter instanceof CDOObjectWrapperBase) continue;
                    try {
                        validAdapter = adapterPolicy.isValid(cDOObject, adapter);
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        continue;
                    }
                    if (!validAdapter) continue;
                    try {
                        it.remove();
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            }
        }
        catch (Exception exception) {
            OM.LOG.error((Throwable)exception);
        }
    }

    @Override
    public long getLastUpdateTime() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            long l;
            this.lockView();
            try {
                l = this.lastUpdateTime;
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            this.unlockView();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.lastUpdateTime < lastUpdateTime) {
                    this.lastUpdateTime = lastUpdateTime;
                }
                if (this.viewLockCondition != null) {
                    this.viewLockCondition.signalAll();
                } else {
                    this.notifyAll();
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean waitForUpdate(long updateTime, long timeoutMillis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean runAfterUpdate(final long updateTime, final Runnable runnable) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                long lastUpdateTime = this.getLastUpdateTime();
                if (lastUpdateTime < updateTime) {
                    this.addListener(new IListener(){

                        public void notifyEvent(IEvent event) {
                            CDOViewInvalidationEvent e;
                            if (event instanceof CDOViewInvalidationEvent && (e = (CDOViewInvalidationEvent)event).getTimeStamp() >= updateTime) {
                                CDOViewImpl.this.removeListener(this);
                                runnable.run();
                            }
                        }
                    });
                    return false;
                }
            }
            finally {
                this.unlockView();
            }
        }
        runnable.run();
        return true;
    }

    @Override
    public void resourceLoaded(CDOResourceImpl resource, boolean loaded) {
        if (this.session.getRepositoryInfo().isSupportingUnits()) {
            this.unitManager.resourceLoaded(resource, loaded);
        }
    }

    @Override
    public final CDOUnitManagerImpl getUnitManager() {
        return this.unitManager;
    }

    public static Object getLockTarget(CDOObject object) {
        CDOView view = object.cdoView();
        if (view == null) {
            return null;
        }
        CDOID id = object.cdoID();
        return CDOViewImpl.getLockTarget(view, id);
    }

    public static Object getLockTarget(CDOView view, CDOID id) {
        if (view.getSession().getRepositoryInfo().isSupportingBranches()) {
            return CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)view.getBranch());
        }
        return id;
    }

    protected final class AdapterManager {
        private Set<CDOObject> objects = new HashBag();

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                for (CDOObject object : commitContext.getNewObjects().values()) {
                    this.attachObject(object);
                }
                for (CDOObject object : commitContext.getDetachedObjects().values()) {
                    this.detachObject(object);
                }
            }
        }

        private void attachObject(CDOObject object) {
            if (((InternalEObject)object).eNotificationRequired()) {
                CDOAdapterPolicy strongReferencePolicy = CDOViewImpl.this.options().getStrongReferencePolicy();
                int count = 0;
                for (Adapter adapter : object.eAdapters()) {
                    if (!strongReferencePolicy.isValid(object, adapter)) continue;
                    ++count;
                }
                int i = 0;
                while (i < count) {
                    this.objects.add(object);
                    ++i;
                }
            }
        }

        private void detachObject(CDOObject object) {
            while (this.objects.remove(object)) {
            }
        }

        private void attachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.add(object);
            }
        }

        private void detachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.remove(object);
            }
        }

        private void reset() {
            Set<CDOObject> oldObjects = this.objects;
            this.objects = new HashBag();
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                for (InternalCDOObject object : CDOViewImpl.this.getObjectsList()) {
                    this.attachObject(object);
                }
            }
            oldObjects.clear();
        }
    }

    public final class CDOUnitManagerImpl
    extends Container<CDOUnit>
    implements CDOUnitManager {
        private final Map<EObject, CDOUnit> unitPerRoot = new HashMap<EObject, CDOUnit>();
        private final Map<EObject, CDOUnit> unitPerObject = new HashMap<EObject, CDOUnit>();
        private CDOUnitImpl openingUnit;
        private Set<CDOID> openingIDs;
        private Map<CDOResource, CDOUnit> resourceUnits;

        @Override
        public CDOView getView() {
            return CDOViewImpl.this;
        }

        @Override
        public boolean isUnit(EObject root) {
            CDOUnitImpl unit = this.requestUnit(root, CDOProtocolConstants.UnitOpcode.CHECK, null);
            return unit != null;
        }

        @Override
        public CDOUnit createUnit(EObject root, boolean open, IProgressMonitor monitor) throws CDOUnitManager.UnitExistsException {
            CDOProtocolConstants.UnitOpcode opcode = open ? CDOProtocolConstants.UnitOpcode.CREATE_AND_OPEN : CDOProtocolConstants.UnitOpcode.CREATE;
            CDOUnitImpl unit = this.requestUnit(root, opcode, monitor);
            if (open) {
                if (unit == null) {
                    throw new CDOUnitManager.UnitExistsException();
                }
                this.fireElementAddedEvent(unit);
            }
            return unit;
        }

        @Override
        public CDOUnit openUnit(EObject root, boolean createOnDemand, IProgressMonitor monitor) throws CDOUnitManager.UnitNotFoundException {
            CDOProtocolConstants.UnitOpcode opcode = createOnDemand ? CDOProtocolConstants.UnitOpcode.OPEN_DEMAND_CREATE : CDOProtocolConstants.UnitOpcode.OPEN;
            CDOUnitImpl unit = this.requestUnit(root, opcode, monitor);
            if (unit == null) {
                throw new CDOUnitManager.UnitNotFoundException();
            }
            this.fireElementAddedEvent(unit);
            return unit;
        }

        public CDOUnit[] getElements() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOUnit[] cDOUnitArray;
                CDOViewImpl.this.lockView();
                try {
                    cDOUnitArray = this.unitPerRoot.values().toArray(new CDOUnit[this.unitPerRoot.size()]);
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOUnitArray;
            }
        }

        @Override
        public CDOUnit[] getOpenUnits() {
            return this.getElements();
        }

        @Override
        public CDOUnit getOpenUnit(EObject object) {
            Object object2 = CDOViewImpl.this.getViewMonitor();
            synchronized (object2) {
                CDOUnit cDOUnit;
                CDOViewImpl.this.lockView();
                try {
                    cDOUnit = this.getOpenUnitUnsynced(object);
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOUnit;
            }
        }

        public CDOUnit getOpenUnitUnsynced(EObject object) {
            CDOID id;
            CDOObject cdoObject;
            CDOUnit unit = this.unitPerObject.get(object);
            if (unit == null && this.openingUnit != null && (cdoObject = CDOUtil.getCDOObject(object)) != null && this.openingIDs.contains(id = cdoObject.cdoID())) {
                unit = this.openingUnit;
            }
            return unit;
        }

        public void addObject(InternalCDOObject object) {
            CDOUnit unit;
            if (!this.unitPerRoot.isEmpty() && (unit = this.getOpenUnitUnsynced(object)) == null) {
                EObject parent = this.getParent(object);
                CDOResourceImpl rootResource = CDOViewImpl.this.getRootResource();
                while (parent != null && parent != rootResource) {
                    unit = this.getOpenUnitUnsynced(parent);
                    if (unit != null) {
                        this.unitPerObject.put(object, unit);
                        CDOUnitImpl cDOUnitImpl = (CDOUnitImpl)unit;
                        cDOUnitImpl.elements = cDOUnitImpl.elements + 1;
                        break;
                    }
                    parent = this.getParent(parent);
                }
            }
        }

        public void removeObject(InternalCDOObject object) {
            CDOUnit unit;
            if (!this.unitPerRoot.isEmpty() && (unit = this.unitPerObject.remove(object)) != null) {
                if (unit.getRoot() == object) {
                    this.unitPerRoot.remove(object);
                }
                CDOUnitImpl cDOUnitImpl = (CDOUnitImpl)unit;
                cDOUnitImpl.elements = cDOUnitImpl.elements - 1;
            }
        }

        @Override
        public synchronized boolean isAutoResourceUnitsEnabled() {
            return this.resourceUnits != null;
        }

        @Override
        public synchronized void setAutoResourceUnitsEnabled(boolean enabled) {
            this.resourceUnits = enabled ? new HashMap<CDOResource, CDOUnit>() : null;
        }

        public synchronized void resourceLoaded(CDOResourceImpl resource, boolean loaded) {
            if (this.resourceUnits != null) {
                if (loaded) {
                    this.loadResource(resource);
                } else {
                    this.unloadResource(resource);
                }
            }
        }

        protected void doDeactivate() throws Exception {
            this.unitPerRoot.clear();
            this.unitPerObject.clear();
            super.doDeactivate();
        }

        private void loadResource(CDOResource resource) {
            CDOUnit unit = this.resourceUnits.get(resource);
            if (unit == null) {
                CDOUnitManager unitManager = resource.cdoView().getUnitManager();
                unit = unitManager.openUnit(resource, true, null);
                this.resourceUnits.put(resource, unit);
            }
        }

        private void unloadResource(CDOResource resource) {
            CDOUnit unit = this.resourceUnits.remove(resource);
            if (unit != null) {
                unit.close();
            }
        }

        private EObject getParent(EObject object) {
            EObject parent = object.eContainer();
            if (parent == null) {
                parent = (EObject)((InternalEObject)object).eDirectResource();
            }
            return parent;
        }

        private CDOObject getCDORoot(EObject root) {
            CDOObject cdoRoot = CDOUtil.getCDOObject(root);
            if (cdoRoot == null) {
                throw new IllegalArgumentException("Root " + root + " is not managed by CDO");
            }
            CDOView view = cdoRoot.cdoView();
            if (view != CDOViewImpl.this) {
                throw new IllegalArgumentException("Root " + root + " is managed by " + view);
            }
            return cdoRoot;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private CDOUnitImpl requestUnit(EObject root, CDOProtocolConstants.UnitOpcode opcode, IProgressMonitor monitor) {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOSessionProtocol sessionProtocol;
                boolean success;
                CDOViewImpl.this.lockView();
                if (opcode.isCreate()) {
                    CDOUnit containingUnit = this.getOpenUnit(root);
                    if (containingUnit != null) {
                        throw new CDOException("Attempt to nest the new unit " + root + " in the existing unit " + containingUnit);
                    }
                    for (CDOUnit existingUnit : this.unitPerRoot.values()) {
                        if (!EcoreUtil.isAncestor((EObject)root, (EObject)existingUnit.getRoot())) continue;
                        throw new CDOException("Attempt to nest the existing unit " + existingUnit + " in the new unit " + root);
                    }
                }
                final InternalCDORevisionManager revisionManager = CDOViewImpl.this.session.getRevisionManager();
                this.openingUnit = new CDOUnitImpl(root);
                int viewID = CDOViewImpl.this.getViewID();
                CDOID rootID = this.getCDORoot(root).cdoID();
                CDORevisionHandler revisionHandler = null;
                final ArrayList revisions = new ArrayList();
                if (opcode.isOpen()) {
                    this.openingIDs = new HashSet<CDOID>();
                    revisionHandler = new CDORevisionHandler(){

                        public boolean handleRevision(CDORevision revision) {
                            CDOUnitImpl cDOUnitImpl = CDOUnitManagerImpl.this.openingUnit;
                            cDOUnitImpl.elements = cDOUnitImpl.elements + 1;
                            revisionManager.addRevision(revision);
                            revisions.add(revision);
                            CDOID id = revision.getID();
                            CDOViewImpl.this.changeSubscriptionManager.removeEntry(id);
                            CDOUnitManagerImpl.this.openingIDs.add(id);
                            return true;
                        }
                    };
                }
                if (success = (sessionProtocol = CDOViewImpl.this.session.getSessionProtocol()).requestUnit(viewID, rootID, opcode, revisionHandler, EclipseMonitor.safe((IProgressMonitor)monitor))) {
                    if (revisionHandler != null) {
                        this.unitPerRoot.put(root, this.openingUnit);
                        this.unitPerObject.put(root, this.openingUnit);
                        for (CDORevision revision : revisions) {
                            CDOID id = revision.getID();
                            InternalCDOObject object2 = CDOViewImpl.this.getObject(id);
                            this.unitPerObject.put(object2, this.openingUnit);
                        }
                    }
                    CDOUnitImpl cDOUnitImpl = this.openingUnit;
                    return cDOUnitImpl;
                }
                return null;
                finally {
                    this.openingUnit = null;
                    this.openingIDs = null;
                    CDOViewImpl.this.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeUnit(CDOUnit unit, boolean resubscribe) {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    this.requestUnit(unit.getRoot(), CDOProtocolConstants.UnitOpcode.CLOSE, null);
                    if (resubscribe && !CDOViewImpl.this.options.hasChangeSubscriptionPolicies()) {
                        resubscribe = false;
                    }
                    Iterator<Map.Entry<EObject, CDOUnit>> it = this.unitPerObject.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<EObject, CDOUnit> entry = it.next();
                        if (entry.getValue() != unit) continue;
                        it.remove();
                        if (!resubscribe) continue;
                        EObject object2 = entry.getKey();
                        for (Adapter adapter : object2.eAdapters()) {
                            CDOViewImpl.this.changeSubscriptionManager.subscribe(object2, adapter);
                        }
                    }
                    this.unitPerRoot.remove(unit.getRoot());
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireElementRemovedEvent(unit);
        }

        public final class CDOUnitImpl
        implements CDOUnit {
            private final EObject root;
            private int elements;

            public CDOUnitImpl(EObject root) {
                this.root = root;
            }

            @Override
            public CDOUnitManagerImpl getManager() {
                return CDOUnitManagerImpl.this;
            }

            @Override
            public EObject getRoot() {
                return this.root;
            }

            @Override
            public int getElements() {
                return this.elements;
            }

            @Override
            public void close() {
                this.close(true);
            }

            @Override
            public void close(boolean resubscribe) {
                CDOUnitManagerImpl.this.closeUnit(this, resubscribe);
            }

            public String toString() {
                return "CDOUnit[" + this.root + "]";
            }
        }
    }

    protected final class ChangeSubscriptionManager {
        private Map<CDOID, SubscribeEntry> subscriptions = CDOIDUtil.createMap();

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.handleNewObjects(commitContext.getNewObjects().values());
            this.handleDetachedObjects(commitContext.getDetachedObjects().values());
        }

        private boolean hasSubscriptions() {
            return !this.subscriptions.isEmpty();
        }

        private void subscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, 1);
        }

        private void unsubscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, -1);
        }

        private void handleChangeSubcriptionPoliciesChanged() {
            boolean policiesPresent = CDOViewImpl.this.options().hasChangeSubscriptionPolicies();
            this.subscriptions.clear();
            ArrayList<CDOID> ids = new ArrayList<CDOID>();
            if (policiesPresent) {
                for (InternalCDOObject object : CDOViewImpl.this.getObjectsList()) {
                    int count = this.getNumberOfValidAdapters(object);
                    if (count <= 0) continue;
                    ids.add(object.cdoID());
                    this.addEntry(object.cdoID(), object, count);
                }
            }
            this.request(ids, true, true);
        }

        private void handleDetachedObjects(Collection<CDOObject> detachedObjects) {
            for (CDOObject detachedObject : detachedObjects) {
                CDOID id = detachedObject.cdoID();
                SubscribeEntry entry = this.subscriptions.get(id);
                if (entry == null) continue;
                this.detachObject(id);
            }
        }

        private void handleNewObjects(Collection<? extends CDOObject> newObjects) {
            for (CDOObject cDOObject : newObjects) {
                int count;
                InternalCDOObject internalObject = (InternalCDOObject)cDOObject;
                if (internalObject == null || (count = this.getNumberOfValidAdapters(internalObject)) <= 0) continue;
                this.subscribe(internalObject.cdoID(), internalObject, count);
            }
        }

        private InternalCDOObject getSubcribeObject(CDOID id) {
            SubscribeEntry entry = this.subscriptions.get(id);
            if (entry != null) {
                return entry.getObject();
            }
            return null;
        }

        private void request(List<CDOID> ids, boolean clear, boolean subscribeMode) {
            CDOSessionProtocol sessionProtocol = CDOViewImpl.this.session.getSessionProtocol();
            sessionProtocol.changeSubscription(CDOViewImpl.this.getViewID(), ids, subscribeMode, clear);
        }

        private int getNumberOfValidAdapters(InternalCDOObject object) {
            int count = 0;
            if (!FSMUtil.isTransient(object) && !FSMUtil.isNew(object) && object.eNotificationRequired()) {
                EObject instance = CDOUtil.getEObject(object);
                for (Adapter adapter : instance.eAdapters()) {
                    if (!this.shouldSubscribe(object, adapter)) continue;
                    ++count;
                }
            }
            return count;
        }

        private void subscribe(EObject eObject, Adapter adapter, int adjust) {
            if (this.shouldSubscribe(eObject, adapter)) {
                CDOViewImpl view = CDOViewImpl.this;
                InternalCDOObject internalCDOObject = FSMUtil.adapt(eObject, view);
                if (internalCDOObject.cdoView() != view) {
                    throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.27"), internalCDOObject));
                }
                this.subscribe(internalCDOObject.cdoID(), internalCDOObject, adjust);
            }
        }

        private boolean shouldSubscribe(EObject eObject, Adapter adapter) {
            if (adapter instanceof CDOLocalAdapter) {
                return false;
            }
            if (CDOViewImpl.this.unitManager.getOpenUnitUnsynced(eObject) != null) {
                return false;
            }
            CDOAdapterPolicy[] cDOAdapterPolicyArray = CDOViewImpl.this.options().getChangeSubscriptionPolicies();
            int n = cDOAdapterPolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOAdapterPolicy policy = cDOAdapterPolicyArray[n2];
                if (policy.isValid(eObject, adapter)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private void subscribe(CDOID id, InternalCDOObject cdoObject, int adjust) {
            boolean policiesPresent = CDOViewImpl.this.options().hasChangeSubscriptionPolicies();
            int count = 0;
            SubscribeEntry entry = this.subscriptions.get(id);
            if (entry == null) {
                if (adjust < 0) {
                    return;
                }
                if (policiesPresent) {
                    this.request(Collections.singletonList(id), false, true);
                }
            } else {
                count = entry.getCount();
            }
            if ((count += adjust) <= 0) {
                this.removeEntry(id);
                if (policiesPresent) {
                    this.request(Collections.singletonList(id), false, false);
                }
            } else if (entry == null) {
                this.addEntry(id, cdoObject, count);
            } else {
                entry.setCount(count);
            }
        }

        private void detachObject(CDOID id) {
            this.subscribe(id, null, Integer.MIN_VALUE);
        }

        private void addEntry(CDOID id, InternalCDOObject object, int count) {
            this.subscriptions.put(id, new SubscribeEntry(object, count));
        }

        private void removeEntry(CDOID id) {
            this.subscriptions.remove(id);
        }
    }

    private final class CommitInfoDistributor
    implements IListener,
    IDeactivateable {
        private final ConcurrentArray<CDOCommitInfoHandler> handlers = new ConcurrentArray<CDOCommitInfoHandler>(){

            protected CDOCommitInfoHandler[] newArray(int length) {
                return new CDOCommitInfoHandler[length];
            }

            protected void firstElementAdded() {
                CDOViewImpl.this.getSession().addListener(CommitInfoDistributor.this);
            }

            protected void lastElementRemoved() {
                CDOViewImpl.this.getSession().removeListener(CommitInfoDistributor.this);
                CommitInfoDistributor.this.deactivate();
            }
        };
        private final Map<Long, CDOCommitInfo> commitInfos = new ConcurrentHashMap<Long, CDOCommitInfo>();

        public Exception deactivate() {
            this.commitInfos.clear();
            return null;
        }

        public void register(CDOCommitInfoHandler handler) {
            CheckUtil.checkArg((Object)handler, (String)"handler");
            this.handlers.add((Object)handler);
        }

        public void deregister(CDOCommitInfoHandler handler) {
            CheckUtil.checkArg((Object)handler, (String)"handler");
            this.handlers.remove((Object)handler);
        }

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOSessionInvalidationEvent) {
                CDOSessionInvalidationEvent e = (CDOSessionInvalidationEvent)event;
                this.commitInfos.put(e.getTimeStamp(), e);
            }
        }

        public void error(long timeStamp, Throwable t) {
            this.commitInfos.remove(timeStamp);
        }

        public void distribute(long timeStamp) {
            CDOCommitInfo commitInfo = this.commitInfos.remove(timeStamp);
            if (commitInfo != null) {
                this.distributeSafe(commitInfo, (CDOCommitInfoHandler[])this.handlers.get());
            }
        }

        private void distributeSafe(CDOCommitInfo commitInfo, CDOCommitInfoHandler[] handlers) {
            if (handlers != null) {
                ObjectUtil.forEachSafe((Object[])handlers, handler -> handler.handleCommitInfo(commitInfo));
            }
        }
    }

    public class OptionsImpl
    extends Notifier
    implements CDOView.Options {
        private boolean loadNotificationEnabled;
        private boolean detachmentNotificationEnabled;
        private boolean invalidationNotificationEnabled;
        private CDOInvalidationPolicy invalidationPolicy = CDOInvalidationPolicy.DEFAULT;
        private boolean lockNotificationsEnabled;
        @Deprecated
        private CDOLockStatePrefetcher lockStatePrefetcher;
        private CDORevisionPrefetchingPolicy revisionPrefetchingPolicy = CDOUtil.createRevisionPrefetchingPolicy(1);
        private CDOFeatureAnalyzer featureAnalyzer = CDOFeatureAnalyzer.NOOP;
        private CDOStaleReferencePolicy staleReferencePolicy = CDOStaleReferencePolicy.DEFAULT;
        private HashBag<CDOAdapterPolicy> changeSubscriptionPolicies = new HashBag();
        private CDOAdapterPolicy strongReferencePolicy = CDOAdapterPolicy.ALL;
        private CDOAdapterPolicy clearAdapterPolicy;

        public void recoverView() {
            if (this.lockNotificationsEnabled) {
                CDOSessionProtocol protocol = CDOViewImpl.this.session.getSessionProtocol();
                protocol.enableLockNotifications(CDOViewImpl.this.viewID, true);
            }
            if (CDOViewImpl.this.changeSubscriptionManager.hasSubscriptions()) {
                CDOViewImpl.this.changeSubscriptionManager.handleChangeSubcriptionPoliciesChanged();
            }
        }

        @Override
        public CDOViewImpl getContainer() {
            return CDOViewImpl.this;
        }

        @Override
        public boolean isLoadNotificationEnabled() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                boolean bl;
                CDOViewImpl.this.lockView();
                try {
                    bl = this.loadNotificationEnabled;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLoadNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            LoadNotificationEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.loadNotificationEnabled != enabled) {
                        this.loadNotificationEnabled = enabled;
                        event = new LoadNotificationEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public boolean isDetachmentNotificationEnabled() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                boolean bl;
                CDOViewImpl.this.lockView();
                try {
                    bl = this.detachmentNotificationEnabled;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDetachmentNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            DetachmentNotificationEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.detachmentNotificationEnabled != enabled) {
                        this.detachmentNotificationEnabled = enabled;
                        event = new DetachmentNotificationEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public boolean isInvalidationNotificationEnabled() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                boolean bl;
                CDOViewImpl.this.lockView();
                try {
                    bl = this.invalidationNotificationEnabled;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInvalidationNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            InvalidationNotificationEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.invalidationNotificationEnabled != enabled) {
                        this.invalidationNotificationEnabled = enabled;
                        event = new InvalidationNotificationEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDOInvalidationPolicy getInvalidationPolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOInvalidationPolicy cDOInvalidationPolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDOInvalidationPolicy = this.invalidationPolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOInvalidationPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInvalidationPolicy(CDOInvalidationPolicy policy) {
            CDOViewImpl.this.checkActive();
            InvalidationPolicyEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.invalidationPolicy != policy) {
                        this.invalidationPolicy = policy;
                        event = new InvalidationPolicyEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        public boolean isLockNotificationEnabled() {
            return this.lockNotificationsEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLockNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            LockNotificationEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (enabled != this.lockNotificationsEnabled) {
                        CDOSessionProtocol protocol = CDOViewImpl.this.session.getSessionProtocol();
                        protocol.enableLockNotifications(CDOViewImpl.this.viewID, enabled);
                        this.lockNotificationsEnabled = enabled;
                        event = new LockNotificationEventImpl(enabled);
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Deprecated
        public boolean isLockStatePrefetchEnabled() {
            return this.lockStatePrefetcher != null;
        }

        @Deprecated
        public void setLockStatePrefetchEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            if (enabled) {
                if (this.lockStatePrefetcher == null) {
                    this.lockStatePrefetcher = new CDOLockStatePrefetcher(CDOViewImpl.this, false);
                }
            } else if (this.lockStatePrefetcher != null) {
                this.lockStatePrefetcher.dispose();
                this.lockStatePrefetcher = null;
            }
        }

        @Deprecated
        public CDOLockStateLoadingPolicy getLockStateLoadingPolicy() {
            return new CDOLockStateLoadingPolicy(){

                @Override
                public boolean loadLockState(CDOID id) {
                    Predicate<CDOID> filter = OptionsImpl.this.lockStatePrefetcher == null ? CDOLockStatePrefetcher.DEFAULT_OBJECT_FILTER : OptionsImpl.this.lockStatePrefetcher.getObjectFilter();
                    return filter.test(id);
                }
            };
        }

        @Deprecated
        public void setLockStateLoadingPolicy(CDOLockStateLoadingPolicy lockStateLoadingPolicy) {
            CDOViewImpl.this.checkActive();
            if (this.lockStatePrefetcher == null) {
                this.lockStatePrefetcher = new CDOLockStatePrefetcher(CDOViewImpl.this, false);
            }
            this.lockStatePrefetcher.setObjectFilter(id -> lockStateLoadingPolicy.loadLockState((CDOID)id));
        }

        public boolean hasChangeSubscriptionPolicies() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                boolean bl;
                CDOViewImpl.this.lockView();
                try {
                    bl = !this.changeSubscriptionPolicies.isEmpty();
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return bl;
            }
        }

        @Override
        public CDOAdapterPolicy[] getChangeSubscriptionPolicies() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOAdapterPolicy[] cDOAdapterPolicyArray;
                CDOViewImpl.this.lockView();
                try {
                    cDOAdapterPolicyArray = (CDOAdapterPolicy[])this.changeSubscriptionPolicies.toArray((Object[])new CDOAdapterPolicy[this.changeSubscriptionPolicies.size()]);
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOAdapterPolicyArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            CDOViewImpl.this.checkActive();
            ChangeSubscriptionPoliciesEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.changeSubscriptionPolicies.add((Object)policy)) {
                        CDOViewImpl.this.changeSubscriptionManager.handleChangeSubcriptionPoliciesChanged();
                        event = new ChangeSubscriptionPoliciesEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            CDOViewImpl.this.checkActive();
            ChangeSubscriptionPoliciesEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.changeSubscriptionPolicies.remove((Object)policy) && !this.changeSubscriptionPolicies.contains((Object)policy)) {
                        CDOViewImpl.this.changeSubscriptionManager.handleChangeSubcriptionPoliciesChanged();
                        event = new ChangeSubscriptionPoliciesEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDOAdapterPolicy getStrongReferencePolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOAdapterPolicy cDOAdapterPolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDOAdapterPolicy = this.strongReferencePolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOAdapterPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStrongReferencePolicy(CDOAdapterPolicy adapterPolicy) {
            CDOViewImpl.this.checkActive();
            if (adapterPolicy == null) {
                adapterPolicy = CDOAdapterPolicy.ALL;
            }
            ReferencePolicyEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.strongReferencePolicy != adapterPolicy) {
                        this.strongReferencePolicy = adapterPolicy;
                        CDOViewImpl.this.adapterManager.reset();
                        event = new ReferencePolicyEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDORevisionPrefetchingPolicy getRevisionPrefetchingPolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDORevisionPrefetchingPolicy cDORevisionPrefetchingPolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDORevisionPrefetchingPolicy = this.revisionPrefetchingPolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDORevisionPrefetchingPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRevisionPrefetchingPolicy(CDORevisionPrefetchingPolicy prefetchingPolicy) {
            CDOViewImpl.this.checkActive();
            if (prefetchingPolicy == null) {
                prefetchingPolicy = CDORevisionPrefetchingPolicy.NO_PREFETCHING;
            }
            RevisionPrefetchingPolicyEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.revisionPrefetchingPolicy != prefetchingPolicy) {
                        this.revisionPrefetchingPolicy = prefetchingPolicy;
                        event = new RevisionPrefetchingPolicyEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        public CDOFeatureAnalyzer getFeatureAnalyzer() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOFeatureAnalyzer cDOFeatureAnalyzer;
                CDOViewImpl.this.lockView();
                try {
                    cDOFeatureAnalyzer = this.featureAnalyzer;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOFeatureAnalyzer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
            CDOViewImpl.this.checkActive();
            if (featureAnalyzer == null) {
                featureAnalyzer = CDOFeatureAnalyzer.NOOP;
            }
            FeatureAnalyzerEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.featureAnalyzer != featureAnalyzer) {
                        this.featureAnalyzer = featureAnalyzer;
                        event = new FeatureAnalyzerEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Override
        @Deprecated
        public CDOStaleReferencePolicy getStaleReferenceBehaviour() {
            return this.getStaleReferencePolicy();
        }

        @Override
        @Deprecated
        public void setStaleReferenceBehaviour(CDOStaleReferencePolicy policy) {
            this.setStaleReferencePolicy(policy);
        }

        @Override
        public CDOStaleReferencePolicy getStaleReferencePolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOStaleReferencePolicy cDOStaleReferencePolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDOStaleReferencePolicy = this.staleReferencePolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOStaleReferencePolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStaleReferencePolicy(CDOStaleReferencePolicy policy) {
            CDOViewImpl.this.checkActive();
            if (policy == null) {
                policy = CDOStaleReferencePolicy.DEFAULT;
            }
            StaleReferencePolicyEventImpl event = null;
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (this.staleReferencePolicy != policy) {
                        this.staleReferencePolicy = policy;
                        event = new StaleReferencePolicyEventImpl();
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ReferenceType getCacheReferenceType() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    Map<CDOID, InternalCDOObject> objects = CDOViewImpl.this.getModifiableObjects();
                    if (objects instanceof ReferenceValueMap.Strong) {
                        ReferenceType referenceType = ReferenceType.STRONG;
                        return referenceType;
                    }
                    if (objects instanceof ReferenceValueMap.Soft) {
                        ReferenceType referenceType = ReferenceType.SOFT;
                        return referenceType;
                    }
                    if (objects instanceof ReferenceValueMap.Weak) {
                        ReferenceType referenceType = ReferenceType.WEAK;
                        return referenceType;
                    }
                    throw new IllegalStateException(Messages.getString("CDOViewImpl.29"));
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setCacheReferenceType(ReferenceType referenceType) {
            CDOViewImpl.this.checkActive();
            if (referenceType == null) {
                referenceType = ReferenceType.SOFT;
            }
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    if (!CDOViewImpl.this.initObjectsMap(referenceType)) {
                        return false;
                    }
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent((IEvent)new CacheReferenceTypeEventImpl(), listeners);
            }
            return true;
        }

        @Override
        public CDOAdapterPolicy getClearAdapterPolicy() {
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOAdapterPolicy cDOAdapterPolicy;
                CDOViewImpl.this.lockView();
                try {
                    cDOAdapterPolicy = this.clearAdapterPolicy;
                }
                catch (Throwable throwable) {
                    CDOViewImpl.this.unlockView();
                    throw throwable;
                }
                CDOViewImpl.this.unlockView();
                return cDOAdapterPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setClearAdapterPolicy(CDOAdapterPolicy policy) {
            CDOViewImpl.this.checkActive();
            Object object = CDOViewImpl.this.getViewMonitor();
            synchronized (object) {
                CDOViewImpl.this.lockView();
                try {
                    this.clearAdapterPolicy = policy;
                }
                finally {
                    CDOViewImpl.this.unlockView();
                }
            }
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent((IEvent)new ClearAdapterPolicyEventImpl(), listeners);
            }
        }

        private final class CacheReferenceTypeEventImpl
        extends OptionsEvent
        implements CDOView.Options.CacheReferenceTypeEvent {
            private static final long serialVersionUID = 1L;

            public CacheReferenceTypeEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ChangeSubscriptionPoliciesEventImpl
        extends OptionsEvent
        implements CDOView.Options.ChangeSubscriptionPoliciesEvent {
            private static final long serialVersionUID = 1L;

            public ChangeSubscriptionPoliciesEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ClearAdapterPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.ClearAdapterPolicyEvent {
            private static final long serialVersionUID = 1L;

            public ClearAdapterPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class DetachmentNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.DetachmentNotificationEvent {
            private static final long serialVersionUID = 1L;

            public DetachmentNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class FeatureAnalyzerEventImpl
        extends OptionsEvent
        implements CDOView.Options.FeatureAnalyzerEvent {
            private static final long serialVersionUID = 1L;

            public FeatureAnalyzerEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationNotificationEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationPolicyEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LoadNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.LoadNotificationEvent {
            private static final long serialVersionUID = 1L;

            public LoadNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LockNotificationEventImpl
        extends OptionsEvent
        implements CDOCommonView.Options.LockNotificationEvent {
            private static final long serialVersionUID = 1L;
            private boolean enabled;

            public LockNotificationEventImpl(boolean enabled) {
                super((IOptions)OptionsImpl.this);
                this.enabled = enabled;
            }

            public boolean getEnabled() {
                return this.enabled;
            }
        }

        private final class ReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.ReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public ReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class RevisionPrefetchingPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.RevisionPrefetchingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public RevisionPrefetchingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class StaleReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.StaleReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public StaleReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    private static final class SubscribeEntry {
        private final InternalCDOObject object;
        private int count;

        public SubscribeEntry(InternalCDOObject object, int count) {
            this.object = object;
            this.count = count;
        }

        public InternalCDOObject getObject() {
            return this.object;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }

    private final class SyncTester
    extends Thread {
        private final CountDownLatch latch;

        public SyncTester() {
            super(CDOViewImpl.this + "-sync-tester");
            this.latch = new CountDownLatch(1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CDOViewImpl.this.addListener((IListener)new LifecycleEventAdapter(){

                protected void onAboutToDeactivate(ILifecycle lifecycle) {
                    SyncTester.this.latch.countDown();
                }
            });
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    private final class ViewInvalidation
    extends RunnableWithName {
        private final InternalCDOView.ViewInvalidationData invalidationData;

        public ViewInvalidation(InternalCDOView.ViewInvalidationData invalidationData) {
            this.invalidationData = invalidationData;
        }

        public String getName() {
            return "Invalidator-" + CDOViewImpl.this;
        }

        protected void doRun() {
            try {
                try {
                    CDOViewImpl.this.invalidating = true;
                    CDOViewImpl.this.doInvalidate(this.invalidationData);
                }
                catch (Exception ex) {
                    if (CDOViewImpl.this.isActive()) {
                        OM.LOG.error((Throwable)ex);
                    }
                    CDOViewImpl.this.invalidating = false;
                }
            }
            finally {
                CDOViewImpl.this.invalidating = false;
            }
        }
    }

    private final class ViewInvalidationEvent
    extends AbstractCDOView.Event
    implements CDOViewInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private long timeStamp;
        private Map<CDOObject, CDORevisionDelta> revisionDeltas;
        private Set<CDOObject> detachedObjects;

        public ViewInvalidationEvent(long timeStamp, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects) {
            super(CDOViewImpl.this);
            this.timeStamp = timeStamp;
            this.revisionDeltas = revisionDeltas;
            this.detachedObjects = detachedObjects;
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public Set<CDOObject> getDirtyObjects() {
            return this.revisionDeltas.keySet();
        }

        @Override
        public Map<CDOObject, CDORevisionDelta> getRevisionDeltas() {
            return this.revisionDeltas;
        }

        @Override
        public Set<CDOObject> getDetachedObjects() {
            return this.detachedObjects;
        }

        protected String formatEventName() {
            return "CDOViewInvalidationEvent";
        }

        protected String formatAdditionalParameters() {
            return "timeStamp=" + this.timeStamp + ", revisionDeltas=" + this.revisionDeltas + ", detachedObjects=" + this.detachedObjects + "]";
        }
    }

    private final class ViewInvalidator
    extends SerializingExecutor {
        private ViewInvalidator() {
        }
    }

    private final class ViewLocksChangedEvent
    extends DefaultLocksChangedEvent
    implements CDOViewLocksChangedEvent {
        private static final long serialVersionUID = 1L;

        public ViewLocksChangedEvent(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
            super((INotifier)CDOViewImpl.this, sender, lockChangeInfo);
        }

        @Override
        public InternalCDOView getSource() {
            return (InternalCDOView)super.getSource();
        }

        @Override
        public EObject[] getAffectedObjects() {
            ArrayList<EObject> objects = new ArrayList<EObject>();
            InternalCDOView view = this.getSource();
            CDOLockState[] lockStates = this.getLockStates();
            int i = 0;
            while (i < lockStates.length) {
                CDOObject object;
                CDOLockState lockState = lockStates[i];
                Object lockedObject = lockState.getLockedObject();
                CDOID id = null;
                if (lockedObject instanceof CDOIDAndBranch) {
                    CDOIDAndBranch idAndBranch = (CDOIDAndBranch)lockedObject;
                    if (idAndBranch.getBranch().getID() == view.getBranch().getID()) {
                        id = idAndBranch.getID();
                    }
                } else if (lockedObject instanceof CDOID) {
                    id = (CDOID)lockedObject;
                }
                if (id != null && (object = view.getObject(id, false)) != null) {
                    objects.add(CDOUtil.getEObject(object));
                }
                ++i;
            }
            return objects.toArray(new EObject[objects.size()]);
        }

        protected String formatEventName() {
            return "CDOViewLocksChangedEvent";
        }
    }
}

