/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.util;

import java.util.Comparator;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.Group;

public class DiscoveryConnectorComparator
implements Comparator<DiscoveryConnector> {
    private final ConnectorCategory category;

    public DiscoveryConnectorComparator(ConnectorCategory category) {
        if (category == null) {
            throw new IllegalArgumentException();
        }
        this.category = category;
    }

    private int computeGroupIndex(String groupId) {
        if (groupId != null) {
            int index = -1;
            for (Group group : this.category.getGroup()) {
                ++index;
                if (!group.getId().equals(groupId)) continue;
                return index;
            }
        }
        return -1;
    }

    @Override
    public int compare(DiscoveryConnector o1, DiscoveryConnector o2) {
        int i;
        int g2;
        if (o1.getCategory() != this.category || o2.getCategory() != this.category) {
            throw new IllegalArgumentException();
        }
        if (o1 == o2) {
            return 0;
        }
        int g1 = this.computeGroupIndex(o1.getGroupId());
        if (g1 != (g2 = this.computeGroupIndex(o2.getGroupId()))) {
            i = g1 == -1 ? 1 : (g2 == -1 ? -1 : g1 - g2);
        } else {
            i = o1.getName().compareToIgnoreCase(o2.getName());
            if (i == 0) {
                i = o1.getId().compareTo(o2.getId());
            }
        }
        return i;
    }
}

