/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.commons.core.AbstractErrorReporter;
import org.eclipse.mylyn.internal.tasks.bugs.TaskErrorReporter;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ErrorLogStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TasksBugsPlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.tasks.bugs";
    private static TasksBugsPlugin INSTANCE;
    private static TaskErrorReporter taskErrorReporter;

    public static TasksBugsPlugin getDefault() {
        return INSTANCE;
    }

    public static synchronized TaskErrorReporter getTaskErrorReporter() {
        if (taskErrorReporter == null) {
            taskErrorReporter = new TaskErrorReporter();
        }
        return taskErrorReporter;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        INSTANCE = null;
        super.stop(context);
    }

    public static class BugReporter
    extends AbstractErrorReporter {
        public int getPriority(IStatus status) {
            if (status instanceof ErrorLogStatus) {
                return PRIORITY_DEFAULT;
            }
            return PRIORITY_NONE;
        }

        public void handle(final IStatus status) {
            Display display;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (display = workbench.getDisplay()) != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TasksBugsPlugin.getTaskErrorReporter().handle(status);
                    }
                });
            }
        }
    }
}

