/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.config.SingleUMLReferenceCellEditorConfiguration;
import org.eclipse.papyrus.uml.nattable.config.utils.CellEditorConfigurationUtils;
import org.eclipse.papyrus.uml.nattable.converter.SingleUMLReferenceDisplayConverter;
import org.eclipse.papyrus.uml.nattable.editor.SingleReferenceValueCellEditor;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class UMLStereotypeSingleUMLReferenceCellEditorConfiguration
extends SingleUMLReferenceCellEditorConfiguration {
    public static final String ID = "org.eclipse.papyrus.uml.nattable.celleditor.configuration.UMLStereotypeSingleUMLReferenceCellEditorConfiguration.Reference";

    @Override
    public String getConfigurationId() {
        return ID;
    }

    @Override
    public boolean handles(Table table, Object axisElement) {
        Type type;
        Property prop;
        boolean result = false;
        String id = AxisUtils.getPropertyId((Object)axisElement);
        if (id != null && id.startsWith("property_of_stereotype:/") && (prop = UMLTableUtils.getRealStereotypeProperty(table.getContext(), id)) != null && !prop.isMultivalued() && !((type = prop.getType()) instanceof DataType) && type instanceof Element) {
            result = true;
        }
        return result;
    }

    @Override
    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        CellEditorConfigurationUtils.configureCellPainter(configRegistry, axis, configLabel);
        Object axisElement = AxisUtils.getRepresentedElement((Object)axis);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new SingleReferenceValueCellEditor(axisElement, modelManager.getTableAxisElementProvider()), "EDIT", configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new SingleUMLReferenceDisplayConverter(), "EDIT", configLabel);
    }
}

