/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformNamespaceUriResourceMap
extends HashMap<URI, Resource> {
    private EPackage.Registry registry;
    private URIConverter uriConverter;
    private boolean isInitialized = false;

    public PlatformNamespaceUriResourceMap(ResourceSet resourceSet) {
        this(resourceSet.getPackageRegistry(), resourceSet.getURIConverter());
    }

    public PlatformNamespaceUriResourceMap(EPackage.Registry registry, URIConverter uriConverter) {
        this.registry = registry;
        this.uriConverter = uriConverter;
    }

    private void initialize() {
        this.uriConverter.getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        this.isInitialized = true;
    }

    @Override
    public Resource get(Object key) {
        URI uri;
        Resource resource = (Resource)super.get(key);
        if (resource == null && key instanceof URI && (uri = (URI)key).isPlatform() && !URIConverter.INSTANCE.exists(uri, null)) {
            URI normalizedUri;
            if (!this.isInitialized) {
                this.initialize();
            }
            if (this.uriConverter.exists(normalizedUri = this.uriConverter.normalize(uri), null)) {
                Resource packageResource = null;
                try {
                    try {
                        EPackage ePackage;
                        packageResource = EmfUtil.loadResource((URI)normalizedUri);
                        EPackage rootPackage = EmfUtil.getFirstEPackageContent((Resource)packageResource);
                        if (rootPackage != null && (ePackage = this.registry.getEPackage(rootPackage.getNsURI())) != null && (resource = ePackage.eResource()) != null) {
                            this.put(uri, resource);
                        }
                    }
                    catch (Throwable throwable) {
                        if (packageResource != null) {
                            packageResource.unload();
                        }
                    }
                }
                finally {
                    if (packageResource != null) {
                        packageResource.unload();
                    }
                }
            }
        }
        return resource;
    }
}

