/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.util;

import org.eclipse.internal.xtend.util.WeakCache2;
import org.eclipse.internal.xtend.util.WeakInterningHashSet;

public class StringCache {
    private static final WeakCache2<String, String> cache = new WeakCache2();
    private static final String[] SHORT_STRINGS = new String[128];
    private static final WeakInterningHashSet<String> CACHE;

    static {
        char[] chars = new char[128];
        int c = 0;
        while (c < 128) {
            chars[c] = c;
            c = (char)(c + 1);
        }
        String string = new String(chars);
        int c2 = 0;
        while (c2 < 128) {
            StringCache.SHORT_STRINGS[c2] = string.substring(c2, c2 + 1);
            c2 = (char)(c2 + 1);
        }
        CACHE = new WeakInterningHashSet();
    }

    public static String getx(String s, boolean createNew) {
        char c;
        if ("::".equals(s)) {
            return "::";
        }
        if (s.length() == 1 && (c = s.charAt(0)) < '\u0080') {
            return SHORT_STRINGS[c];
        }
        String result = cache.get(s);
        if (result == null) {
            result = s;
            if (createNew) {
                StringCache.putx(s);
            }
        }
        return result;
    }

    public static String get(String s) {
        return CACHE.intern(s);
    }

    public static void putx(String s) {
        cache.put(new String(s), s);
    }
}

