/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.EcoreUtil;

public enum DBAnnotation {
    TABLE_MAPPING("tableMapping"),
    TABLE_NAME_PREFIX("tableNamePrefix"),
    TABLE_NAME("tableName"),
    COLUMN_NAME("columnName"),
    COLUMN_TYPE("columnType"),
    COLUMN_LENGTH("columnLength"),
    TYPE_MAPPING("typeMapping"),
    INVERSE_LIST("inverseList");

    public static final String SOURCE_URI = "http://www.eclipse.org/CDO/DBStore";
    public static final String TABLE_MAPPING_NONE = "NONE";
    private String keyword;

    private DBAnnotation(String keyword) {
        this.keyword = keyword;
    }

    public String getKeyword() {
        return this.keyword == null ? super.toString() : this.keyword;
    }

    public String getValue(EModelElement element) {
        String value = EcoreUtil.getAnnotation((EModelElement)element, (String)SOURCE_URI, (String)this.keyword);
        if (value != null && value.length() == 0) {
            return null;
        }
        return value;
    }

    public String toString() {
        return this.getKeyword();
    }
}

