/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories;

import java.util.Properties;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.ShowInActionProvider;
import org.eclipse.emf.cdo.explorer.ui.handlers.RepositoryCheckoutHandlerQuick;
import org.eclipse.emf.cdo.explorer.ui.repositories.CDORepositoryItemProvider;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.NewRepositoryWizard;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryManagerImpl;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class CDORepositoriesView
extends ContainerView {
    public static final String ID = "org.eclipse.emf.cdo.explorer.ui.CDORepositoriesView";
    public static final String SHOW_IN_MENU_ID = "org.eclipse.emf.cdo.explorer.ui.CDORepositoriesView.ShowInMenu";
    private final ActivityDetector activityDetector = new ActivityDetector();
    private CDORepositoryItemProvider itemProvider;
    private NewRepositoryAction newAction;
    private PropertyDialogAction propertiesAction;

    private static int getRepositoryTimeoutMillis() {
        return (Integer)OM.PREF_REPOSITORY_TIMEOUT_MINUTES.getValue() * 60 * 1000;
    }

    protected IContainer<?> getContainer() {
        return CDOExplorerUtil.getRepositoryManager();
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        this.itemProvider = new CDORepositoryItemProvider(this);
        return this.itemProvider;
    }

    protected Control createUI(Composite parent) {
        this.newAction = new NewRepositoryAction();
        return super.createUI(parent);
    }

    protected void initViewer() {
        super.initViewer();
        TreeViewer viewer = this.getViewer();
        viewer.addTreeListener((ITreeViewerListener)this.activityDetector);
        viewer.setComparator(null);
        UIUtil.addDragSupport((StructuredViewer)viewer);
        Tree tree = viewer.getTree();
        tree.addMouseListener((MouseListener)this.activityDetector);
        tree.addKeyListener((KeyListener)this.activityDetector);
        tree.getDisplay().timerExec(CDORepositoriesView.getRepositoryTimeoutMillis(), (Runnable)this.activityDetector);
        this.propertiesAction = new PropertyDialogAction(() -> this.getShell(), (ISelectionProvider)viewer);
        this.propertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
    }

    protected void fillLocalPullDown(IMenuManager manager) {
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        this.addCollapseAllAction((IContributionManager)manager);
        if (Boolean.getBoolean("cdo.explorer.testRepo")) {
            manager.add((IAction)new Action("Test"){

                public void run() {
                    Properties properties = new Properties();
                    properties.setProperty("type", "local");
                    properties.setProperty("label", "repo2");
                    properties.setProperty("name", "repo2");
                    properties.setProperty("versioningMode", CDORepository.VersioningMode.Branching.toString());
                    properties.setProperty("idGeneration", CDORepository.IDGeneration.Counter.toString());
                    properties.setProperty("tcpDisabled", "false");
                    properties.setProperty("tcpPort", "2037");
                    CDORepository repository = CDOExplorerUtil.getRepositoryManager().addRepository(properties);
                    repository.connect();
                    CDOSession session = repository.getSession();
                    CDOUtil.configureView((CDOView)transaction);
                    try (CDOTransaction transaction = session.openTransaction();){
                        try {
                            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/CDO/examples/company/1.0.0");
                            EClass eClass = (EClass)ePackage.getEClassifier("Company");
                            EObject company = EcoreUtil.create((EClass)eClass);
                            this.addChild(company, "categories", "Category");
                            this.addChild(company, "suppliers", "Supplier");
                            this.addChild(company, "customers", "Customer");
                            this.addChild(company, "purchaseOrders", "PurchaseOrder");
                            this.addChild(company, "salesOrders", "SalesOrder");
                            CDOResource resource = transaction.createResource("model1");
                            resource.getContents().add((Object)company);
                            transaction.commit();
                            RepositoryCheckoutHandlerQuick.checkout(repository, "online-transactional");
                        }
                        catch (ConcurrentAccessException ex) {
                            ex.printStackTrace();
                            transaction.close();
                        }
                        catch (CommitException ex) {
                            ex.printStackTrace();
                            transaction.close();
                        }
                    }
                }

                private void addChild(EObject company, String featureName, String className) {
                    EClass companyClass = company.eClass();
                    EObject object = EcoreUtil.create((EClass)((EClass)companyClass.getEPackage().getEClassifier(className)));
                    EList list = (EList)company.eGet(companyClass.getEStructuralFeature(featureName));
                    list.add((Object)object);
                }
            });
        }
        manager.add((IAction)this.newAction);
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        super.fillContextMenu(manager, selection);
        manager.add((IContributionItem)new Separator("group.new"));
        manager.add((IContributionItem)new GroupMarker("group.new.branch"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.open"));
        manager.add((IContributionItem)new GroupMarker("group.openWith"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("group.checkout"));
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.add((IContributionItem)new Separator("group.port"));
        manager.add((IContributionItem)new Separator("group.build"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("group.properties"));
        IWorkbenchPage page = this.getSite().getPage();
        Object selectedElement = selection.size() == 1 ? selection.getFirstElement() : null;
        MenuManager showInMenu = new MenuManager("Show In", SHOW_IN_MENU_ID);
        showInMenu.add((IContributionItem)new GroupMarker("group.top"));
        if (ShowInActionProvider.fillMenu(page, null, (IMenuManager)showInMenu, selectedElement)) {
            showInMenu.add((IContributionItem)new GroupMarker("additions"));
            manager.appendToGroup("group.open", (IContributionItem)showInMenu);
        }
        if (this.propertiesAction.isApplicableForSelection()) {
            manager.appendToGroup("group.properties", (IAction)this.propertiesAction);
        }
    }

    protected void doubleClicked(Object object) {
        CDORepository repository;
        if (object instanceof CDORepository && (repository = (CDORepository)object).getState() == CDORepository.State.Disconnected) {
            this.connectRepository(repository);
            return;
        }
        super.doubleClicked(object);
    }

    public void connectRepository(CDORepository repository) {
        this.itemProvider.connectRepository(repository);
    }

    public static void newRepository(Shell shell) {
        try {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)new NewRepositoryWizard());
            dialog.open();
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            throw ex;
        }
    }

    private final class ActivityDetector
    implements ITreeViewerListener,
    MouseListener,
    KeyListener,
    Runnable {
        private long lastActivity;

        public ActivityDetector() {
            this.detect();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.detect();
        }

        public void treeExpanded(TreeExpansionEvent event) {
            this.detect();
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.detect();
        }

        public void mouseDown(MouseEvent e) {
            this.detect();
        }

        public void mouseUp(MouseEvent e) {
            this.detect();
        }

        public void keyPressed(KeyEvent e) {
            this.detect();
        }

        public void keyReleased(KeyEvent e) {
            this.detect();
        }

        private void detect() {
            this.lastActivity = System.currentTimeMillis();
        }

        @Override
        public void run() {
            int timeout;
            Tree tree = CDORepositoriesView.this.getViewer().getTree();
            if (tree.isDisposed()) {
                return;
            }
            long now = System.currentTimeMillis();
            int wait = timeout = CDORepositoriesView.getRepositoryTimeoutMillis();
            if (this.lastActivity <= now - (long)timeout) {
                if (!((Boolean)OM.PREF_REPOSITORY_TIMEOUT_DISABLED.getValue()).booleanValue()) {
                    CDORepositoryManagerImpl repositoryManager = (CDORepositoryManagerImpl)CDORepositoriesView.this.getContainer();
                    repositoryManager.disconnectUnusedRepositories();
                }
            } else {
                wait = (int)((long)timeout - (now - this.lastActivity));
            }
            tree.getDisplay().timerExec(wait, (Runnable)this);
        }
    }

    private final class NewRepositoryAction
    extends Action {
        public NewRepositoryAction() {
            this.setText("New Repository");
            this.setToolTipText("Add a new repository");
            this.setImageDescriptor(OM.getImageDescriptor("icons/add.gif"));
        }

        public void run() {
            Shell shell = CDORepositoriesView.this.getSite().getShell();
            CDORepositoriesView.newRepository(shell);
        }
    }
}

