/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.part;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DefaultDiagramEditorUtil {
    public static final FileExistenceCheck EXISTS_IN_WORKSPACE = new FileExistenceCheck(){

        @Override
        public boolean fileExists(IPath filePath) {
            return ResourcesPlugin.getWorkspace().getRoot().exists(filePath);
        }
    };
    public static final FileExistenceCheck EXISTS_AS_IO_FILE = new FileExistenceCheck(){

        @Override
        public boolean fileExists(IPath filePath) {
            return filePath.toFile().exists();
        }
    };

    public static String getUniqueFileName(IPath containerFullPath, String fileName, String extension) {
        return DefaultDiagramEditorUtil.getUniqueFileName(containerFullPath, fileName, extension, EXISTS_IN_WORKSPACE);
    }

    public static String getUniqueFileName(IPath containerFullPath, String fileName, String extension, FileExistenceCheck check) {
        if (containerFullPath == null) {
            containerFullPath = new Path("");
        }
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = "default";
        }
        IPath filePath = containerFullPath.append(fileName);
        if (extension != null && !extension.equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension(extension);
        }
        extension = filePath.getFileExtension();
        fileName = filePath.removeFileExtension().lastSegment();
        int i = 1;
        while (check.fileExists(filePath)) {
            filePath = containerFullPath.append(String.valueOf(fileName) + ++i);
            if (extension == null) continue;
            filePath = filePath.addFileExtension(extension);
        }
        return filePath.lastSegment();
    }

    public static interface FileExistenceCheck {
        public boolean fileExists(IPath var1);
    }
}

