/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.problems;

import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiProblem
implements IApiProblem {
    private String fMessage = null;
    private String fResourcePath = null;
    private String fTypeName = null;
    private int fId = 0;
    private String[] fExtraArgumentIds = null;
    private Object[] fExtraArguments = null;
    private String[] fMessageArguments = null;
    private int fLineNumber = -1;
    private int fCharStart = -1;
    private int fCharEnd = -1;
    public static final int CATEGORY_MASK = -268435456;
    public static final int ELEMENT_KIND_MASK = 0xF000000;
    public static final int KIND_MASK = 0xF00000;
    public static final int FLAGS_MASK = 1044480;
    public static final int MESSAGE_MASK = 4095;
    public static final String COMPATIBILITY_STATUS = "compatibilityStatus";

    public ApiProblem(String path, String typeName, String[] messageargs, String[] argumentids, Object[] arguments, int linenumber, int charstart, int charend, int id) {
        this.fResourcePath = path;
        this.fTypeName = typeName;
        this.fId = id;
        this.fExtraArgumentIds = argumentids;
        this.fExtraArguments = arguments;
        this.fLineNumber = linenumber;
        this.fCharStart = charstart;
        this.fCharEnd = charend;
        this.fMessageArguments = messageargs;
    }

    @Override
    public int getId() {
        return this.fId;
    }

    @Override
    public int getCategory() {
        return this.fId & 0xF0000000;
    }

    @Override
    public int getMessageid() {
        return (this.fId & 0xFFF) >> 0;
    }

    @Override
    public int getFlags() {
        return (this.fId & 0xFF000) >> 12;
    }

    @Override
    public int getKind() {
        return (this.fId & 0xF00000) >> 20;
    }

    @Override
    public String getMessage() {
        if (this.fMessage == null) {
            this.fMessage = ApiProblemFactory.getLocalizedMessage(this);
        }
        return this.fMessage;
    }

    @Override
    public String getResourcePath() {
        return this.fResourcePath;
    }

    @Override
    public int getSeverity() {
        if (ApiPlugin.isRunningInFramework()) {
            return ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(this), null);
        }
        return 1;
    }

    @Override
    public int getElementKind() {
        return (this.fId & 0xF000000) >> 24;
    }

    @Override
    public int getLineNumber() {
        return this.fLineNumber;
    }

    @Override
    public int getCharStart() {
        return this.fCharStart;
    }

    @Override
    public int getCharEnd() {
        return this.fCharEnd;
    }

    @Override
    public String[] getExtraMarkerAttributeIds() {
        if (this.fExtraArguments == null || this.fExtraArgumentIds == null) {
            return new String[0];
        }
        if (this.fExtraArgumentIds.length != this.fExtraArguments.length) {
            return new String[0];
        }
        return this.fExtraArgumentIds;
    }

    @Override
    public Object[] getExtraMarkerAttributeValues() {
        if (this.fExtraArguments == null || this.fExtraArgumentIds == null) {
            return new String[0];
        }
        if (this.fExtraArgumentIds.length != this.fExtraArguments.length) {
            return new String[0];
        }
        return this.fExtraArguments;
    }

    @Override
    public String[] getMessageArguments() {
        if (this.fMessageArguments == null) {
            return new String[0];
        }
        return this.fMessageArguments;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiProblem) {
            IApiProblem problem = (IApiProblem)obj;
            if (problem.getId() == this.fId && this.argumentsEqual(problem.getMessageArguments())) {
                String typeName;
                String resourcePath = problem.getResourcePath();
                if (resourcePath == null) {
                    if (this.fResourcePath != null) {
                        return false;
                    }
                } else {
                    if (this.fResourcePath == null) {
                        return false;
                    }
                    if (!new Path(resourcePath).equals((Object)new Path(this.fResourcePath))) {
                        return false;
                    }
                }
                if ((typeName = problem.getTypeName()) == null) {
                    return this.fTypeName == null;
                }
                if (this.fTypeName == null) {
                    return false;
                }
                return typeName.equals(this.fTypeName);
            }
            return false;
        }
        return super.equals(obj);
    }

    private boolean argumentsEqual(String[] arguments) {
        String[] currentArguments = this.getMessageArguments();
        if (currentArguments == null && arguments != null || currentArguments != null && arguments == null) {
            return false;
        }
        boolean equal = true;
        if (currentArguments.length != arguments.length) {
            return false;
        }
        int i = 0;
        while (i < currentArguments.length) {
            equal &= currentArguments[i].equals(arguments[i]);
            ++i;
        }
        return equal;
    }

    private int argumentsHashcode(String[] arguments) {
        if (this.fMessageArguments == null) {
            return 0;
        }
        int hashcode = 0;
        String[] stringArray = this.fMessageArguments;
        int n = this.fMessageArguments.length;
        int n2 = 0;
        while (n2 < n) {
            String fMessageArgument = stringArray[n2];
            hashcode += fMessageArgument.hashCode();
            ++n2;
        }
        return hashcode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("API problem: ");
        buffer.append(this.fResourcePath != null ? this.fResourcePath : "no path").append("\n");
        buffer.append("\tseverity: ");
        buffer.append(Util.getSeverity(this.getSeverity())).append("\n");
        buffer.append("\tcategory: ");
        buffer.append(ApiProblem.getProblemCategory(this.getCategory())).append("\n");
        buffer.append("\telement kind: ");
        buffer.append(ApiProblem.getProblemElementKind(this.getCategory(), this.getElementKind())).append("\n");
        buffer.append("\tkind: ");
        buffer.append(ApiProblem.getProblemKind(this.getCategory(), this.getKind())).append("\n");
        buffer.append("\tflags: ");
        buffer.append(ApiProblem.getProblemFlagsName(this.getCategory(), this.getFlags())).append("\n");
        buffer.append("\tmessage id: ");
        buffer.append(this.getMessageid());
        buffer.append("\n\tmessage: ");
        buffer.append(this.getMessage());
        return buffer.toString();
    }

    public int hashCode() {
        return this.getId() + (this.fResourcePath != null ? this.fResourcePath.hashCode() : 0) + this.argumentsHashcode(this.fMessageArguments) + (this.fTypeName != null ? this.fTypeName.hashCode() : 0);
    }

    @Override
    public String getTypeName() {
        return this.fTypeName;
    }

    public static String getDescriptorKind(int kind) {
        switch (kind) {
            case 1: {
                return "PACKAGE";
            }
            case 5: {
                return "FIELD";
            }
            case 6: {
                return "METHOD";
            }
            case 2: {
                return "REFERENCE_TYPE";
            }
            case 7: {
                return "RESOURCE";
            }
        }
        return "UNKNOWN_ELEMENT_KIND";
    }

    public static String getTagsProblemKindName(int kind) {
        switch (kind) {
            case 1: {
                return "INVALID_SINCE_TAGS";
            }
            case 2: {
                return "MALFORMED_SINCE_TAGS";
            }
            case 3: {
                return "MISSING_SINCE_TAGS";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getUsageProblemKindName(int kind) {
        switch (kind) {
            case 1: {
                return "ILLEGAL_EXTEND";
            }
            case 4: {
                return "ILLEGAL_IMPLEMENT";
            }
            case 2: {
                return "ILLEGAL_INSTANTIATE";
            }
            case 3: {
                return "ILLEGAL_REFERENCE";
            }
            case 5: {
                return "ILLEGAL_OVERRIDE";
            }
            case 6: {
                return "API_LEAK";
            }
            case 7: {
                return "UNSUPPORTED_TAG_USE";
            }
            case 13: {
                return "UNSUPPORTED_ANNOTATION_USE";
            }
            case 9: {
                return "INVALID_REFERENCE_IN_SYSTEM_LIBRARIES";
            }
            case 10: {
                return "UNUSED_PROBLEM_FILTERS";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getVersionProblemKindName(int kind) {
        switch (kind) {
            case 2: {
                return "MINOR_VERSION_CHANGE";
            }
            case 1: {
                return "MAJOR_VERSION_CHANGE";
            }
            case 3: {
                return "MAJOR_VERSION_CHANGE_NO_BREAKAGE";
            }
            case 4: 
            case 8: 
            case 9: {
                return "MINOR_VERSION_CHANGE_NO_NEW_API";
            }
            case 5: {
                return "REEXPORTED_MAJOR_VERSION_CHANGE";
            }
            case 6: {
                return "REEXPORTED_MINOR_VERSION_CHANGE";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getApiComponentResolutionProblemKindName(int kind) {
        switch (kind) {
            case 1: {
                return "API_COMPONENT_RESOLUTION";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getApiBaselineProblemKindName(int kind) {
        switch (kind) {
            case 1: 
            case 2: {
                return "API_BASELINE_MISSING";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getApiUseScanProblemKindName(int kind) {
        switch (kind) {
            case 1: {
                return "API_USE_SCAN_TYPE_PROBLEM";
            }
            case 2: {
                return "API_USE_SCAN_METHOD_PROBLEM";
            }
            case 3: {
                return "API_USE_SCAN_FIELD_PROBLEM";
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getProblemKind(int category, int kind) {
        switch (category) {
            case 0x10000000: {
                return Util.getDeltaKindName(kind);
            }
            case 0x40000000: {
                return ApiProblem.getTagsProblemKindName(kind);
            }
            case 0x20000000: {
                return ApiProblem.getUsageProblemKindName(kind);
            }
            case 0x30000000: {
                return ApiProblem.getVersionProblemKindName(kind);
            }
            case 0x50000000: {
                return ApiProblem.getApiBaselineProblemKindName(kind);
            }
            case 0x60000000: {
                return ApiProblem.getApiComponentResolutionProblemKindName(kind);
            }
            case -2147483648: {
                return ApiProblem.getApiUseScanProblemKindName(kind);
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getProblemFlagsName(int category, int flags) {
        switch (category) {
            case 0x10000000: {
                return Util.getDeltaFlagsName(flags);
            }
            case 0x20000000: 
            case 0x30000000: 
            case 0x40000000: 
            case 0x50000000: 
            case 0x60000000: {
                switch (flags) {
                    case 1: {
                        return "LEAK_EXTENDS";
                    }
                    case 3: {
                        return "LEAK_FIELD";
                    }
                    case 2: {
                        return "LEAK_IMPLEMENTS";
                    }
                    case 5: {
                        return "LEAK_METHOD_PARAMETER";
                    }
                    case 6: {
                        return "LEAK_CONSTRUCTOR_PARAMETER";
                    }
                    case 4: {
                        return "LEAK_RETURN_TYPE";
                    }
                    case 7: {
                        return "CONSTRUCTOR_METHOD";
                    }
                    case 0: {
                        return "NO_FLAGS";
                    }
                    case 12: {
                        return "INDIRECT_REFERENCE";
                    }
                    case 8: {
                        return "METHOD";
                    }
                    case 9: {
                        return "FIELD";
                    }
                }
                return "UNKNOWN_FLAGS";
            }
            case -2147483648: {
                switch (flags) {
                    case 2: {
                        return "DELETED";
                    }
                    case 1: {
                        return "UNRESOLVED";
                    }
                }
                return "UNKNOWN_FLAGS";
            }
        }
        return "UNKNOWN_FLAGS";
    }

    public static String getProblemElementKind(int category, int kind) {
        switch (category) {
            case 0x10000000: 
            case 0x40000000: {
                return Util.getDeltaElementType(kind);
            }
            case 0x20000000: 
            case 0x30000000: 
            case 0x50000000: 
            case 0x60000000: {
                return ApiProblem.getDescriptorKind(kind);
            }
            case -2147483648: {
                return Util.getApiElementType(kind);
            }
        }
        return "UNKNOWN_KIND";
    }

    public static String getProblemCategory(int category) {
        switch (category) {
            case 0x10000000: {
                return "COMPATIBILITY";
            }
            case 0x40000000: {
                return "SINCETAGS";
            }
            case 0x20000000: {
                return "USAGE";
            }
            case 0x30000000: {
                return "VERSION";
            }
            case 0x50000000: {
                return "API_BASELINE";
            }
            case 0x60000000: {
                return "API_COMPONENT_RESOLUTION";
            }
            case -2147483648: {
                return "API_USE_SCAN_PROBLEM";
            }
        }
        return "UNKNOWN_CATEGORY";
    }
}

