/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OppositePropertyCallExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.utilities.VisitorExtension;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationVisitor
extends org.eclipse.ocl.parser.ValidationVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>
implements VisitorExtension<Boolean> {
    public ValidationVisitor(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> environment) {
        super(environment);
    }

    @Override
    public Boolean visitOppositePropertyCallExp(OppositePropertyCallExp pc) {
        EReference property = pc.getReferredOppositeProperty();
        OCLExpression source = pc.getSource();
        EClassifier type = (EClassifier)pc.getType();
        if (property == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullProperty_ERROR_, (Object)pc.toString());
            return this.validatorError(pc, message, "visitOppositePropertyCallExp");
        }
        if (source == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullNavigationSource_ERROR_, (Object)pc.toString());
            return this.validatorError(pc, message, "visitOppositePropertyCallExp");
        }
        if (type == null) {
            String message = OCLMessages.bind((String)OCLMessages.NullNavigationType_ERROR_, (Object)pc.toString());
            return this.validatorError(pc, message, "visitOppositePropertyCallExp");
        }
        EList qualifiers = pc.getQualifier();
        if (!qualifiers.isEmpty()) {
            List expectedQualifierTypes = this.uml.getQualifiers((Object)property);
            if (expectedQualifierTypes.size() != qualifiers.size()) {
                String message = OCLMessages.bind((String)OCLMessages.MismatchedQualifiers_ERROR_, (Object)pc.toString());
                return this.validatorError(pc, message, "visitOppositePropertyCallExp");
            }
            Iterator eiter = expectedQualifierTypes.iterator();
            Iterator qiter = qualifiers.iterator();
            while (eiter.hasNext()) {
                EClassifier expectedType = (EClassifier)this.getOCLType(eiter.next());
                OCLExpression qualifier = (OCLExpression)qiter.next();
                EClassifier qualifierType = (EClassifier)qualifier.getType();
                if ((TypeUtil.getRelationship((Environment)this.env, (Object)qualifierType, (Object)expectedType) & 3) != 0) continue;
                String message = OCLMessages.bind((String)OCLMessages.MismatchedQualifiers_ERROR_, (Object)pc.toString());
                return this.validatorError(pc, message, "visitPropertyCallExp");
            }
        }
        if (this.visitFeatureCallExp(pc).booleanValue()) {
            return Boolean.TRUE;
        }
        source.accept((Visitor)this);
        EClassifier refType = (EClassifier)TypeUtil.getPropertyType((Environment)this.env, (Object)((EClassifier)source.getType()), (Object)property);
        if (!pc.getQualifier().isEmpty() && refType instanceof CollectionType) {
            CollectionType ct = (CollectionType)refType;
            refType = (EClassifier)ct.getElementType();
        }
        return TypeUtil.exactTypeMatch((Environment)this.env, (Object)refType, (Object)type);
    }
}

