/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import org.apache.sshd.client.session.forward.PortForwardingTracker;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClientFactory;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.FtpChannel;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.SessionCloseListener;
import org.eclipse.jgit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshdSession
implements RemoteSession {
    private static final Logger LOG = LoggerFactory.getLogger(SshdSession.class);
    private static final Pattern SHORT_SSH_FORMAT = Pattern.compile("[-\\w.]+(?:@[-\\w.]+)?(?::\\d+)?");
    private static final int MAX_DEPTH = 10;
    private final CopyOnWriteArrayList<SessionCloseListener> listeners = new CopyOnWriteArrayList();
    private final URIish uri;
    private SshClient client;
    private ClientSession session;

    SshdSession(URIish uri, Supplier<SshClient> clientFactory) {
        this.uri = uri;
        this.client = clientFactory.get();
    }

    void connect(Duration timeout) throws IOException {
        if (!this.client.isStarted()) {
            this.client.start();
        }
        try {
            this.session = this.connect(this.uri, Collections.emptyList(), (SshFutureListener<CloseFuture>)((SshFutureListener)future -> this.notifyCloseListeners()), timeout, 10);
        }
        catch (IOException e) {
            this.disconnect(e);
            throw e;
        }
    }

    private ClientSession connect(URIish target, List<URIish> jumps, SshFutureListener<CloseFuture> listener, Duration timeout, int depth) throws IOException {
        if (--depth < 0) {
            throw new IOException(MessageFormat.format(SshdText.get().proxyJumpAbort, target));
        }
        HostConfigEntry hostConfig = this.getHostConfig(target.getUser(), target.getHost(), target.getPort());
        String host = hostConfig.getHostName();
        int port = hostConfig.getPort();
        List<URIish> hops = this.determineHops(jumps, hostConfig, target.getHost());
        ClientSession resultSession = null;
        ClientSession proxySession = null;
        ExplicitPortForwardingTracker portForward = null;
        try {
            if (!hops.isEmpty()) {
                URIish hop = hops.remove(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connecting to jump host {}", (Object)hop);
                }
                proxySession = this.connect(hop, hops, null, timeout, depth);
            }
            AttributeRepository context = null;
            if (proxySession != null) {
                SshdSocketAddress remoteAddress = new SshdSocketAddress(host, port);
                portForward = proxySession.createLocalPortForwardingTracker(SshdSocketAddress.LOCALHOST_ADDRESS, remoteAddress);
                context = AttributeRepository.ofKeyValuePair(JGitSshClient.LOCAL_FORWARD_ADDRESS, (Object)portForward.getBoundAddress());
            }
            resultSession = this.connect(hostConfig, context, timeout);
            if (proxySession != null) {
                ExplicitPortForwardingTracker tracker = portForward;
                ClientSession pSession = proxySession;
                resultSession.addCloseFutureListener(arg_0 -> SshdSession.lambda$1((PortForwardingTracker)tracker, pSession, arg_0));
                portForward = null;
                proxySession = null;
            }
            if (listener != null) {
                resultSession.addCloseFutureListener(listener);
            }
            resultSession.auth().verify(resultSession.getAuthTimeout());
            return resultSession;
        }
        catch (IOException e) {
            this.close((Closeable)portForward, e);
            this.close((Closeable)proxySession, e);
            this.close((Closeable)resultSession, e);
            if (e instanceof SshException && ((SshException)e).getDisconnectCode() == 14) {
                throw new TransportException(target, MessageFormat.format(SshdText.get().loginDenied, host, Integer.toString(port)), (Throwable)e);
            }
            throw e;
        }
    }

    private ClientSession connect(HostConfigEntry config, AttributeRepository context, Duration timeout) throws IOException {
        ConnectFuture connected = this.client.connect(config, context, null);
        long timeoutMillis = timeout.toMillis();
        connected = timeoutMillis <= 0L ? (ConnectFuture)connected.verify() : (ConnectFuture)connected.verify(timeoutMillis);
        return (ClientSession)connected.getSession();
    }

    private void close(Closeable toClose, Throwable error) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException e) {
                error.addSuppressed(e);
            }
        }
    }

    private HostConfigEntry getHostConfig(String username, String host, int port) throws IOException {
        HostConfigEntry entry = this.client.getHostConfigEntryResolver().resolveEffectiveHost(host, port, null, username, null);
        if (entry == null) {
            if (SshdSocketAddress.isIPv6Address((String)host)) {
                return new HostConfigEntry("", host, port, username);
            }
            return new HostConfigEntry(host, host, port, username);
        }
        return entry;
    }

    private List<URIish> determineHops(List<URIish> currentHops, HostConfigEntry hostConfig, String host) throws IOException {
        String jumpHosts;
        if (currentHops.isEmpty() && !StringUtils.isEmptyOrNull((String)(jumpHosts = hostConfig.getProperty("ProxyJump")))) {
            try {
                return this.parseProxyJump(jumpHosts);
            }
            catch (URISyntaxException e) {
                throw new IOException(MessageFormat.format(SshdText.get().configInvalidProxyJump, host, jumpHosts), e);
            }
        }
        return currentHops;
    }

    private List<URIish> parseProxyJump(String proxyJump) throws URISyntaxException {
        String[] hops = proxyJump.split(",");
        LinkedList<URIish> result = new LinkedList<URIish>();
        String[] stringArray = hops;
        int n = hops.length;
        int n2 = 0;
        while (n2 < n) {
            URIish to;
            String hop = stringArray[n2];
            if (SHORT_SSH_FORMAT.matcher(hop = hop.trim()).matches()) {
                hop = "ssh://" + hop;
            }
            if (!"ssh".equalsIgnoreCase((to = new URIish(hop)).getScheme())) {
                throw new URISyntaxException(hop, SshdText.get().configProxyJumpNotSsh);
            }
            if (!StringUtils.isEmptyOrNull((String)to.getPath())) {
                throw new URISyntaxException(hop, SshdText.get().configProxyJumpWithPath);
            }
            result.add(to);
            ++n2;
        }
        return result;
    }

    public void addCloseListener(@NonNull SessionCloseListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeCloseListener(@NonNull SessionCloseListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyCloseListeners() {
        for (SessionCloseListener l : this.listeners) {
            try {
                l.sessionClosed(this);
            }
            catch (RuntimeException e) {
                LOG.warn(SshdText.get().closeListenerFailed, (Throwable)e);
            }
        }
    }

    public Process exec(String commandName, int timeout) throws IOException {
        ChannelExec exec = this.session.createExecChannel(commandName);
        if (timeout <= 0) {
            try {
                exec.open().verify();
            }
            catch (IOException | RuntimeException e) {
                exec.close(true);
                throw e;
            }
        }
        try {
            exec.open().verify(TimeUnit.SECONDS.toMillis(timeout));
        }
        catch (IOException | RuntimeException e) {
            exec.close(true);
            throw new IOException(MessageFormat.format(SshdText.get().sshCommandTimeout, commandName, timeout), e);
        }
        return new SshdExecProcess(exec, commandName);
    }

    @NonNull
    public FtpChannel getFtpChannel() {
        return new SshdFtpChannel();
    }

    public void disconnect() {
        this.disconnect(null);
    }

    private void disconnect(Throwable reason) {
        try {
            try {
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
            }
            catch (IOException e) {
                if (reason != null) {
                    reason.addSuppressed(e);
                } else {
                    LOG.error(SshdText.get().sessionCloseFailed, (Throwable)e);
                }
                this.client.stop();
                this.client = null;
            }
        }
        finally {
            this.client.stop();
            this.client = null;
        }
    }

    private static /* synthetic */ void lambda$1(PortForwardingTracker portForwardingTracker, ClientSession clientSession, CloseFuture future) {
        IoUtils.closeQuietly((Closeable)portForwardingTracker);
        String sessionName = clientSession.toString();
        try {
            clientSession.close();
        }
        catch (IOException e) {
            LOG.error(MessageFormat.format(SshdText.get().sshProxySessionCloseFailed, sessionName), (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface FtpOperation<T> {
        public T call() throws IOException;
    }

    private static class SshdExecProcess
    extends Process {
        private final ChannelExec channel;
        private final String commandName;

        public SshdExecProcess(ChannelExec channel, String commandName) {
            this.channel = channel;
            this.commandName = commandName;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.channel.getInvertedIn();
        }

        @Override
        public InputStream getInputStream() {
            return this.channel.getInvertedOut();
        }

        @Override
        public InputStream getErrorStream() {
            return this.channel.getInvertedErr();
        }

        @Override
        public int waitFor() throws InterruptedException {
            if (this.waitFor(-1L, TimeUnit.MILLISECONDS)) {
                return this.exitValue();
            }
            return -1;
        }

        @Override
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            long millis = timeout >= 0L ? unit.toMillis(timeout) : -1L;
            return this.channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), millis).contains(ClientChannelEvent.CLOSED);
        }

        @Override
        public int exitValue() {
            Integer exitCode = this.channel.getExitStatus();
            if (exitCode == null) {
                throw new IllegalThreadStateException(MessageFormat.format(SshdText.get().sshProcessStillRunning, this.commandName));
            }
            return exitCode;
        }

        @Override
        public void destroy() {
            if (this.channel.isOpen()) {
                this.channel.close(false);
            }
        }
    }

    private class SshdFtpChannel
    implements FtpChannel {
        private SftpClient ftp;
        private String cwd = "";

        private SshdFtpChannel() {
        }

        public void connect(int timeout, TimeUnit unit) throws IOException {
            if (timeout <= 0) {
                SshdSession.this.session.getProperties().put("sftp-channel-open-timeout", Long.MAX_VALUE);
            } else {
                SshdSession.this.session.getProperties().put("sftp-channel-open-timeout", unit.toMillis(timeout));
            }
            this.ftp = SftpClientFactory.instance().createSftpClient(SshdSession.this.session);
            try {
                this.cd(this.cwd);
            }
            catch (IOException e) {
                this.ftp.close();
            }
        }

        public void disconnect() {
            try {
                this.ftp.close();
            }
            catch (IOException e) {
                LOG.error(SshdText.get().ftpCloseFailed, (Throwable)e);
            }
        }

        public boolean isConnected() {
            return SshdSession.this.session.isAuthenticated() && this.ftp.isOpen();
        }

        private String absolute(String path) {
            if (path.isEmpty()) {
                return this.cwd;
            }
            if (path.charAt(0) != '/') {
                if (this.cwd.charAt(this.cwd.length() - 1) == '/') {
                    return String.valueOf(this.cwd) + path;
                }
                return String.valueOf(this.cwd) + '/' + path;
            }
            return path;
        }

        private <T> T map(FtpOperation<T> op) throws IOException {
            try {
                return op.call();
            }
            catch (IOException e) {
                if (e instanceof SftpException) {
                    throw new FtpChannel.FtpException(e.getLocalizedMessage(), ((SftpException)e).getStatus(), (Throwable)e);
                }
                throw e;
            }
        }

        public void cd(String path) throws IOException {
            this.cwd = this.map(() -> this.ftp.canonicalPath(this.absolute(path)));
            if (this.cwd.isEmpty()) {
                this.cwd = String.valueOf(this.cwd) + '/';
            }
        }

        public String pwd() throws IOException {
            return this.cwd;
        }

        public Collection<FtpChannel.DirEntry> ls(String path) throws IOException {
            return this.map(() -> {
                ArrayList<2> result = new ArrayList<2>();
                Throwable throwable = null;
                Object var4_5 = null;
                try (SftpClient.CloseableHandle handle = this.ftp.openDir(this.absolute(path));){
                    AtomicReference<Boolean> atEnd = new AtomicReference<Boolean>(Boolean.FALSE);
                    while (!atEnd.get().booleanValue()) {
                        List chunk = this.ftp.readDir((SftpClient.Handle)handle, atEnd);
                        if (chunk == null) {
                            break;
                        }
                        for (final SftpClient.DirEntry remote : chunk) {
                            result.add(new FtpChannel.DirEntry(){

                                public String getFilename() {
                                    return remote.getFilename();
                                }

                                public long getModifiedTime() {
                                    return remote.getAttributes().getModifyTime().toMillis();
                                }

                                public boolean isDirectory() {
                                    return remote.getAttributes().isDirectory();
                                }
                            });
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return result;
            });
        }

        public void rmdir(String path) throws IOException {
            this.map(() -> {
                this.ftp.rmdir(this.absolute(path));
                return null;
            });
        }

        public void mkdir(String path) throws IOException {
            this.map(() -> {
                this.ftp.mkdir(this.absolute(path));
                return null;
            });
        }

        public InputStream get(String path) throws IOException {
            return this.map(() -> this.ftp.read(this.absolute(path)));
        }

        public OutputStream put(String path) throws IOException {
            return this.map(() -> this.ftp.write(this.absolute(path)));
        }

        public void rm(String path) throws IOException {
            this.map(() -> {
                this.ftp.remove(this.absolute(path));
                return null;
            });
        }

        public void rename(String from, String to) throws IOException {
            this.map(() -> {
                block2: {
                    String src = this.absolute(from);
                    String dest = this.absolute(to);
                    try {
                        this.ftp.rename(src, dest, new SftpClient.CopyMode[]{SftpClient.CopyMode.Atomic, SftpClient.CopyMode.Overwrite});
                    }
                    catch (UnsupportedOperationException e) {
                        if (src.equals(dest)) break block2;
                        this.delete(dest);
                        this.ftp.rename(src, dest);
                    }
                }
                return null;
            });
        }
    }
}

