/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.editor.IEditorProvider;
import org.eclipse.gmf.runtime.common.ui.services.editor.OpenEditorOperation;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class EditorService
extends Service
implements IEditorProvider {
    private static final EditorService instance = new EditorService();
    private Map editorsMap;

    static {
        instance.configureProviders(CommonUIServicesPlugin.getPluginId(), "editorProviders");
    }

    protected EditorService() {
        super(true);
    }

    public static EditorService getInstance() {
        return instance;
    }

    private Object execute(IOperation operation) {
        List results = this.execute(ExecutionStrategy.FIRST, operation);
        return results.isEmpty() ? null : results.get(0);
    }

    @Override
    public IEditorPart openEditor(IEditorInput editorInput) {
        assert (editorInput != null);
        IEditorPart editor = (IEditorPart)this.execute(new OpenEditorOperation(editorInput));
        return editor;
    }

    protected Map getEditorsMap() {
        if (this.editorsMap == null) {
            this.editorsMap = new HashMap();
        }
        return this.editorsMap;
    }

    public void registerEditor(IEditorPart editor) {
        assert (editor != null);
        String editorId = editor.getEditorSite().getId();
        ArrayList<IEditorPart> editors = (ArrayList<IEditorPart>)this.getEditorsMap().get(editorId);
        if (editors == null) {
            editors = new ArrayList<IEditorPart>();
            this.getEditorsMap().put(editorId, editors);
        }
        editors.add(editor);
    }

    public void unregisterEditor(IEditorPart editor) {
        assert (editor != null);
        String editorId = editor.getEditorSite().getId();
        List editors = (List)this.getEditorsMap().get(editorId);
        assert (editors != null);
        assert (editors.contains(editor));
        editors.remove(editor);
    }

    public List getRegisteredEditors(String editorId) {
        return (List)this.getEditorsMap().get(editorId);
    }

    public List getRegisteredEditorParts() {
        ArrayList allEditors = new ArrayList();
        Iterator iter = this.getEditorsMap().values().iterator();
        while (iter.hasNext()) {
            allEditors.addAll((Collection)iter.next());
        }
        return allEditors;
    }
}

