/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.FactoryNotFoundException;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public class ManagedContainer
extends Lifecycle
implements IManagedContainer {
    private String name;
    private IRegistry<IFactoryKey, IFactory> factoryRegistry;
    private List<IElementProcessor> postProcessors;
    private IRegistry<ElementKey, Object> elementRegistry = new HashMapRegistry<ElementKey, Object>();
    @ReflectUtil.ExcludeFromDump
    private transient long maxElementID;
    @ReflectUtil.ExcludeFromDump
    private transient IListener elementListener = new LifecycleEventAdapter(){

        @Override
        protected void onDeactivated(ILifecycle lifecycle) {
            Map.Entry<ElementKey, Object>[] entryArray = ManagedContainer.this.getElementRegistryEntries();
            int n = entryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Map.Entry<ElementKey, Object> entry = entryArray[n2];
                Object value = entry.getValue();
                if (lifecycle == value) {
                    ElementKey key = entry.getKey();
                    ManagedContainer.this.removeElement(key);
                    return;
                }
                ++n2;
            }
        }
    };

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.checkInactive();
        this.name = name;
    }

    @Override
    public synchronized IRegistry<IFactoryKey, IFactory> getFactoryRegistry() {
        if (this.factoryRegistry == null) {
            this.factoryRegistry = this.createFactoryRegistry();
            this.factoryRegistry.addListener(new ContainerEventAdapter<Map.Entry<IFactoryKey, IFactory>>(){

                @Override
                protected void onAdded(IContainer<Map.Entry<IFactoryKey, IFactory>> container, Map.Entry<IFactoryKey, IFactory> entry) {
                    this.updateFactory(entry, ManagedContainer.this);
                }

                @Override
                protected void onRemoved(IContainer<Map.Entry<IFactoryKey, IFactory>> container, Map.Entry<IFactoryKey, IFactory> entry) {
                    this.updateFactory(entry, null);
                }

                private void updateFactory(Map.Entry<IFactoryKey, IFactory> entry, IManagedContainer container) {
                    IFactory factory = entry.getValue();
                    if (factory instanceof IManagedContainer.ContainerAware) {
                        IManagedContainer.ContainerAware f = (IManagedContainer.ContainerAware)((Object)factory);
                        f.setManagedContainer(container);
                    }
                }
            });
        }
        return this.factoryRegistry;
    }

    @Override
    public ManagedContainer registerFactory(IFactory factory) {
        this.getFactoryRegistry().put(factory.getKey(), factory);
        return this;
    }

    @Override
    public synchronized List<IElementProcessor> getPostProcessors() {
        if (this.postProcessors == null) {
            this.postProcessors = this.createPostProcessors();
        }
        return this.postProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addPostProcessor(IElementProcessor postProcessor, boolean processExistingElements) {
        if (processExistingElements) {
            ContainerEvent<Object> event = new ContainerEvent<Object>(this);
            Map.Entry<ElementKey, Object>[] entryArray = this.getElementRegistryEntries();
            int n = entryArray.length;
            int n2 = 0;
            while (n2 < n) {
                String description;
                String factoryType;
                Map.Entry<ElementKey, Object> entry = entryArray[n2];
                ElementKey key = entry.getKey();
                Object element = entry.getValue();
                String productGroup = key.getProductGroup();
                Object newElement = postProcessor.process(this, productGroup, factoryType = key.getFactoryType(), description = key.getDescription(), element);
                if (newElement != element) {
                    IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
                    synchronized (iRegistry) {
                        this.elementRegistry.put(key, newElement);
                    }
                    event.addDelta(element, IContainerDelta.Kind.REMOVED);
                    event.addDelta(newElement, IContainerDelta.Kind.ADDED);
                }
                ++n2;
            }
            this.fireEvent(event);
        }
        this.getPostProcessors().add(postProcessor);
    }

    @Override
    public void addPostProcessor(IElementProcessor postProcessor) {
        this.addPostProcessor(postProcessor, false);
    }

    @Override
    public void removePostProcessor(IElementProcessor postProcessor) {
        this.getPostProcessors().remove(postProcessor);
    }

    @Override
    public Set<String> getProductGroups() {
        this.checkActive();
        HashSet<String> result = new HashSet<String>();
        for (Object key : this.factoryRegistry.keySet()) {
            result.add(key.getProductGroup());
        }
        ElementKey[] elementKeyArray = this.getElementRegistryKeys();
        int n = elementKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key;
            key = elementKeyArray[n2];
            result.add(((ElementKey)key).getProductGroup());
            ++n2;
        }
        return result;
    }

    @Override
    public Set<String> getFactoryTypes(String productGroup) {
        this.checkActive();
        HashSet<String> result = new HashSet<String>();
        for (Object key : this.factoryRegistry.keySet()) {
            if (!ObjectUtil.equals(key.getProductGroup(), productGroup)) continue;
            result.add(key.getType());
        }
        ElementKey[] elementKeyArray = this.getElementRegistryKeys();
        int n = elementKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key;
            key = elementKeyArray[n2];
            if (ObjectUtil.equals(((ElementKey)key).getProductGroup(), productGroup)) {
                result.add(((ElementKey)key).getFactoryType());
            }
            ++n2;
        }
        return result;
    }

    @Override
    public IFactory getFactory(String productGroup, String factoryType) throws FactoryNotFoundException {
        FactoryKey key = new FactoryKey(productGroup, factoryType);
        IFactory factory = (IFactory)this.getFactoryRegistry().get(key);
        if (factory == null) {
            throw new FactoryNotFoundException("Factory not found: " + key);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.checkActive();
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            return this.elementRegistry.isEmpty();
        }
    }

    @Override
    public String[] getElementKey(Object element) {
        this.checkActive();
        Map.Entry<ElementKey, Object>[] entryArray = this.getElementRegistryEntries();
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<ElementKey, Object> entry = entryArray[n2];
            if (entry.getValue() == element) {
                ElementKey key = entry.getKey();
                String[] result = new String[]{key.getProductGroup(), key.getFactoryType(), key.getDescription()};
                return result;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Object[] getElements() {
        this.checkActive();
        return this.getElementRegistryValues();
    }

    @Override
    public Object[] getElements(String productGroup) {
        this.checkActive();
        ArrayList<Object> result = new ArrayList<Object>();
        Map.Entry<ElementKey, Object>[] entryArray = this.getElementRegistryEntries();
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<ElementKey, Object> entry = entryArray[n2];
            ElementKey key = entry.getKey();
            if (ObjectUtil.equals(key.getProductGroup(), productGroup)) {
                result.add(entry.getValue());
            }
            ++n2;
        }
        return result.toArray();
    }

    @Override
    public Object[] getElements(String productGroup, String factoryType) {
        this.checkActive();
        ArrayList<Object> result = new ArrayList<Object>();
        Map.Entry<ElementKey, Object>[] entryArray = this.getElementRegistryEntries();
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<ElementKey, Object> entry = entryArray[n2];
            ElementKey key = entry.getKey();
            if (ObjectUtil.equals(key.getProductGroup(), productGroup) && ObjectUtil.equals(key.getFactoryType(), factoryType)) {
                result.add(entry.getValue());
            }
            ++n2;
        }
        return result.toArray();
    }

    @Override
    public Object getElement(String productGroup, String factoryType, String description) throws FactoryNotFoundException, ProductCreationException {
        return this.getElement(productGroup, factoryType, description, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElement(String productGroup, String factoryType, String description, boolean activate) throws FactoryNotFoundException, ProductCreationException {
        Object element;
        this.checkActive();
        ElementKey key = new ElementKey(productGroup, factoryType, description);
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            element = this.elementRegistry.get(key);
        }
        if (element == null) {
            element = this.createElement(productGroup, factoryType, description);
            element = this.postProcessElement(productGroup, factoryType, description, element);
            if (activate) {
                this.activateElement(element);
            }
            this.putElement(key, element);
        }
        return element;
    }

    protected void activateElement(Object element) {
        EventUtil.addUniqueListener(element, this.elementListener);
        LifecycleUtil.activate(element);
        boolean active = LifecycleUtil.isDeferredActivation(element) ? LifecycleUtil.waitForActive(element, 10000L) : LifecycleUtil.isActive(element);
        if (!active) {
            EventUtil.removeListener(element, this.elementListener);
            throw new LifecycleException("Could not activate " + element);
        }
    }

    @Override
    public Object putElement(String productGroup, String factoryType, String description, Object element) {
        this.checkActive();
        element = this.postProcessElement(productGroup, factoryType, description, element);
        ElementKey key = new ElementKey(productGroup, factoryType, description);
        return this.putElement(key, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object putElement(ElementKey key, Object element) {
        Object oldElement;
        ContainerEvent<Object> event = new ContainerEvent<Object>(this);
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            key.setID(++this.maxElementID);
            oldElement = this.elementRegistry.put(key, element);
        }
        if (oldElement != element) {
            if (element instanceof IManagedContainer.ContainerAware) {
                ((IManagedContainer.ContainerAware)element).setManagedContainer(this);
            }
            EventUtil.addUniqueListener(element, this.elementListener);
            if (oldElement != null) {
                EventUtil.removeListener(oldElement, this.elementListener);
                event.addDelta(oldElement, IContainerDelta.Kind.REMOVED);
            }
            event.addDelta(element, IContainerDelta.Kind.ADDED);
            this.fireEvent(event);
        }
        return oldElement;
    }

    @Override
    public Object removeElement(String productGroup, String factoryType, String description) {
        this.checkActive();
        ElementKey key = new ElementKey(productGroup, factoryType, description);
        return this.removeElement(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeElement(ElementKey key) {
        Object element;
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            element = this.elementRegistry.remove(key);
        }
        if (element != null) {
            EventUtil.removeListener(element, this.elementListener);
            this.fireEvent(new SingleDeltaContainerEvent<Object>(this, element, IContainerDelta.Kind.REMOVED));
            if (element instanceof IManagedContainer.ContainerAware) {
                ((IManagedContainer.ContainerAware)element).setManagedContainer(null);
            }
        }
        return element;
    }

    @Override
    public <T> void forEachElement(String productGroup, Class<T> productType, Function<String, String> descriptionProvider, Consumer<T> consumer) {
        for (String type : this.getFactoryTypes(productGroup)) {
            String description = descriptionProvider == null ? null : descriptionProvider.apply(type);
            try {
                Object element = this.getElement(productGroup, type, description);
                consumer.accept(element);
            }
            catch (FactoryNotFoundException element) {
            }
            catch (ProductCreationException ex) {
                OM.LOG.error(ex);
            }
        }
    }

    @Override
    public <T> void forEachElement(String productGroup, Class<T> productType, String description, Consumer<T> consumer) {
        this.forEachElement(productGroup, productType, (String type) -> description, consumer);
    }

    @Override
    public <T> void forEachElement(String productGroup, Class<T> productType, Consumer<T> consumer) {
        this.forEachElement(productGroup, productType, (String type) -> null, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearElements() {
        this.checkActive();
        ContainerEvent<Object> event = null;
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            if (!this.elementRegistry.isEmpty()) {
                event = new ContainerEvent<Object>(this);
                for (Object element : this.elementRegistry.values()) {
                    EventUtil.removeListener(element, this.elementListener);
                    event.addDelta(element, IContainerDelta.Kind.REMOVED);
                }
                this.elementRegistry.clear();
            }
        }
        if (event != null) {
            this.fireEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadElements(InputStream stream) throws IOException, FactoryNotFoundException, ProductCreationException {
        this.checkActive();
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            this.clearElements();
            ObjectInputStream ois = new ObjectInputStream(stream);
            int size = ois.readInt();
            int i = 0;
            while (i < size) {
                try {
                    ElementKey key = (ElementKey)ois.readObject();
                    Object element = this.getElement(key.getProductGroup(), key.getFactoryType(), key.getDescription());
                    boolean active = ois.readBoolean();
                    if (active) {
                        LifecycleUtil.activate(element);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++i;
            }
            this.initMaxElementID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveElements(OutputStream stream) throws IOException {
        this.checkActive();
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            ObjectOutputStream oos = new ObjectOutputStream(stream);
            ArrayList entries = new ArrayList(this.elementRegistry.entrySet());
            Collections.sort(entries, new EntryComparator());
            oos.writeInt(entries.size());
            for (Map.Entry entry : entries) {
                oos.writeObject(entry.getKey());
                oos.writeBoolean(LifecycleUtil.isActive(entry.getValue()));
            }
        }
    }

    @Override
    public void fireEvent(IEvent event) {
        IContainerEvent e;
        if (event instanceof IContainerEvent && (e = (IContainerEvent)event).isEmpty()) {
            return;
        }
        super.fireEvent(event);
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return String.valueOf(this.getTypeName()) + "[" + this.name + "]";
        }
        return this.getTypeName();
    }

    protected String getTypeName() {
        return "ManagedContainer";
    }

    protected IRegistry<IFactoryKey, IFactory> createFactoryRegistry() {
        return new HashMapRegistry<IFactoryKey, IFactory>();
    }

    protected List<IElementProcessor> createPostProcessors() {
        return new ArrayList<IElementProcessor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementKey[] getElementRegistryKeys() {
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            return this.elementRegistry.keySet().toArray(new ElementKey[this.elementRegistry.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getElementRegistryValues() {
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            return this.elementRegistry.values().toArray(new Object[this.elementRegistry.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<ElementKey, Object>[] getElementRegistryEntries() {
        IRegistry<ElementKey, Object> iRegistry = this.elementRegistry;
        synchronized (iRegistry) {
            return this.elementRegistry.entrySet().toArray(new Map.Entry[this.elementRegistry.size()]);
        }
    }

    protected Object createElement(String productGroup, String factoryType, String description) throws FactoryNotFoundException, ProductCreationException {
        IFactory factory = this.getFactory(productGroup, factoryType);
        return factory.create(description);
    }

    protected Object postProcessElement(String productGroup, String factoryType, String description, Object element) {
        for (IElementProcessor processor : this.getPostProcessors()) {
            element = processor.process(this, productGroup, factoryType, description, element);
        }
        return element;
    }

    private void initMaxElementID() {
        this.maxElementID = 0L;
        for (ElementKey key : this.elementRegistry.keySet()) {
            long id = key.getID();
            if (this.maxElementID >= id) continue;
            this.maxElementID = id;
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate(this.getFactoryRegistry());
        LifecycleUtil.activate(this.getPostProcessors());
    }

    @Override
    protected void doDeactivate() throws Exception {
        Object[] objectArray = this.getElementRegistryValues();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            try {
                LifecycleUtil.deactivateNoisy(element);
                EventUtil.removeListener(element, this.elementListener);
            }
            catch (RuntimeException ex) {
                OM.LOG.warn(ex);
            }
            ++n2;
        }
        LifecycleUtil.deactivate(this.factoryRegistry);
        LifecycleUtil.deactivate(this.postProcessors);
        this.elementRegistry.clear();
        super.doDeactivate();
    }

    private static final class ElementKey
    implements Serializable,
    Comparable<ElementKey> {
        private static final long serialVersionUID = 1L;
        private long id;
        private String productGroup;
        private String factoryType;
        private String description;

        public ElementKey(String productGroup, String factoryType, String description) {
            this.productGroup = productGroup;
            this.factoryType = factoryType;
            this.description = description;
        }

        public long getID() {
            return this.id;
        }

        public void setID(long id) {
            this.id = id;
        }

        public String getProductGroup() {
            return this.productGroup;
        }

        public String getFactoryType() {
            return this.factoryType;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ElementKey) {
                ElementKey key = (ElementKey)obj;
                return ObjectUtil.equals(this.productGroup, key.productGroup) && ObjectUtil.equals(this.factoryType, key.factoryType) && ObjectUtil.equals(this.description, key.description);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtil.hashCode(this.productGroup) ^ ObjectUtil.hashCode(this.factoryType) ^ ObjectUtil.hashCode(this.description);
        }

        public String toString() {
            return MessageFormat.format("{0}[{1}, {2}]", this.productGroup, this.factoryType, this.description);
        }

        @Override
        public int compareTo(ElementKey key) {
            if (this.id < key.id) {
                return -1;
            }
            if (this.id > key.id) {
                return 1;
            }
            return 0;
        }
    }

    private static final class EntryComparator
    implements Comparator<Map.Entry<ElementKey, Object>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<ElementKey, Object> entry1, Map.Entry<ElementKey, Object> entry2) {
            return entry1.getKey().compareTo(entry2.getKey());
        }
    }
}

