/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.DeltaXmlVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.pde.api.tools.ui.internal.actions.ExportDialog;
import org.eclipse.pde.api.tools.ui.internal.views.APIToolingView;

public class ExportSessionAction
extends Action {
    private static final String DELTAS_XSLT_TRANSFORM_PATH = "/compare.xsl";
    private static final String XML_FILE_EXTENSION = ".xml";
    private static final String HTML_FILE_EXTENSION = ".html";
    APIToolingView view;

    public ExportSessionAction(APIToolingView view) {
        this.setText(ActionMessages.ExportSessionAction_label);
        this.setToolTipText(ActionMessages.ExportSessionAction_tooltip);
        ImageDescriptor enabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_ELCL_EXPORT");
        this.setImageDescriptor(enabledImageDescriptor);
        ImageDescriptor disabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_DLCL_EXPORT");
        this.setDisabledImageDescriptor(disabledImageDescriptor);
        this.setEnabled(false);
        this.view = view;
    }

    public void run() {
        final ISession activeSession = ApiPlugin.getDefault().getSessionManager().getActiveSession();
        if (activeSession == null) {
            return;
        }
        ExportDialog dialog = new ExportDialog(this.view.getSite().getShell(), ActionMessages.ExportActionTitle);
        int returnCode = dialog.open();
        if (returnCode != 0) {
            return;
        }
        final String reportFileName = dialog.getValue();
        if (reportFileName == null) {
            return;
        }
        final String lowerCase = reportFileName.toLowerCase();
        if (!lowerCase.endsWith(HTML_FILE_EXTENSION) && !lowerCase.endsWith(XML_FILE_EXTENSION)) {
            return;
        }
        Job job = new Job(ActionMessages.CompareWithAction_comparing_apis){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                progress.subTask(ActionMessages.CompareDialogCollectingElementTaskName);
                isHtmlFile = lowerCase.endsWith(".html");
                xmlOutputFile = null;
                progress.subTask(ActionMessages.CompareDialogComputeDeltasTaskName);
                reportFile = new File(reportFileName);
                try {
                    block37: {
                        block38: {
                            progress.split(25);
                            writer = null;
                            try {
                                xmlOutputFile = isHtmlFile != false ? Util.createTempFile((String)String.valueOf(System.currentTimeMillis()), (String)".xml") : reportFile;
                                if (xmlOutputFile.exists()) {
                                    xmlOutputFile.delete();
                                } else {
                                    parent = xmlOutputFile.getParentFile();
                                    if (!parent.exists() && !parent.mkdirs()) {
                                        var11_9 = new Status(4, "org.eclipse.pde.api.tools", ActionMessages.ExportSessionAction_failed_to_create_parent_folders);
                                        if (writer == null) return var11_9;
                                    }
                                }
                                ** GOTO lbl-1000
                            }
                            catch (IOException | CoreException e) {
                                ApiPlugin.log((Throwable)e);
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException v0) {}
                                }
                                break block37;
                            }
                            catch (Throwable var10_13) {
                                if (writer == null) throw var10_13;
                                try {
                                    writer.close();
                                    throw var10_13;
                                }
                                catch (IOException v1) {}
                                throw var10_13;
                            }
                            try {
                                writer.close();
                                return var11_9;
                            }
                            catch (IOException v2) {}
                            return var11_9;
lbl-1000:
                            // 2 sources

                            {
                                writer = new BufferedWriter(new FileWriter(xmlOutputFile));
                                visitor = new DeltaXmlVisitor();
                                data = activeSession.getModel().getRoot().getData();
                                if (!(data instanceof IDelta)) break block38;
                                delta = (IDelta)data;
                                progress.split(25);
                                delta.accept((DeltaVisitor)visitor);
                                writer.write(visitor.getXML());
                                writer.flush();
                                progress.worked(25);
                            }
                        }
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException v3) {}
                        }
                    }
                    if (isHtmlFile == false) return Status.OK_STATUS;
                    progress.split(10);
                    xmlSource = new StreamSource(xmlOutputFile);
                    stream = ApiPlugin.class.getResourceAsStream("/compare.xsl");
                    xsltSource = new StreamSource(stream);
                    try {
                        if (reportFile.exists()) {
                            reportFile.delete();
                        } else {
                            parent = reportFile.getParentFile();
                            if (!parent.exists() && !parent.mkdirs()) {
                                var14_16 = new Status(4, "org.eclipse.pde.api.tools", ActionMessages.ExportSessionAction_failed_to_create_parent_folders);
                                if (writer == null) return var14_16;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    catch (IOException | TransformerException e) {
                        ApiUIPlugin.log(e);
                        if (writer == null) return Status.OK_STATUS;
                        try {
                            writer.close();
                            return Status.OK_STATUS;
                        }
                        catch (IOException v4) {
                            return Status.OK_STATUS;
                        }
                    }
                    catch (Throwable var13_18) {
                        if (writer == null) throw var13_18;
                        try {
                            writer.close();
                            throw var13_18;
                        }
                        catch (IOException v5) {}
                        throw var13_18;
                    }
                    try {
                        writer.close();
                        return var14_16;
                    }
                    catch (IOException v6) {}
                    return var14_16;
lbl-1000:
                    // 2 sources

                    {
                        writer = new BufferedWriter(new FileWriter(reportFile));
                        result = new StreamResult(writer);
                        transFact = TransformerFactory.newInstance();
                        trans = transFact.newTransformer(xsltSource);
                        trans.transform(xmlSource, result);
                    }
                    if (writer == null) return Status.OK_STATUS;
                    try {
                        writer.close();
                        return Status.OK_STATUS;
                    }
                    catch (IOException v7) {}
                    return Status.OK_STATUS;
                }
                catch (OperationCanceledException v8) {
                    if (xmlOutputFile != null && xmlOutputFile.exists()) {
                        xmlOutputFile.delete();
                    }
                    if (reportFile.exists() == false) return Status.CANCEL_STATUS;
                    reportFile.delete();
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setSystem(false);
        job.setPriority(30);
        job.schedule();
    }

    public void dispose() {
    }
}

