/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusDiagramEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ElementProviderWrapper;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngineImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.IPapyrusElementProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.w3c.dom.Element;

public class DiagramCSSEngine
extends ExtendedCSSEngineImpl
implements IChangeListener {
    private CSSDiagram diagram;

    public DiagramCSSEngine(ExtendedCSSEngine parent, CSSDiagram diagram) {
        super(parent);
        this.diagram = diagram;
        this.setElementProvider(new ElementProviderWrapper(diagram));
    }

    @Override
    protected void reloadStyleSheets() {
        this.styleSheets.clear();
        for (StyleSheet styleSheet : this.diagram.getStyleSheets()) {
            this.styleSheets.add(styleSheet);
        }
    }

    @Override
    protected void parseStyleSheet(StyleSheetReference styleSheet) throws IOException {
        String path = styleSheet.getPath();
        if (path != null) {
            URL url;
            if (path.startsWith("/")) {
                path = "platform:/resource" + path;
                url = new URL(path);
                try {
                    url.openConnection();
                }
                catch (IOException ex) {
                    path = "platform:/plugin" + styleSheet.getPath();
                }
            } else {
                URI uri = URI.createURI((String)styleSheet.getPath());
                if (uri.isRelative()) {
                    uri = uri.resolve(this.diagram.eResource().getURI());
                }
                path = uri.toString();
            }
            url = new URL(path);
            this.parseStyleSheet(url.openStream());
        }
    }

    public EObject getNativeWidget(Object element) {
        if ((element = super.getNativeWidget(element)) == null) {
            return null;
        }
        if (!(element instanceof EObject)) {
            throw new IllegalArgumentException("Unknown element : " + element);
        }
        return (EObject)element;
    }

    public void handleChange(ChangeEvent event) {
        this.resetCache();
        if (this.diagram != null) {
            for (DiagramEditPart next : PapyrusDiagramEditPart.getDiagramEditPartsFor((Diagram)this.diagram)) {
                DiagramHelper.forceRefresh((DiagramEditPart)next);
            }
        }
    }

    @Override
    public Element getElement(Object node) {
        if (node == null) {
            return null;
        }
        EObject notationElement = this.getNativeWidget(node);
        IElementProvider elementProvider = this.getElementProvider();
        View canonicalNotationElement = null;
        if (elementProvider instanceof IPapyrusElementProvider && (canonicalNotationElement = ((IPapyrusElementProvider)elementProvider).getPrimaryView(notationElement)).getDiagram() == null) {
            return null;
        }
        return super.getElement(canonicalNotationElement);
    }

    @Override
    public ExtendedCSSEngine.CascadeScope getCascadeScope() {
        return ExtendedCSSEngine.CascadeScope.AUTHOR;
    }
}

