/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.LifelineVerticalLabel;
import org.eclipse.swt.graphics.Image;

public class LifelineFigure
extends PapyrusNodeFigure
implements IPapyrusNodeUMLElementFigure {
    protected final int LABEL_WIDTH = 30;
    protected RectangleFigure nameLabelContainerFigure;
    protected LifelineVerticalLabel nameLabel;
    protected RectangleFigure timeRulerContainerFigure;
    protected RectangleFigure lifelineDataContainerFigure;
    protected RectangleFigure timelineContainerFigure;
    private boolean selected;
    private boolean displayTimeRuler;

    public LifelineFigure() {
        this.setShadow(false);
        this.createContents();
        this.setLayoutManager((LayoutManager)new AbstractLayout(){

            public void layout(IFigure container) {
                Rectangle clientArea = container.getClientArea();
                List children = container.getChildren();
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    if (child == LifelineFigure.this.getNameLabelContainerFigure()) {
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y, 30, clientArea.height));
                    } else if (child == LifelineFigure.this.getLifelineDataContainerFigure()) {
                        child.setBounds(new Rectangle(clientArea.x + 30, clientArea.y, clientArea.width - 30, clientArea.height));
                    }
                    ++i;
                }
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                return new Dimension(-1, -1);
            }
        });
    }

    protected void createContents() {
    }

    public void setPreferredSize(Dimension size) {
        IFigure container = this.getParent();
        int childrenSize = container.getChildren().size();
        Rectangle containerRectangle = container.getBounds();
        Rectangle resultBounds = new Rectangle(0, 0, containerRectangle.width(), containerRectangle.height() / childrenSize);
        this.prefSize = resultBounds.getSize();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.selected) {
            graphics.pushState();
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setLineWidth(1);
            graphics.drawRectangle(this.getBounds().getShrinked(1, 1).resize(-1, -1));
            graphics.popState();
        }
    }

    public boolean isDisplayTimeRuler() {
        return this.displayTimeRuler;
    }

    public void setDisplayTimeRuler(boolean visible) {
        this.displayTimeRuler = visible;
    }

    public LifelineVerticalLabel getLifelineLabelFigure() {
        return this.nameLabel;
    }

    public RectangleFigure getNameLabelContainerFigure() {
        return this.nameLabelContainerFigure;
    }

    public RectangleFigure getTimelineContainerFigure() {
        return this.timelineContainerFigure;
    }

    public RectangleFigure getTimeRulerContainerFigure() {
        return this.timeRulerContainerFigure;
    }

    public RectangleFigure getLifelineDataContainerFigure() {
        return this.lifelineDataContainerFigure;
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
    }

    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
    }

    public PapyrusWrappingLabel getStereotypesLabel() {
        return null;
    }
}

