/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.TransactionalCommandStackImpl;
import org.eclipse.emf.transaction.util.ConditionalRedoCommand;

public class NestingTransactionalCommandStack
extends TransactionalCommandStackImpl {
    private NestingTransactionalCommandStack childCommandStack;
    private final boolean nested;
    private boolean executing;

    public NestingTransactionalCommandStack() {
        this(false);
    }

    protected NestingTransactionalCommandStack(boolean nested) {
        this.nested = nested;
    }

    protected NestingTransactionalCommandStack getTopMostCommandStack() {
        if (this.childCommandStack == null) {
            return this;
        }
        return this.childCommandStack.getTopMostCommandStack();
    }

    protected void startNestedTransaction(Command command) {
        if (this.childCommandStack != null) {
            this.childCommandStack.startNestedTransaction(command);
        } else {
            this.childCommandStack = new NestingTransactionalCommandStack(true);
            this.childCommandStack.setEditingDomain(this.getDomain());
            this.childCommandStack.execute(command);
        }
    }

    public void commit() {
        if (this.childCommandStack != null) {
            this.disposeLastCommandStack();
        }
    }

    private boolean disposeLastCommandStack() {
        if (this.childCommandStack == null) {
            this.dispose();
            return true;
        }
        if (this.childCommandStack.disposeLastCommandStack()) {
            this.childCommandStack = null;
        }
        return false;
    }

    public void rollback() {
        if (this.childCommandStack != null) {
            while (this.canUndo()) {
                this.undo();
            }
            this.disposeLastCommandStack();
        }
    }

    public void execute(Command command) {
        if (this.childCommandStack == null) {
            if (!this.executing) {
                this.executing = true;
                try {
                    super.execute(command);
                }
                finally {
                    this.executing = false;
                }
            } else {
                try {
                    this.startNestedTransaction(command);
                    this.commit();
                }
                catch (OperationCanceledException e) {
                    this.rollback();
                    throw e;
                }
            }
        } else {
            this.childCommandStack.execute(command);
        }
    }

    protected void handleError(Exception exception) {
        RollbackException rbe;
        if (this.nested && exception instanceof RollbackException && (rbe = (RollbackException)exception).getStatus().getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (exception instanceof OperationCanceledException) {
            this.rollback();
            throw (OperationCanceledException)((Object)exception);
        }
        super.handleError(exception);
    }

    public Command getMostRecentCommand() {
        if (this.childCommandStack == null) {
            return super.getMostRecentCommand();
        }
        return this.childCommandStack.getMostRecentCommand();
    }

    public Command getRedoCommand() {
        if (this.childCommandStack == null) {
            return super.getRedoCommand();
        }
        return this.childCommandStack.getRedoCommand();
    }

    public Command getUndoCommand() {
        if (this.childCommandStack == null) {
            return super.getUndoCommand();
        }
        return this.childCommandStack.getUndoCommand();
    }

    public void undo() {
        if (this.childCommandStack == null) {
            super.undo();
        } else {
            this.childCommandStack.undo();
        }
    }

    public boolean canUndo() {
        if (this.childCommandStack == null) {
            return super.canUndo();
        }
        return this.childCommandStack.canUndo();
    }

    public boolean canRedo() {
        if (this.childCommandStack == null) {
            return super.canRedo();
        }
        return this.childCommandStack.canRedo();
    }

    public void redo() {
        if (this.childCommandStack == null) {
            super.redo();
        } else {
            this.childCommandStack.redo();
        }
    }

    protected void doExecute(Command command, Map<?, ?> options) throws InterruptedException, RollbackException {
        EMFCommandTransaction tx = this.createTransaction(command, options);
        boolean completed = false;
        try {
            try {
                this.basicExecute(command);
                completed = this.mostRecentCommand == command;
                tx.commit();
            }
            catch (OperationCanceledException e) {
                Command triggerCommand;
                if (this.nested) {
                    throw e;
                }
                if (tx != null && tx.isActive()) {
                    this.rollback((Transaction)tx);
                    this.handleRollback(command, null);
                } else if (!(command instanceof RecordingCommand) && completed && (triggerCommand = tx.getTriggers()) != null) {
                    ConditionalRedoCommand.Compound compound = new ConditionalRedoCommand.Compound();
                    compound.append(this.mostRecentCommand);
                    compound.append(triggerCommand);
                    this.mostRecentCommand = compound;
                    this.commandList.set(this.top, this.mostRecentCommand);
                }
            }
        }
        finally {
            Command triggerCommand;
            if (tx != null && tx.isActive()) {
                this.rollback((Transaction)tx);
                this.handleRollback(command, null);
            } else if (!(command instanceof RecordingCommand) && completed && (triggerCommand = tx.getTriggers()) != null) {
                ConditionalRedoCommand.Compound compound = new ConditionalRedoCommand.Compound();
                compound.append(this.mostRecentCommand);
                compound.append(triggerCommand);
                this.mostRecentCommand = compound;
                this.commandList.set(this.top, this.mostRecentCommand);
            }
        }
    }

    protected void basicExecute(Command command) {
        try {
            super.basicExecute(command);
        }
        catch (OperationCanceledException e) {
            command.dispose();
            throw e;
        }
    }
}

