/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.mem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionKeyImpl;
import org.eclipse.emf.cdo.internal.server.mem.MEMStoreAccessor;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.mem.IMEMStore;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.collection.AbstractFilteredIterator;
import org.eclipse.net4j.util.collection.BidirectionalIterator;
import org.eclipse.net4j.util.collection.LimitedIterator;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class MEMStore
extends LongIDStore
implements IMEMStore,
InternalCDOBranchManager.BranchLoader3,
IStoreAccessor.DurableLocking2 {
    public static final String TYPE = "mem";
    private long creationTime;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<Integer, InternalCDOBranchManager.BranchLoader.BranchInfo> branchInfos = new HashMap<Integer, InternalCDOBranchManager.BranchLoader.BranchInfo>();
    private int lastBranchID;
    private int lastLocalBranchID;
    private Map<Object, List<InternalCDORevision>> revisions = new HashMap<Object, List<InternalCDORevision>>();
    private List<CommitInfo> commitInfos = new ArrayList<CommitInfo>();
    private Map<CDOID, EClass> objectTypes = CDOIDUtil.createMap();
    private Map<String, IDurableLockingManager.LockArea> lockAreas = new HashMap<String, IDurableLockingManager.LockArea>();
    private Map<String, Object> lobs = new HashMap<String, Object>();
    private int listLimit;
    @ReflectUtil.ExcludeFromDump
    private transient EStructuralFeature resourceNameFeature;

    public MEMStore(int listLimit) {
        super(TYPE, MEMStore.set(IStore.ChangeFormat.REVISION, IStore.ChangeFormat.DELTA), MEMStore.set(IStore.RevisionTemporality.NONE, IStore.RevisionTemporality.AUDITING), MEMStore.set(IStore.RevisionParallelism.NONE, IStore.RevisionParallelism.BRANCHING));
        this.setRevisionTemporality(IStore.RevisionTemporality.AUDITING);
        this.setRevisionParallelism(IStore.RevisionParallelism.BRANCHING);
        this.listLimit = listLimit;
    }

    public MEMStore() {
        this(-1);
    }

    @Override
    public CDOID createObjectID(String val) {
        if (this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.CLIENT) {
            byte[] decoded = CDOIDUtil.decodeUUID((String)val);
            return CDOIDUtil.createUUID((byte[])decoded);
        }
        return super.createObjectID(val);
    }

    @Override
    @Deprecated
    public boolean isLocal(CDOID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureLastObjectID(CDOID id) {
        if (this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.CLIENT) {
            return;
        }
        super.ensureLastObjectID(id);
    }

    @Override
    public synchronized Map<String, String> getPersistentProperties(Set<String> names) {
        if (names == null || names.isEmpty()) {
            return new HashMap<String, String>(this.properties);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : names) {
            String value = this.properties.get(name);
            if (value == null) continue;
            result.put(name, value);
        }
        return result;
    }

    @Override
    public synchronized void setPersistentProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Override
    public synchronized void removePersistentProperties(Set<String> names) {
        for (String name : names) {
            this.properties.remove(name);
        }
    }

    public synchronized Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (branchID == Integer.MAX_VALUE) {
            branchID = ++this.lastBranchID;
        } else if (branchID == Integer.MIN_VALUE) {
            branchID = --this.lastLocalBranchID;
        }
        this.branchInfos.put(branchID, branchInfo);
        return Pair.create((Object)branchID, (Object)branchInfo.getBaseTimeStamp());
    }

    public synchronized InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        return this.branchInfos.get(branchID);
    }

    public synchronized InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
        for (Map.Entry<Integer, InternalCDOBranchManager.BranchLoader.BranchInfo> entry : this.branchInfos.entrySet()) {
            InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = entry.getValue();
            if (branchInfo.getBaseBranchID() != branchID) continue;
            int id = entry.getKey();
            result.add(new InternalCDOBranchManager.BranchLoader.SubBranchInfo(id, branchInfo.getName(), branchInfo.getBaseTimeStamp()));
        }
        return result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
    }

    public synchronized int loadBranches(int startID, int endID, CDOBranchHandler handler) {
        int count = 0;
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        for (Map.Entry<Integer, InternalCDOBranchManager.BranchLoader.BranchInfo> entry : this.branchInfos.entrySet()) {
            int id = entry.getKey();
            if (startID > id || id > endID && endID != 0) continue;
            InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = entry.getValue();
            InternalCDOBranch branch = branchManager.getBranch(id, branchInfo);
            handler.handleBranch((CDOBranch)branch);
            ++count;
        }
        return count;
    }

    @Deprecated
    public void deleteBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void renameBranch(int branchID, String newName) {
        throw new UnsupportedOperationException();
    }

    public void renameBranch(int branchID, String oldName, String newName) {
        InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = this.branchInfos.get(branchID);
        if (branchInfo != null) {
            branchInfo.setName(newName);
        }
    }

    public synchronized void loadCommitInfos(final CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        int startIndex;
        boolean forward;
        InternalCDOCommitInfoManager manager = this.getRepository().getCommitInfoManager();
        if (startTime == endTime && startTime > 0L) {
            int index = Collections.binarySearch(this.commitInfos, new CommitInfoKey(startTime));
            if (index >= 0) {
                CommitInfo commitInfo = this.commitInfos.get(index);
                commitInfo.handle(manager, handler);
            }
            return;
        }
        boolean counting = endTime < 0L;
        int count = CDOCommitInfoUtil.decodeCount((long)endTime);
        boolean bl = counting ? count > 0 : (forward = endTime > startTime);
        if (startTime == 0L) {
            startIndex = this.commitInfos.size();
        } else {
            startIndex = Collections.binarySearch(this.commitInfos, new CommitInfoKey(startTime));
            if (startIndex >= 0) {
                if (!forward) {
                    ++startIndex;
                }
            } else {
                startIndex = -(startIndex + 1);
                if (forward) {
                    --startIndex;
                }
            }
        }
        ListIterator<CommitInfo> listIterator = this.commitInfos.listIterator(startIndex);
        Object iterator = new BidirectionalIterator(listIterator, !forward);
        if (branch != null) {
            iterator = new AbstractFilteredIterator<CommitInfo>((Iterator)iterator){

                protected boolean isValid(CommitInfo element) {
                    return element.getBranch() == branch;
                }
            };
        }
        if (counting) {
            iterator = new LimitedIterator((Iterator)iterator, Math.abs(count));
        } else if (startTime != 0L || endTime != 0L) {
            Predicate<CDOTimeProvider> predicate = forward ? new UpTo(endTime) : new DownTo(endTime);
            iterator = new AbstractFilteredIterator.Predicated((Iterator)iterator, (Predicate)predicate);
        }
        while (iterator.hasNext()) {
            CommitInfo commitInfo = (CommitInfo)iterator.next();
            commitInfo.handle(manager, handler);
        }
    }

    public synchronized Set<CDOID> readChangeSet(CDOChangeSetSegment[] segments) {
        HashSet<CDOID> ids = new HashSet<CDOID>();
        CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
            for (List<InternalCDORevision> list : this.revisions.values()) {
                this.readChangeSet(segment, list, ids);
            }
            ++n2;
        }
        return ids;
    }

    private void readChangeSet(CDOChangeSetSegment segment, List<InternalCDORevision> list, Set<CDOID> ids) {
        long startTime = segment.getTimeStamp();
        long endTime = segment.getEndTime();
        boolean listCheckDone = false;
        for (InternalCDORevision revision : list) {
            CDOID id = revision.getID();
            if (!listCheckDone) {
                if (ids.contains(id)) {
                    return;
                }
                if (revision.getBranch() != segment.getBranch()) {
                    return;
                }
                listCheckDone = true;
            }
            if (!CDOCommonUtil.isValidTimeStamp((long)revision.getTimeStamp(), (long)startTime, (long)endTime)) continue;
            ids.add(id);
        }
    }

    public synchronized void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        for (List<InternalCDORevision> list : this.revisions.values()) {
            for (InternalCDORevision revision : list) {
                if (this.handleRevision(revision, eClass, branch, timeStamp, exactTime, handler)) continue;
                return;
            }
        }
    }

    private boolean handleRevision(InternalCDORevision revision, EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        if (eClass != null && revision.getEClass() != eClass) {
            return true;
        }
        if (branch != null && revision.getBranch() != branch) {
            return true;
        }
        if (timeStamp != -1L && (exactTime ? timeStamp != 0L && revision.getTimeStamp() != timeStamp : !revision.isValid(timeStamp))) {
            return true;
        }
        return handler.handleRevision((CDORevision)revision);
    }

    @Override
    public int getListLimit() {
        return this.listLimit;
    }

    @Override
    public synchronized void setListLimit(int listLimit) {
        if (listLimit != -1 && this.listLimit != listLimit) {
            for (List<InternalCDORevision> list : this.revisions.values()) {
                this.enforceListLimit(list);
            }
        }
        this.listLimit = listLimit;
    }

    public synchronized List<InternalCDORevision> getCurrentRevisions() {
        ArrayList<InternalCDORevision> simpleRevisions = new ArrayList<InternalCDORevision>();
        for (List<InternalCDORevision> list : this.revisions.values()) {
            InternalCDORevision revision = list.get(list.size() - 1);
            simpleRevisions.add(revision);
        }
        return simpleRevisions;
    }

    public synchronized InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        Object listKey = this.getListKey(id, branchVersion.getBranch());
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list == null) {
            return null;
        }
        return this.getRevisionByVersion(list, branchVersion.getVersion());
    }

    public synchronized InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        Object listKey = this.getListKey(id, branchPoint.getBranch());
        if (branchPoint.getTimeStamp() == 0L) {
            List<InternalCDORevision> list = this.revisions.get(listKey);
            if (list == null) {
                return null;
            }
            return list.get(list.size() - 1);
        }
        if (!this.getRepository().isSupportingAudits()) {
            throw new UnsupportedOperationException("Auditing not supported");
        }
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list == null) {
            return null;
        }
        return this.getRevision(list, branchPoint);
    }

    public synchronized void addRevision(InternalCDORevision revision, boolean raw) {
        InternalCDOBranch branch = revision.getBranch();
        if (branch.getBranchManager().getRepository() != this.getRepository()) {
            throw new IllegalArgumentException("Branch does not belong to this repository: " + branch);
        }
        Object listKey = this.getListKey(revision.getID(), (CDOBranch)branch);
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list == null) {
            list = new ArrayList<InternalCDORevision>();
            this.revisions.put(listKey, list);
        }
        this.addRevision(list, revision, raw);
        if (raw) {
            this.ensureLastObjectID(revision.getID());
        }
    }

    public synchronized void addCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource) {
        int index = this.commitInfos.size() - 1;
        while (index >= 0) {
            CommitInfo info = this.commitInfos.get(index);
            if (timeStamp > info.getTimeStamp()) break;
            --index;
        }
        CommitInfo commitInfo = new CommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, mergeSource);
        this.commitInfos.add(index + 1, commitInfo);
    }

    public synchronized boolean rollbackRevision(InternalCDORevision revision) {
        CDOID id = revision.getID();
        InternalCDOBranch branch = revision.getBranch();
        int version = revision.getVersion();
        Object listKey = this.getListKey(id, (CDOBranch)branch);
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list == null) {
            return false;
        }
        Iterator<InternalCDORevision> it = list.iterator();
        while (it.hasNext()) {
            InternalCDORevision rev = it.next();
            if (rev.getVersion() == version) {
                it.remove();
                return true;
            }
            if (rev.getVersion() != version - 1) continue;
            rev.setRevised(0L);
        }
        return false;
    }

    public synchronized DetachedCDORevision detachObject(CDOID id, CDOBranch branch, long timeStamp) {
        int version;
        InternalCDORevision revision;
        Object listKey = this.getListKey(id, branch);
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list != null && (revision = this.getRevision(list, branch.getHead())) != null) {
            revision.setRevised(timeStamp - 1L);
        }
        if (list == null) {
            list = new ArrayList<InternalCDORevision>();
            this.revisions.put(listKey, list);
            version = 1;
        } else {
            version = this.getHighestVersion(list) + 1;
        }
        EClass eClass = this.getObjectType(id);
        DetachedCDORevision detached = new DetachedCDORevision(eClass, id, branch, version, timeStamp);
        this.addRevision(list, (InternalCDORevision)detached, false);
        return detached;
    }

    public synchronized void queryResources(IStoreAccessor.QueryResourcesContext context) {
        CDOID folderID = context.getFolderID();
        String name = context.getName();
        boolean exactMatch = context.exactMatch();
        for (Map.Entry<Object, List<InternalCDORevision>> entry : this.revisions.entrySet()) {
            String revisionName;
            CDOID revisionFolder;
            InternalCDORevision revision;
            List<InternalCDORevision> list;
            CDOBranch branch = this.getBranch(entry.getKey());
            if (branch == context.getBranch() && !(list = entry.getValue()).isEmpty() && !((revision = list.get(0)) instanceof SyntheticCDORevision) && revision.isResourceNode() && (revision = this.getRevision(list, (CDOBranchPoint)context)) != null && !(revision instanceof DetachedCDORevision) && CDOIDUtil.equals((CDOID)(revisionFolder = (CDOID)revision.data().getContainerID()), (CDOID)folderID) && CDOTransactionImpl.isResourceMatch((String)(revisionName = (String)revision.data().get(this.resourceNameFeature, 0)), (String)name, (boolean)exactMatch) && !context.addResource(revision.getID())) break;
        }
    }

    public synchronized void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        Set<CDOID> targetIDs = context.getTargetObjects().keySet();
        Map<EClass, List<EReference>> sourceCandidates = context.getSourceCandidates();
        for (Map.Entry<Object, List<InternalCDORevision>> entry : this.revisions.entrySet()) {
            InternalCDORevision revision;
            List<InternalCDORevision> list;
            CDOBranch branch = this.getBranch(entry.getKey());
            if (branch != context.getBranch() || (list = entry.getValue()).isEmpty() || (revision = this.getRevision(list, (CDOBranchPoint)context)) == null || revision instanceof SyntheticCDORevision) continue;
            EClass eClass = revision.getEClass();
            CDOID sourceID = revision.getID();
            List<EReference> eReferences = sourceCandidates.get(eClass);
            if (eReferences == null) continue;
            for (EReference eReference : eReferences) {
                Object value = revision.getValue((EStructuralFeature)eReference);
                if (value == null) continue;
                if (eReference.isMany()) {
                    List ids = (List)value;
                    int index = 0;
                    for (CDOID id : ids) {
                        if (this.queryXRefs(context, targetIDs, id, sourceID, eReference, index++)) continue;
                        return;
                    }
                    continue;
                }
                CDOID id = (CDOID)value;
                if (this.queryXRefs(context, targetIDs, id, sourceID, eReference, 0)) continue;
                return;
            }
        }
    }

    private boolean queryXRefs(IStoreAccessor.QueryXRefsContext context, Set<CDOID> targetIDs, CDOID targetID, CDOID sourceID, EReference sourceReference, int index) {
        for (CDOID id : targetIDs) {
            if (id != targetID || context.addXRef(targetID, sourceID, sourceReference, index)) continue;
            return false;
        }
        return true;
    }

    public synchronized void rawExport(CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) {
        throw new UnsupportedOperationException();
    }

    public synchronized void rawImport(CDODataInput in, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public synchronized void rawDelete(CDOID id, int version, CDOBranch branch) {
        Object listKey = this.getListKey(id, branch);
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list != null) {
            Iterator<InternalCDORevision> it = list.iterator();
            while (it.hasNext()) {
                InternalCDORevision rev = it.next();
                if (rev.getVersion() != version) continue;
                it.remove();
                break;
            }
        }
    }

    public synchronized IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return this.createLockArea(null, userID, branchPoint, readOnly, locks);
    }

    @Override
    public synchronized IDurableLockingManager.LockArea createLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        if (durableLockingID != null) {
            if (this.lockAreas.containsKey(durableLockingID)) {
                throw new IDurableLockingManager.LockAreaAlreadyExistsException(durableLockingID);
            }
        } else {
            while (this.lockAreas.containsKey(durableLockingID = CDOLockUtil.createDurableLockingID())) {
            }
        }
        IDurableLockingManager.LockArea area = CDOLockUtil.createLockArea((String)durableLockingID, (String)userID, (CDOBranchPoint)branchPoint, (boolean)readOnly, locks);
        this.lockAreas.put(durableLockingID, area);
        return area;
    }

    @Override
    public synchronized void updateLockArea(IDurableLockingManager.LockArea lockArea) {
        String durableLockingID = lockArea.getDurableLockingID();
        this.lockAreas.put(durableLockingID, lockArea);
    }

    public synchronized IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        IDurableLockingManager.LockArea area = this.lockAreas.get(durableLockingID);
        if (area == null) {
            throw new IDurableLockingManager.LockAreaNotFoundException(durableLockingID);
        }
        return area;
    }

    public synchronized void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        for (IDurableLockingManager.LockArea area : this.lockAreas.values()) {
            String userID = area.getUserID();
            if (userID != null && !userID.startsWith(userIDPrefix) || handler.handleLockArea(area)) continue;
            return;
        }
    }

    public synchronized void deleteLockArea(String durableLockingID) {
        this.lockAreas.remove(durableLockingID);
    }

    @Override
    public synchronized void lock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        IDurableLockingManager.LockArea area = this.getLockArea(durableLockingID);
        Map locks = area.getLocks();
        InternalLockManager lockManager = this.getRepository().getLockingManager();
        for (Object object : objectsToLock) {
            CDOID id = lockManager.getLockKeyID(object);
            IDurableLockingManager.LockGrade grade = (IDurableLockingManager.LockGrade)locks.get(id);
            grade = grade != null ? grade.getUpdated(type, true) : IDurableLockingManager.LockGrade.get((IRWLockManager.LockType)type);
            locks.put(id, grade);
        }
    }

    @Override
    public synchronized void unlock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        IDurableLockingManager.LockArea area = this.getLockArea(durableLockingID);
        Map locks = area.getLocks();
        InternalLockManager lockManager = this.getRepository().getLockingManager();
        for (Object object : objectsToUnlock) {
            CDOID id = lockManager.getLockKeyID(object);
            IDurableLockingManager.LockGrade grade = (IDurableLockingManager.LockGrade)locks.get(id);
            if (grade == null || (grade = grade.getUpdated(type, false)) != IDurableLockingManager.LockGrade.NONE) continue;
            locks.remove(id);
        }
    }

    @Override
    public synchronized void unlock(String durableLockingID) {
        IDurableLockingManager.LockArea area = this.getLockArea(durableLockingID);
        Map locks = area.getLocks();
        locks.clear();
    }

    public synchronized void queryLobs(List<byte[]> ids) {
        Iterator<byte[]> it = ids.iterator();
        while (it.hasNext()) {
            byte[] id = it.next();
            String key = HexUtil.bytesToHex((byte[])id);
            if (this.lobs.containsKey(key)) continue;
            it.remove();
        }
    }

    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        for (Map.Entry<String, Object> entry : this.lobs.entrySet()) {
            Closeable out;
            Closeable in;
            byte[] id = HexUtil.hexToBytes((String)entry.getKey());
            Object lob = entry.getValue();
            if (lob instanceof byte[]) {
                byte[] blob = (byte[])lob;
                in = new ByteArrayInputStream(blob);
                out = handler.handleBlob(id, (long)blob.length);
                if (out == null) continue;
                try {
                    IOUtil.copyBinary((InputStream)in, (OutputStream)out, (long)blob.length);
                    continue;
                }
                finally {
                    IOUtil.close((Closeable)out);
                }
            }
            char[] clob = (char[])lob;
            in = new CharArrayReader(clob);
            out = handler.handleClob(id, (long)clob.length);
            if (out == null) continue;
            try {
                IOUtil.copyCharacter((Reader)in, (Writer)out, (long)clob.length);
            }
            finally {
                IOUtil.close((Closeable)out);
            }
        }
    }

    public synchronized void loadLob(byte[] id, OutputStream out) throws IOException {
        String key = HexUtil.bytesToHex((byte[])id);
        Object lob = this.lobs.get(key);
        if (lob == null) {
            throw new IOException("Lob not found: " + key);
        }
        if (lob instanceof byte[]) {
            byte[] blob = (byte[])lob;
            ByteArrayInputStream in = new ByteArrayInputStream(blob);
            IOUtil.copyBinary((InputStream)in, (OutputStream)out, (long)blob.length);
        } else {
            char[] clob = (char[])lob;
            CharArrayReader in = new CharArrayReader(clob);
            IOUtil.copyCharacter((Reader)in, (Writer)new OutputStreamWriter(out), (long)clob.length);
        }
    }

    public synchronized void writeBlob(byte[] id, long size, InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtil.copyBinary((InputStream)inputStream, (OutputStream)out, (long)size);
        this.lobs.put(HexUtil.bytesToHex((byte[])id), out.toByteArray());
    }

    public synchronized void writeClob(byte[] id, long size, Reader reader) throws IOException {
        CharArrayWriter out = new CharArrayWriter();
        IOUtil.copyCharacter((Reader)reader, (Writer)out, (long)size);
        this.lobs.put(HexUtil.bytesToHex((byte[])id), out.toCharArray());
    }

    @Override
    public MEMStoreAccessor createReader(ISession session) {
        return new MEMStoreAccessor(this, session);
    }

    @Override
    public MEMStoreAccessor createWriter(ITransaction transaction) {
        return new MEMStoreAccessor(this, transaction);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public boolean isFirstStart() {
        return true;
    }

    public synchronized Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        result.put((CDOBranch)branchManager.getMainBranch(), new ArrayList());
        for (Integer n : this.branchInfos.keySet()) {
            InternalCDOBranch branch = branchManager.getBranch(n.intValue());
            result.put((CDOBranch)branch, new ArrayList());
        }
        for (List list : this.revisions.values()) {
            for (InternalCDORevision revision : list) {
                InternalCDOBranch branch = revision.getBranch();
                List resultList = (List)result.get(branch);
                resultList.add(revision);
            }
        }
        return result;
    }

    @Override
    public synchronized EClass getObjectType(CDOID id) {
        return this.objectTypes.get(id);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.creationTime = this.getRepository().getTimeStamp();
        if (this.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.CLIENT) {
            this.setObjectIDTypes(Collections.singleton(CDOID.ObjectType.UUID));
        }
    }

    protected void doDeactivate() throws Exception {
        this.revisions.clear();
        this.branchInfos.clear();
        this.commitInfos.clear();
        this.objectTypes.clear();
        this.properties.clear();
        this.resourceNameFeature = null;
        this.lastBranchID = 0;
        this.lastLocalBranchID = 0;
        super.doDeactivate();
    }

    @Override
    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return null;
    }

    @Override
    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return null;
    }

    private Object getListKey(CDOID id, CDOBranch branch) {
        if (this.getRevisionParallelism() == IStore.RevisionParallelism.NONE) {
            return id;
        }
        return new ListKey(id, branch);
    }

    private CDOBranch getBranch(Object key) {
        if (key instanceof ListKey) {
            return ((ListKey)key).getBranch();
        }
        return this.getRepository().getBranchManager().getMainBranch();
    }

    private int getHighestVersion(List<InternalCDORevision> list) {
        int version = 0;
        for (InternalCDORevision revision : list) {
            if (revision.getVersion() <= version) continue;
            version = revision.getVersion();
        }
        return version;
    }

    private InternalCDORevision getRevisionByVersion(List<InternalCDORevision> list, int version) {
        for (InternalCDORevision revision : list) {
            if (revision.getVersion() != version) continue;
            return revision;
        }
        return null;
    }

    private InternalCDORevision getRevision(List<InternalCDORevision> list, CDOBranchPoint branchPoint) {
        long timeStamp = branchPoint.getTimeStamp();
        for (InternalCDORevision revision : list) {
            if (!(timeStamp == 0L ? !revision.isHistorical() : revision.isValid(timeStamp))) continue;
            return revision;
        }
        return null;
    }

    private void addRevision(List<InternalCDORevision> list, InternalCDORevision revision, boolean raw) {
        CDOID id;
        boolean resource;
        boolean bl = resource = !(revision instanceof SyntheticCDORevision) && revision.isResourceNode();
        if (resource && this.resourceNameFeature == null) {
            this.resourceNameFeature = revision.getEClass().getEStructuralFeature("name");
        }
        if (!raw) {
            InternalCDORevision oldRevision;
            int version = revision.getVersion();
            InternalCDORevision rev = this.getRevisionByVersion(list, version);
            if (rev != null) {
                throw new IllegalStateException("Concurrent modification of " + rev.getEClass().getName() + "@" + new CDORevisionKeyImpl(rev.getID(), (CDOBranch)rev.getBranch(), version));
            }
            int oldVersion = version - 1;
            if (oldVersion >= 0 && (oldRevision = this.getRevisionByVersion(list, oldVersion)) != null) {
                if (this.getRepository().isSupportingAudits()) {
                    oldRevision.setRevised(revision.getTimeStamp() - 1L);
                } else {
                    list.remove(oldRevision);
                }
            }
            if (resource) {
                this.checkDuplicateResource(revision);
            }
        }
        list.add(revision);
        if (this.listLimit != -1) {
            this.enforceListLimit(list);
        }
        if (!this.objectTypes.containsKey(id = revision.getID())) {
            this.objectTypes.put(id, revision.getEClass());
        }
    }

    private void checkDuplicateResource(InternalCDORevision revision) {
        CDOID revisionFolder = (CDOID)revision.data().getContainerID();
        String revisionName = (String)revision.data().get(this.resourceNameFeature, 0);
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        CDOID resourceID = accessor.readResourceID(revisionFolder, revisionName, (CDOBranchPoint)revision);
        if (!CDOIDUtil.isNull((CDOID)resourceID)) {
            throw new IllegalStateException("Duplicate resource: name=" + revisionName + ", folderID=" + revisionFolder);
        }
    }

    private void enforceListLimit(List<InternalCDORevision> list) {
        while (list.size() > this.listLimit) {
            list.remove(0);
        }
    }

    private static final class CommitInfo
    extends CommitInfoKey {
        private CDOBranch branch;
        private long previousTimeStamp;
        private String userID;
        private String comment;
        private CDOBranchPoint mergeSource;

        public CommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource) {
            super(timeStamp);
            this.branch = branch;
            this.previousTimeStamp = previousTimeStamp;
            this.userID = userID;
            this.comment = comment;
            this.mergeSource = mergeSource;
        }

        public CDOBranch getBranch() {
            return this.branch;
        }

        public void handle(InternalCDOCommitInfoManager manager, CDOCommitInfoHandler handler) {
            CDOCommitInfo commitInfo = manager.createCommitInfo(this.branch, this.getTimeStamp(), this.previousTimeStamp, this.userID, this.comment, this.mergeSource, null);
            handler.handleCommitInfo(commitInfo);
        }

        public String toString() {
            return MessageFormat.format("CommitInfo[{0}, {1}, {2}, {3}, {4}, {5}]", this.branch, this.getTimeStamp(), this.previousTimeStamp, this.userID, this.comment, this.mergeSource);
        }
    }

    private static class CommitInfoKey
    implements CDOTimeProvider,
    Comparable<CommitInfoKey> {
        private long timeStamp;

        public CommitInfoKey(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public int compareTo(CommitInfoKey o) {
            return CDOCommonUtil.compareTimeStamps((long)this.timeStamp, (long)o.timeStamp);
        }
    }

    private static final class DownTo
    implements Predicate<CDOTimeProvider> {
        private final long timeStamp;

        public DownTo(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Override
        public boolean test(CDOTimeProvider commitInfo) {
            return commitInfo.getTimeStamp() >= this.timeStamp;
        }
    }

    private static final class ListKey {
        private CDOID id;
        private CDOBranch branch;

        public ListKey(CDOID id, CDOBranch branch) {
            this.id = id;
            this.branch = branch;
        }

        public CDOID getID() {
            return this.id;
        }

        public CDOBranch getBranch() {
            return this.branch;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.branch.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ListKey) {
                ListKey that = (ListKey)obj;
                return this.id == that.getID() && this.branch == that.getBranch();
            }
            return false;
        }

        public String toString() {
            return MessageFormat.format("{0}:{1}", this.id, this.branch.getID());
        }
    }

    private static final class UpTo
    implements Predicate<CDOTimeProvider> {
        private final long timeStamp;

        public UpTo(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Override
        public boolean test(CDOTimeProvider commitInfo) {
            return commitInfo.getTimeStamp() <= this.timeStamp;
        }
    }
}

