/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;

public class ColumnDestroyAxisElementHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAxisManager axisManager;
        NatEventData eventData = this.getNatEventData();
        if (eventData != null && (axisManager = this.getColumnAxisManager()) != null) {
            axisManager.destroyAxisElement(this.getFullSelectedColumnsIndex(eventData));
        }
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        IAxisManager axisManager;
        super.setEnabled(evaluationContext);
        NatEventData eventData = this.getNatEventData();
        boolean enabled = false;
        if (this.isEnabled() && eventData != null && (axisManager = this.getColumnAxisManager()) != null) {
            List<Integer> col = this.getFullSelectedColumnsIndex(eventData);
            enabled = axisManager.canDestroyAxisElement(col);
        }
        this.setBaseEnabled(enabled);
    }
}

