/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.tools.emf.ui.common.IEditorFeature;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class Util {
    private static final String APP_E4XMI_DEFAULT = "Application.e4xmi";
    private static ResourceSet modelResourceSet;
    private static boolean e4ModelResourceListenerRegistered;

    static {
        e4ModelResourceListenerRegistered = false;
    }

    public static final boolean isNullOrEmpty(String element) {
        return element == null || element.trim().length() == 0;
    }

    public static final boolean isImport(EObject object) {
        return object.eContainingFeature() == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS;
    }

    public static final void addClasses(EPackage ePackage, List<IEditorFeature.FeatureClass> list) {
        for (EClassifier c : ePackage.getEClassifiers()) {
            EClass eclass;
            if (!(c instanceof EClass) || (eclass = (EClass)c) == ApplicationPackageImpl.Literals.APPLICATION || eclass.isAbstract() || eclass.isInterface() || !eclass.getEAllSuperTypes().contains((Object)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT)) continue;
            list.add(new IEditorFeature.FeatureClass(eclass.getName(), eclass));
        }
        for (EPackage eSubPackage : ePackage.getESubpackages()) {
            Util.addClasses(eSubPackage, list);
        }
    }

    public static final String getDefaultElementId(Resource resource, MApplicationElement element, IProject project) {
        try {
            EObject o = (EObject)element;
            String className = o.eClass().getName();
            String projectName = project.getName();
            String prefix = (String.valueOf(projectName) + "." + className).toLowerCase();
            TreeIterator it = resource.getAllContents();
            TreeSet<Integer> numbers = new TreeSet<Integer>();
            while (it.hasNext()) {
                String suffix;
                String elementId;
                EObject tmp = (EObject)it.next();
                if (!(tmp instanceof MApplicationElement) || (elementId = ((MApplicationElement)tmp).getElementId()) == null || elementId.length() <= prefix.length() || !elementId.startsWith(prefix) || !(suffix = elementId.substring(prefix.length())).startsWith(".") || suffix.length() <= 1) continue;
                try {
                    numbers.add(Integer.parseInt(suffix.substring(1)));
                }
                catch (Exception exception) {}
            }
            int lastNumber = -1;
            for (Integer number : numbers) {
                if (lastNumber + 1 != number) break;
                lastNumber = number;
            }
            return (String.valueOf(prefix) + "." + ++lastNumber).toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<InternalPackage> loadPackages() {
        ArrayList<InternalPackage> packs = new ArrayList<InternalPackage>();
        for (Map.Entry regEntry : EPackage.Registry.INSTANCE.entrySet()) {
            if (!(regEntry.getValue() instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)regEntry.getValue();
            InternalPackage iePackage = new InternalPackage(ePackage);
            boolean found = false;
            for (EClassifier cl : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(cl instanceof EClass) || !(eClass = (EClass)cl).getEAllSuperTypes().contains((Object)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT) || eClass.isInterface() || eClass.isAbstract()) continue;
                found = true;
                InternalClass ieClass = new InternalClass(iePackage, eClass);
                iePackage.classes.add(ieClass);
                for (EReference f : eClass.getEAllReferences()) {
                    ieClass.features.add(new InternalFeature(ieClass, (EStructuralFeature)f));
                }
            }
            if (!found) continue;
            packs.add(iePackage);
        }
        return packs;
    }

    public static boolean moveElementByIndex(EditingDomain editingDomain, MUIElement element, boolean liveModel, int index, EStructuralFeature feature) {
        if (liveModel) {
            EObject container = ((EObject)element).eContainer();
            List l = (List)container.eGet(feature);
            l.remove(element);
            if (index >= 0) {
                l.add(index, element);
            } else {
                l.add(element);
            }
            return true;
        }
        EObject container = ((EObject)element).eContainer();
        Command cmd = MoveCommand.create((EditingDomain)editingDomain, (Object)container, (Object)feature, (Object)element, (int)index);
        if (cmd.canExecute()) {
            editingDomain.getCommandStack().execute(cmd);
            return true;
        }
        return false;
    }

    public static boolean moveElementByIndex(EditingDomain editingDomain, MUIElement element, boolean liveModel, int index) {
        if (liveModel) {
            MElementContainer container = element.getParent();
            container.getChildren().remove(element);
            if (index >= 0) {
                container.getChildren().add(index, element);
            } else {
                container.getChildren().add(element);
            }
            container.setSelectedElement(element);
            return true;
        }
        MElementContainer container = element.getParent();
        Command cmd = MoveCommand.create((EditingDomain)editingDomain, (Object)container, (Object)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN, (Object)element, (int)index);
        if (cmd.canExecute()) {
            editingDomain.getCommandStack().execute(cmd);
            return true;
        }
        return false;
    }

    public static ResourceSet getModelElementResources() {
        IConfigurationElement el;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension ext;
        if (modelResourceSet != null) {
            return modelResourceSet;
        }
        Util.registerE4XmiListener();
        modelResourceSet = new ResourceSetImpl();
        PDEExtensionRegistry reg = new PDEExtensionRegistry();
        IExtension[] extensions = reg.findExtensions("org.eclipse.e4.workbench.model", true);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IExtension[] iExtensionArray = extensions;
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            ext = iExtensionArray[n4];
            iConfigurationElementArray = ext.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                el = iConfigurationElementArray[n];
                if (el.getName().equals("fragment")) {
                    IProject p = root.getProject(ext.getContributor().getName());
                    URI uri = p.exists() && p.isOpen() ? URI.createPlatformResourceURI((String)(String.valueOf(ext.getContributor().getName()) + "/" + el.getAttribute("uri")), (boolean)true) : URI.createURI((String)("platform:/plugin/" + ext.getContributor().getName() + "/" + el.getAttribute("uri")));
                    try {
                        modelResourceSet.getResource(uri, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extensions = reg.findExtensions("org.eclipse.core.runtime.products", true);
        n3 = extensions.length;
        n4 = 0;
        while (n4 < n3) {
            ext = iExtensionArray[n4];
            iConfigurationElementArray = ext.getConfigurationElements();
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                el = iConfigurationElementArray[n];
                if (el.getName().equals("product")) {
                    boolean xmiPropertyPresent = false;
                    IConfigurationElement[] iConfigurationElementArray2 = el.getChildren("property");
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement prop = iConfigurationElementArray2[n6];
                        if (prop.getAttribute("name").equals("applicationXMI")) {
                            String v = prop.getAttribute("value");
                            Util.setUpResourceSet(modelResourceSet, root, v);
                            xmiPropertyPresent = true;
                            break;
                        }
                        ++n6;
                    }
                    if (!xmiPropertyPresent) {
                        Util.setUpResourceSet(modelResourceSet, root, String.valueOf(ext.getNamespaceIdentifier()) + "/" + APP_E4XMI_DEFAULT);
                        break;
                    }
                }
                ++n;
            }
            ++n4;
        }
        return modelResourceSet;
    }

    private static void registerE4XmiListener() {
        if (!e4ModelResourceListenerRegistered) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    if (modelResourceSet == null) {
                        return;
                    }
                    IResourceDelta delta = event.getDelta();
                    this.checkDeltaContainsE4xmi(delta);
                }

                private void checkDeltaContainsE4xmi(IResourceDelta delta) {
                    if (modelResourceSet == null) {
                        return;
                    }
                    IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                    int n = iResourceDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta rd = iResourceDeltaArray[n2];
                        IResource r = rd.getResource();
                        if (r instanceof IFile) {
                            if ("e4xmi".equals(((IFile)r).getFileExtension())) {
                                modelResourceSet = null;
                                break;
                            }
                        } else {
                            this.checkDeltaContainsE4xmi(rd);
                        }
                        ++n2;
                    }
                }
            });
            e4ModelResourceListenerRegistered = true;
        }
    }

    private static void setUpResourceSet(ResourceSet resourceSet, IWorkspaceRoot root, String v) {
        String[] s = v.split("/");
        IProject p = root.getProject(s[0]);
        URI uri = p.exists() && p.isOpen() ? URI.createPlatformResourceURI((String)v, (boolean)true) : URI.createURI((String)("platform:/plugin/" + v));
        try {
            if (resourceSet.getURIConverter().exists(uri, null)) {
                resourceSet.getResource(uri, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Image scaleImage(Image img, int maxSize) {
        Image result = img;
        double scale2 = (double)maxSize / (double)img.getImageData().width;
        double scale1 = (double)maxSize / (double)img.getImageData().height;
        if (scale2 < scale1) {
            scale1 = scale2;
        }
        if (scale1 < 1.0) {
            int height;
            int width = (int)((double)img.getImageData().width * scale1);
            if (width == 0) {
                width = 1;
            }
            if ((height = (int)((double)img.getImageData().height * scale1)) == 0) {
                height = 1;
            }
            Image img2 = new Image(img.getDevice(), img.getImageData().scaledTo(width, height));
            img.dispose();
            result = img2;
        }
        return result;
    }

    public static boolean canBeExtendedInAFragment(EClass c) {
        boolean result = false;
        for (EReference r : c.getEAllReferences()) {
            if (!Util.referenceIsModelFragmentCompliant(r)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean referenceIsModelFragmentCompliant(EReference r) {
        String t = r.getEReferenceType().getName();
        return r.isContainment() && !t.equals("StringToStringMap") && !t.equals("StringToObjectMap");
    }

    public static final void addDecoration(Control control, Binding binding) {
        ControlDecoration dec = new ControlDecoration(control, 1024);
        binding.getValidationStatus().addValueChangeListener(event -> {
            IStatus s = (IStatus)event.getObservableValue().getValue();
            if (s.isOK()) {
                dec.setDescriptionText(null);
                dec.setImage(null);
            } else {
                dec.setDescriptionText(s.getMessage());
                String fieldDecorationID = null;
                switch (s.getSeverity()) {
                    case 1: {
                        fieldDecorationID = "DEC_INFORMATION";
                        break;
                    }
                    case 2: {
                        fieldDecorationID = "DEC_WARNING";
                        break;
                    }
                    case 4: 
                    case 8: {
                        fieldDecorationID = "DEC_ERROR";
                    }
                }
                FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationID);
                dec.setImage(fieldDecoration == null ? null : fieldDecoration.getImage());
            }
        });
    }

    public static class InternalClass {
        public final InternalPackage pack;
        public final EClass eClass;
        public List<InternalFeature> features = new ArrayList<InternalFeature>();

        public InternalClass(InternalPackage pack, EClass eClass) {
            this.eClass = eClass;
            this.pack = pack;
        }
    }

    public static class InternalFeature {
        public final InternalClass clazz;
        public final EStructuralFeature feature;

        public InternalFeature(InternalClass clazz, EStructuralFeature feature) {
            this.clazz = clazz;
            this.feature = feature;
        }
    }

    public static class InternalPackage {
        public final EPackage ePackage;
        public List<InternalClass> classes = new ArrayList<InternalClass>();

        public InternalPackage(EPackage ePackage) {
            this.ePackage = ePackage;
        }

        public String toString() {
            return this.ePackage.toString();
        }

        public List<EClass> getAllClasses() {
            ArrayList<EClass> rv = new ArrayList<EClass>(this.classes.size());
            for (InternalClass c : this.classes) {
                rv.add(c.eClass);
            }
            return rv;
        }
    }
}

