/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOLock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectHistory;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.impl.MinimalEStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDOLockImpl;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOLoadable;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOObjectImpl
extends MinimalEStoreEObjectImpl
implements InternalCDOObject {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOObjectImpl.class);
    private static final BasicNotifierImpl.EObservableAdapterList.Listener ADAPTERS_LISTENER = new BasicNotifierImpl.EObservableAdapterList.Listener(){

        public void added(Notifier notifier, Adapter adapter) {
            CDOObjectImpl object = (CDOObjectImpl)notifier;
            object.eAdapterAdded(adapter);
        }

        public void removed(Notifier notifier, Adapter adapter) {
            CDOObjectImpl object = (CDOObjectImpl)notifier;
            object.eAdapterRemoved(adapter);
        }
    };
    private static final BasicNotifierImpl.EObservableAdapterList.Listener[] ADAPTERS_LISTENERS = new BasicNotifierImpl.EObservableAdapterList.Listener[]{ADAPTERS_LISTENER};
    private static final boolean EMF_TO_STRING = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.internal.cdo.CDOObjectImpl.emfToString");
    private static final boolean OPTIMIZE_UNORDERED_LISTS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.internal.cdo.CDOObjectImpl.optimizeUnorderedLists");
    private InternalCDOView.ViewAndState viewAndState = InternalCDOView.ViewAndState.TRANSIENT;
    private InternalCDORevision revision;
    private Object[] eSettings;

    public CDOObjectImpl() {
        this.initClassInfo(this.eStaticClass());
    }

    @Override
    public final InternalCDOClassInfo cdoClassInfo() {
        return this.revision.getClassInfo();
    }

    @Override
    public final CDOState cdoState() {
        return this.viewAndState.state;
    }

    @Override
    public final InternalCDOView cdoView() {
        return this.viewAndState.view;
    }

    @Override
    public final CDOID cdoID() {
        return this.revision.getID();
    }

    @Override
    public final InternalCDORevision cdoRevision() {
        return this.revision.getProperRevision();
    }

    @Override
    public final InternalCDORevision cdoRevision(boolean loadOnDemand) {
        InternalCDORevision revision = this.cdoRevision();
        if (revision == null && loadOnDemand) {
            revision = CDOStateMachine.INSTANCE.read(this);
        }
        return revision;
    }

    @Override
    public final CDOPermission cdoPermission() {
        if (FSMUtil.isTransient(this)) {
            return CDOPermission.WRITE;
        }
        return this.cdoRevision(true).getPermission();
    }

    @Override
    public final CDOResource cdoResource() {
        Resource resource = this.eResource();
        if (resource instanceof CDOResource) {
            return (CDOResource)resource;
        }
        return null;
    }

    @Override
    public final CDOResource cdoDirectResource() {
        Resource.Internal resource = this.eDirectResource();
        if (resource instanceof CDOResource) {
            return (CDOResource)resource;
        }
        return null;
    }

    @Override
    public final void cdoPrefetch(int depth) {
        CDOID id = this.cdoID();
        this.viewAndState.view.prefetchRevisions(id, depth);
    }

    @Override
    @Deprecated
    public final void cdoReload() {
        CDOStateMachine.INSTANCE.reload(this);
    }

    @Override
    public final CDOObjectHistory cdoHistory() {
        return (CDOObjectHistory)this.viewAndState.view.getHistory(this);
    }

    @Override
    public final boolean cdoConflict() {
        return FSMUtil.isConflict(this);
    }

    @Override
    public final boolean cdoInvalid() {
        return FSMUtil.isInvalid(this);
    }

    @Override
    public final CDOLock cdoReadLock() {
        return CDOObjectImpl.createLock(this, IRWLockManager.LockType.READ);
    }

    @Override
    public final CDOLock cdoWriteLock() {
        return CDOObjectImpl.createLock(this, IRWLockManager.LockType.WRITE);
    }

    @Override
    public final CDOLock cdoWriteOption() {
        return CDOObjectImpl.createLock(this, IRWLockManager.LockType.OPTION);
    }

    @Override
    public final CDOLockState cdoLockState() {
        return CDOObjectImpl.getLockState(this);
    }

    @Override
    public final CDOState cdoInternalSetState(CDOState state) {
        CDOState oldState = this.viewAndState.state;
        if (oldState != state) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} for {1}", new Object[]{state, this});
            }
            this.viewAndState = this.viewAndState.getViewAndState(state);
            if (this.viewAndState.view != null) {
                this.viewAndState.view.handleObjectStateChanged(this, oldState, state);
            }
            return oldState;
        }
        return null;
    }

    @Override
    public final void cdoInternalSetView(CDOView view) {
        InternalCDOView newView = (InternalCDOView)view;
        this.viewAndState = newView != null ? newView.getViewAndState(this.viewAndState.state) : InternalCDOView.ViewAndState.TRANSIENT.getViewAndState(this.viewAndState.state);
    }

    @Override
    public final void cdoInternalSetID(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting ID: {0}", new Object[]{id});
        }
        this.revision = id == null ? this.cdoClassInfo().getRevisionForID(null) : this.revision.getRevisionForID(id);
    }

    @Override
    public final void cdoInternalSetRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revision: {0}", new Object[]{revision});
        }
        if (revision == null) {
            InternalCDOClassInfo classInfo = this.cdoClassInfo();
            CDOID id = this.revision.getID();
            this.revision = classInfo.getRevisionForID(id);
        } else {
            CDOID objectID;
            if (this.revision != null && (objectID = this.revision.getID()) != null && objectID != revision.getID()) {
                throw new IllegalArgumentException("The revision " + revision + " does not match the object " + objectID);
            }
            this.revision = (InternalCDORevision)revision;
        }
    }

    public final void cdoInternalSetResource(CDOResource resource) {
        if (resource != null) {
            throw new IllegalArgumentException("Only intended to be called by CDOTransactionImpl.removeObject(CDOID, CDOObject");
        }
        super.eSetDirectResource(null);
        this.eBasicSetContainer(null);
        this.eBasicSetContainerFeatureID(0);
    }

    @Override
    public void cdoInternalPreLoad() {
    }

    @Override
    public final void cdoInternalPostLoad() {
        Object[] eSettings = this.eBasicSettings();
        if (eSettings != null) {
            InternalCDOClassInfo classInfo = this.cdoClassInfo();
            int featureCount = classInfo.getEClass().getFeatureCount();
            int i = 0;
            while (i < featureCount) {
                Object value;
                int index = classInfo.getSettingsFeatureIndex(i);
                if (index != -1 && (value = eSettings[index]) instanceof InternalCDOLoadable) {
                    ((InternalCDOLoadable)value).cdoInternalPostLoad();
                }
                ++i;
            }
        }
    }

    @Override
    public final void cdoInternalPostInvalidate() {
        this.cdoInternalSetRevision(null);
    }

    @Override
    public void cdoInternalPreAttach() {
    }

    @Override
    public final void cdoInternalPostAttach() {
        if (TRACER.isEnabled()) {
            TRACER.format("Populating revision for {0}", new Object[]{this});
        }
        InternalEObject eContainer = this.eBasicInternalContainer();
        int eContainerFeatureID = this.eBasicContainerFeatureID();
        InternalCDORevision revision = this.cdoRevision();
        revision.setContainerID(eContainer == null ? CDOID.NULL : this.viewAndState.view.convertObjectToID(eContainer, true));
        revision.setContainingFeatureID(eContainerFeatureID);
        Resource.Internal directResource = this.eDirectResource();
        if (directResource instanceof CDOResource) {
            CDOResource cdoResource = (CDOResource)directResource;
            revision.setResourceID(cdoResource.cdoID());
        }
        if (this.eSettings != null) {
            InternalCDOClassInfo classInfo = this.cdoClassInfo();
            EStructuralFeature[] allPersistentFeatures = classInfo.getAllPersistentFeatures();
            int length = allPersistentFeatures.length;
            int i = 0;
            while (i < length) {
                EStructuralFeature eFeature = allPersistentFeatures[i];
                int transientIndex = classInfo.getTransientFeatureIndex(eFeature);
                Object setting = this.eSettings[transientIndex];
                CDOObjectImpl.instanceToRevisionFeature(this.viewAndState.view, this, eFeature, setting);
                ++i;
            }
            this.cdoRevision().setUnchunked();
            int newSize = classInfo.getSettingsFeatureCount();
            if (newSize != this.eSettings.length) {
                Object[] newSettings = new Object[newSize];
                System.arraycopy(this.eSettings, 0, newSettings, 0, newSize);
                this.eSettings = newSettings;
            }
        }
    }

    @Override
    public void cdoInternalPostDetach(boolean remote) {
        EStructuralFeature[] allPersistentFeatures;
        int newSize;
        if (remote) {
            assert (this.cdoState() == CDOState.INVALID);
            this.eSetDeliver(false);
            this.eBasicSetContainer(null, this.eContainerFeatureID());
            this.eSetDeliver(true);
            return;
        }
        assert (this.cdoState() == CDOState.TRANSIENT);
        if (TRACER.isEnabled()) {
            TRACER.format("Depopulating revision for {0}", new Object[]{this});
        }
        InternalCDOClassInfo classInfo = this.cdoClassInfo();
        CDOStore store = this.cdoStore();
        Resource.Internal resource = (Resource.Internal)store.getResource(this);
        super.eSetDirectResource(resource);
        InternalEObject container = store.getContainer(this);
        this.eBasicSetContainer(container);
        int containingFeatureID = store.getContainingFeatureID(this);
        this.eBasicSetContainerFeatureID(containingFeatureID);
        if (this.eSettings != null && (newSize = classInfo.getSettingsFeatureCount() + classInfo.getTransientFeatureCount()) != this.eSettings.length) {
            Object[] newSettings = new Object[newSize];
            System.arraycopy(this.eSettings, 0, newSettings, 0, this.eSettings.length);
            this.eSettings = newSettings;
        }
        InternalCDORevision revision = this.cdoRevision();
        EStructuralFeature[] eStructuralFeatureArray = allPersistentFeatures = classInfo.getAllPersistentFeatures();
        int n = allPersistentFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature eFeature = eStructuralFeatureArray[n2];
            CDOObjectImpl.revisionToInstanceFeature(this, revision, eFeature);
            ++n2;
        }
    }

    @Override
    public final void cdoInternalPostRollback() {
    }

    @Override
    public final void cdoInternalPreCommit() {
    }

    @Override
    public final InternalEObject cdoInternalInstance() {
        return this;
    }

    @Override
    @Deprecated
    public final EStructuralFeature cdoInternalDynamicFeature(int dynamicFeatureID) {
        throw new UnsupportedOperationException();
    }

    private CDOStore cdoStore() {
        return this.viewAndState.view.getStore();
    }

    public final InternalEObject.EStore eStore() {
        if (FSMUtil.isTransient(this)) {
            return TransientStore.INSTANCE;
        }
        return this.cdoStore();
    }

    protected final EClass eDynamicClass() {
        EClass eClass = this.eClass();
        if (eClass == this.eStaticClass()) {
            return null;
        }
        return eClass;
    }

    public final EClass eClass() {
        return this.revision.getEClass();
    }

    public void eSetClass(EClass eClass) {
        this.initClassInfo(eClass);
    }

    public Resource.Internal eDirectResource() {
        if (FSMUtil.isTransient(this)) {
            return super.eDirectResource();
        }
        return (Resource.Internal)this.cdoStore().getResource(this);
    }

    public final Resource.Internal eInternalResource() {
        InternalCDOView view = this.cdoView();
        if (view != null && view.isClosed()) {
            return null;
        }
        if (FSMUtil.isInvalid(this)) {
            return null;
        }
        return super.eInternalResource();
    }

    public final Object dynamicGet(int dynamicFeatureID) {
        InternalCDOClassInfo classInfo = this.cdoClassInfo();
        int index = classInfo.getSettingsFeatureIndex(dynamicFeatureID);
        if (index == -1) {
            EStructuralFeature eStructuralFeature = this.eDynamicFeature(dynamicFeatureID);
            InternalEObject.EStore eStore = this.eStore();
            return eStore.get((InternalEObject)this, eStructuralFeature, -1);
        }
        Object[] eSettings = this.eBasicSettings();
        EList<?> result = eSettings[index];
        if (result == null) {
            EStructuralFeature eStructuralFeature = this.eDynamicFeature(dynamicFeatureID);
            if (classInfo.isPersistent(dynamicFeatureID)) {
                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                    result = this.createFeatureMap(eStructuralFeature);
                    eSettings[index] = result;
                } else if (eStructuralFeature.isMany()) {
                    eSettings[index] = result = this.createList(eStructuralFeature);
                }
            }
        }
        return result;
    }

    public final void dynamicSet(int dynamicFeatureID, Object value) {
        InternalCDOClassInfo classInfo = this.cdoClassInfo();
        int index = classInfo.getSettingsFeatureIndex(dynamicFeatureID);
        if (index == -1) {
            EStructuralFeature eStructuralFeature = this.eDynamicFeature(dynamicFeatureID);
            InternalEObject.EStore eStore = this.eStore();
            eStore.set((InternalEObject)this, eStructuralFeature, -1, value);
        } else {
            Object[] eSettings = this.eBasicSettings();
            eSettings[index] = value;
        }
    }

    public final void dynamicUnset(int dynamicFeatureID) {
        InternalCDOClassInfo classInfo = this.cdoClassInfo();
        int index = classInfo.getSettingsFeatureIndex(dynamicFeatureID);
        if (index == -1) {
            EStructuralFeature eStructuralFeature = this.eDynamicFeature(dynamicFeatureID);
            InternalEObject.EStore eStore = this.eStore();
            eStore.unset((InternalEObject)this, eStructuralFeature);
        } else {
            Object[] eSettings = this.eBasicSettings();
            Object oldValue = eSettings[index];
            if (oldValue != null) {
                if (oldValue instanceof InternalEList) {
                    InternalEList list = (InternalEList)oldValue;
                    if (list instanceof InternalEList.Unsettable) {
                        ((InternalEList.Unsettable)list).unset();
                    } else {
                        list.clear();
                    }
                } else {
                    eSettings[index] = null;
                }
            }
        }
    }

    protected final boolean eDynamicIsSet(int dynamicFeatureID, EStructuralFeature eFeature) {
        if (dynamicFeatureID < 0) {
            return this.eOpenIsSet(eFeature);
        }
        InternalCDOClassInfo classInfo = this.cdoClassInfo();
        if (classInfo.isPersistent(dynamicFeatureID)) {
            return this.eStore().isSet((InternalEObject)this, eFeature);
        }
        return this.eSettingDelegate(eFeature).dynamicIsSet((InternalEObject)this, this.eSettings(), dynamicFeatureID);
    }

    public final InternalEObject eInternalContainer() {
        if (FSMUtil.isTransient(this) || FSMUtil.isInvalid(this)) {
            return this.eBasicInternalContainer();
        }
        return this.cdoStore().getContainer(this);
    }

    public final int eContainerFeatureID() {
        if (FSMUtil.isTransient(this) || FSMUtil.isInvalid(this)) {
            return this.eBasicContainerFeatureID();
        }
        return this.cdoStore().getContainingFeatureID(this);
    }

    public NotificationChain eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID, NotificationChain msgs) {
        boolean newAttached;
        boolean oldAttached;
        InternalEObject oldContainer = this.eInternalContainer();
        Resource.Internal oldResource = this.eDirectResource();
        Resource.Internal newResource = null;
        EReference newContainmentFeature = null;
        if (oldResource != null) {
            if (newContainer != null) {
                newContainmentFeature = CDOObjectImpl.eContainmentFeature((EObject)this, (EObject)newContainer, (int)newContainerFeatureID);
                if (!newContainmentFeature.isResolveProxies()) {
                    msgs = ((InternalEList)oldResource.getContents()).basicRemove((Object)this, msgs);
                    this.eSetDirectResource(null);
                    newResource = newContainer.eInternalResource();
                } else {
                    oldResource = null;
                }
            } else {
                oldResource = null;
            }
        } else {
            if (oldContainer != null) {
                oldResource = oldContainer.eInternalResource();
            }
            if (newContainer != null) {
                newResource = newContainer.eInternalResource();
            }
        }
        InternalCDOView oldView = this.viewAndState.view;
        CDOView newView = newResource instanceof CDOResource ? ((CDOResource)newResource).cdoView() : null;
        boolean movedWithinView = oldView != null && oldView == newView;
        boolean bl = oldAttached = this.viewAndState.state != CDOState.TRANSIENT;
        boolean bl2 = newContainer != null && newView != null ? FSMUtil.adapt(newContainer, newView).cdoState() != CDOState.TRANSIENT : (newAttached = true);
        if (newAttached) {
            if (newContainmentFeature == null && newContainer != null) {
                newContainmentFeature = CDOObjectImpl.eContainmentFeature((EObject)this, (EObject)newContainer, (int)newContainerFeatureID);
            }
            if (newContainmentFeature != null && !EMFUtil.isPersistent((EStructuralFeature)newContainmentFeature)) {
                newAttached = false;
            }
        }
        if (newAttached != oldAttached) {
            movedWithinView = false;
        }
        if (oldResource != null) {
            if (oldResource instanceof CDOResource) {
                if (oldAttached && !movedWithinView && !this.isRootResource()) {
                    oldResource.detached((EObject)this);
                }
            } else if (oldResource != newResource) {
                oldResource.detached((EObject)this);
            }
        }
        int oldContainerFeatureID = this.eContainerFeatureID();
        this.eBasicSetContainer(newContainer, newContainerFeatureID);
        if (newResource != null) {
            if (newResource instanceof CDOResource) {
                if (newAttached && !movedWithinView) {
                    newResource.attached((EObject)this);
                }
            } else if (oldResource != newResource) {
                newResource.attached((EObject)this);
            }
        }
        if (newContainer != null && newContainer != oldContainer && this instanceof CDOResourceNodeImpl) {
            ((CDOResourceNodeImpl)this).recacheURIs();
        }
        if (this.eNotificationRequired()) {
            ENotificationImpl notification;
            if (oldContainer != null && oldContainerFeatureID >= 0 && oldContainerFeatureID != newContainerFeatureID) {
                notification = new ENotificationImpl((InternalEObject)this, 1, oldContainerFeatureID, (Object)oldContainer, null);
                if (msgs == null) {
                    msgs = notification;
                } else {
                    msgs.add((Notification)notification);
                }
            }
            if (newContainerFeatureID >= 0) {
                notification = new ENotificationImpl((InternalEObject)this, 1, newContainerFeatureID, oldContainerFeatureID == newContainerFeatureID ? oldContainer : null, (Object)newContainer);
                if (msgs == null) {
                    msgs = notification;
                } else {
                    msgs.add((Notification)notification);
                }
            }
        }
        return msgs;
    }

    public final NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications) {
        InternalEObject oldContainer;
        boolean isSameView;
        CDOView newView;
        Resource.Internal oldResource = this.eDirectResource();
        InternalCDOView oldView = this.viewAndState.view;
        CDOView cDOView = newView = resource != null && resource instanceof CDOResource ? ((CDOResource)resource).cdoView() : null;
        if (this.viewAndState.state == CDOState.NEW) {
            isSameView = false;
        } else {
            boolean bl = isSameView = oldView != null && oldView == newView;
        }
        if (oldResource != null && resource != null) {
            notifications = ((InternalEList)oldResource.getContents()).basicRemove((Object)this, notifications);
            if (!isSameView) {
                oldResource.detached((EObject)this);
            }
        }
        if ((oldContainer = this.eInternalContainer()) != null && !isSameView) {
            if (this.eContainmentFeature().isResolveProxies()) {
                Resource.Internal oldContainerResource = oldContainer.eInternalResource();
                if (oldContainerResource != null) {
                    if (resource == null) {
                        oldContainerResource.attached((EObject)this);
                    } else if (oldResource == null) {
                        oldContainerResource.detached((EObject)this);
                    }
                }
            } else {
                notifications = this.eBasicRemoveFromContainer(notifications);
                notifications = this.eBasicSetContainer(null, -1, notifications);
            }
        }
        this.eSetDirectResource(resource);
        return notifications;
    }

    protected void eSetDirectResource(Resource.Internal resource) {
        if (FSMUtil.isTransient(this)) {
            super.eSetDirectResource(resource);
        } else if (resource == null || resource instanceof CDOResource) {
            this.cdoStore().setContainer(this, (CDOResource)resource, this.eInternalContainer(), this.eContainerFeatureID());
        } else {
            throw new IllegalArgumentException(Messages.getString("CDOObjectImpl.8"));
        }
    }

    protected final void eBasicSetContainer(InternalEObject newEContainer, int newContainerFeatureID) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting container: {0}, featureID={1}", new Object[]{newEContainer, newContainerFeatureID});
        }
        if (FSMUtil.isTransient(this) || FSMUtil.isInvalid(this)) {
            super.eBasicSetContainer(newEContainer, newContainerFeatureID);
        } else {
            CDOStore cdoStore = this.cdoStore();
            cdoStore.setContainer(this, this.cdoDirectResource(), newEContainer, newContainerFeatureID);
        }
    }

    protected final int eDynamicFeatureID(EStructuralFeature eStructuralFeature) {
        EClass eClass = this.eClass();
        return eClass.getFeatureID(eStructuralFeature);
    }

    protected final EStructuralFeature eDynamicFeature(int dynamicFeatureID) {
        EClass eClass = this.eClass();
        return eClass.getEStructuralFeature(dynamicFeatureID);
    }

    protected final EStructuralFeature.Internal.DynamicValueHolder eSettings() {
        if (!this.eHasSettings()) {
            InternalCDOClassInfo classInfo = this.cdoClassInfo();
            int size = classInfo.getSettingsFeatureCount();
            if (FSMUtil.isTransient(this)) {
                size += classInfo.getTransientFeatureCount();
            }
            if (size != 0) {
                this.eBasicSetSettings(new Object[size]);
            }
        }
        return this;
    }

    protected final boolean eHasSettings() {
        return this.eSettings != null;
    }

    protected final Object[] eBasicSettings() {
        return this.eSettings;
    }

    protected final void eBasicSetSettings(Object[] settings) {
        this.eSettings = settings;
    }

    protected final boolean eIsCaching() {
        return false;
    }

    protected final Adapter[] eContainerAdapterArray() {
        Object containerID;
        CDOObject container;
        if (FSMUtil.isTransient(this)) {
            return super.eContainerAdapterArray();
        }
        InternalCDOView view = this.cdoView();
        if (view.isClosed()) {
            return null;
        }
        InternalCDORevision revision = this.cdoRevision();
        if (revision != null && (container = (containerID = revision.getContainerID()) instanceof CDOID ? view.getObject((CDOID)containerID, false) : (CDOObject)containerID) != null) {
            if (container instanceof CDOObjectImpl) {
                return ((CDOObjectImpl)container).eBasicAdapterArray();
            }
            if (container instanceof BasicEObjectImpl) {
                return super.eContainerAdapterArray();
            }
        }
        return null;
    }

    protected final BasicNotifierImpl.EObservableAdapterList.Listener[] eBasicAdapterListeners() {
        BasicNotifierImpl.EObservableAdapterList.Listener[] listeners = super.eBasicAdapterListeners();
        if (listeners == null) {
            return ADAPTERS_LISTENERS;
        }
        return listeners;
    }

    protected final void eBasicSetAdapterListeners(BasicNotifierImpl.EObservableAdapterList.Listener[] eAdapterListeners) {
        if (eAdapterListeners != null && eAdapterListeners.length == 1) {
            eAdapterListeners = null;
        }
        super.eBasicSetAdapterListeners(eAdapterListeners);
    }

    protected final void eAdapterAdded(Adapter adapter) {
        if (!FSMUtil.isTransient(this)) {
            this.viewAndState.view.handleAddAdapter(this, adapter);
        }
    }

    protected final void eAdapterRemoved(Adapter adapter) {
        if (!FSMUtil.isTransient(this)) {
            this.viewAndState.view.handleRemoveAdapter(this, adapter);
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        CDOState cdoState;
        if (EMF_TO_STRING) {
            return super.toString();
        }
        String str = this.eClass().getName();
        CDOID id = this.cdoID();
        if (id != null) {
            str = String.valueOf(str) + "@" + id;
        }
        if ((cdoState = this.cdoState()) != CDOState.CLEAN) {
            str = String.valueOf(str) + "[" + (Object)((Object)cdoState) + "]";
        }
        return str;
    }

    protected final FeatureMap createFeatureMap(EStructuralFeature eStructuralFeature) {
        return new CDOStoreFeatureMap(eStructuralFeature);
    }

    protected EList<?> createList(EStructuralFeature eStructuralFeature) {
        if (this.isMap(eStructuralFeature)) {
            return this.createMap(eStructuralFeature);
        }
        if (OPTIMIZE_UNORDERED_LISTS && !eStructuralFeature.isOrdered()) {
            return this.createUnorderedList(eStructuralFeature);
        }
        return this.createOrderedList(eStructuralFeature);
    }

    protected final CDOStoreEList createOrderedList(EStructuralFeature eStructuralFeature) {
        return new CDOStoreEList(this, eStructuralFeature, null, null);
    }

    protected final CDOStoreUnorderedEList<Object> createUnorderedList(EStructuralFeature eStructuralFeature) {
        return new CDOStoreUnorderedEList<Object>(eStructuralFeature);
    }

    protected final CDOStoreEcoreEMap createMap(EStructuralFeature eStructuralFeature) {
        return new CDOStoreEcoreEMap(eStructuralFeature);
    }

    private boolean isMap(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.getEType().getInstanceClassName() == "java.util.Map$Entry";
    }

    private boolean isRootResource() {
        return this instanceof CDOResource && ((CDOResource)((Object)this)).isRoot();
    }

    private void initClassInfo(EClass eClass) {
        InternalCDOClassInfo classInfo = (InternalCDOClassInfo)CDOModelUtil.getClassInfo((EClass)eClass);
        this.revision = classInfo.getRevisionForID(null);
    }

    private static void adjustOppositeReference(InternalCDOObject instance, InternalEObject opposite, EReference oppositeReference) {
        if (opposite != null) {
            InternalCDOObject cdoObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)opposite);
            if (cdoObject != null && !FSMUtil.isTransient(cdoObject)) {
                if (oppositeReference.isMany()) {
                    InternalEObject.EStore eStore = cdoObject.eStore();
                    int index = eStore.indexOf((InternalEObject)cdoObject, (EStructuralFeature)oppositeReference, (Object)instance.cdoID());
                    if (index != -1) {
                        eStore.set((InternalEObject)cdoObject, (EStructuralFeature)oppositeReference, index, (Object)instance);
                    }
                } else {
                    InternalEObject.EStore eStore = cdoObject.eStore();
                    eStore.set((InternalEObject)cdoObject, (EStructuralFeature)oppositeReference, 0, (Object)instance);
                }
            } else if (oppositeReference.isResolveProxies()) {
                if (oppositeReference.isMany()) {
                    List list = (List)opposite.eGet((EStructuralFeature)oppositeReference);
                    int index = list.indexOf(instance);
                    if (index != -1) {
                        list.set(index, instance);
                    }
                } else {
                    opposite.eSet((EStructuralFeature)oppositeReference, (Object)instance);
                }
            }
        }
    }

    public static void instanceToRevisionFeature(InternalCDOView view, InternalCDOObject object, EStructuralFeature feature, Object setting) {
        InternalCDOClassInfo.PersistenceFilter filter;
        if (TRACER.isEnabled()) {
            TRACER.format("Populating feature {0}", new Object[]{feature});
        }
        if ((filter = ((InternalCDOClassInfo)CDOModelUtil.getClassInfo((EClass)feature.getEContainingClass())).getPersistenceFilter(feature)) != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Filtering value of feature {0}", new Object[]{feature});
            }
            setting = filter.getPersistableValue((EObject)object, setting);
        }
        CDOStore cdoStore = view.getStore();
        InternalCDORevision revision = object.cdoRevision();
        if (feature.isMany()) {
            if (setting != null) {
                EList instanceList = (EList)setting;
                int size = instanceList.size();
                if (feature.isUnsettable() ? !object.eIsSet(feature) : size == 0) {
                    return;
                }
                CDOList revisionList = revision.getOrCreateList(feature, size);
                for (Object value : instanceList) {
                    Object cdoValue = cdoStore.convertToCDO(object, feature, value);
                    revisionList.add(cdoValue);
                }
            }
        } else {
            Object cdoValue = cdoStore.convertToCDO(object, feature, setting);
            revision.set(feature, 0, cdoValue);
        }
    }

    public static void revisionToInstanceFeature(InternalCDOObject instance, InternalCDORevision revision, EStructuralFeature eFeature) {
        if (TRACER.isEnabled()) {
            TRACER.format("Depopulating feature {0}", new Object[]{eFeature});
        }
        EStructuralFeature.Internal internalFeature = (EStructuralFeature.Internal)eFeature;
        InternalCDOView view = instance.cdoView();
        EReference oppositeReference = view.isObjectNew(instance.cdoID()) ? null : internalFeature.getEOpposite();
        CDOStore cdoStore = view.getStore();
        InternalEObject.EStore eStore = instance.eStore();
        if (eFeature.isMany()) {
            int size = cdoStore.size(instance, eFeature);
            int index = 0;
            while (index < size) {
                Object opposite = cdoStore.get(instance, eFeature, index);
                eStore.add((InternalEObject)instance, eFeature, index, opposite);
                if (oppositeReference != null) {
                    CDOObjectImpl.adjustOppositeReference(instance, (InternalEObject)opposite, oppositeReference);
                }
                ++index;
            }
        } else {
            Object opposite = cdoStore.get(instance, eFeature, -1);
            eStore.set((InternalEObject)instance, eFeature, -1, opposite);
            if (oppositeReference != null) {
                CDOObjectImpl.adjustOppositeReference(instance, (InternalEObject)opposite, oppositeReference);
            }
        }
    }

    public static CDOLock createLock(InternalCDOObject object, IRWLockManager.LockType type) {
        if (FSMUtil.isTransient(object)) {
            throw new IllegalStateException("Call CDOView.lockObjects() for transient object " + object);
        }
        return new CDOLockImpl(object, type);
    }

    public static CDOLockState getLockState(InternalCDOObject object) {
        if (FSMUtil.isTransient(object)) {
            return null;
        }
        InternalCDOView view = object.cdoView();
        CDOID id = object.cdoID();
        return view.getLockStates(Collections.singletonList(id))[0];
    }

    private class CDOStoreEList
    extends EStoreEObjectImpl.BasicEStoreEList<Object> {
        private static final long serialVersionUID = 1L;

        private CDOStoreEList(InternalEObject owner, EStructuralFeature eStructuralFeature) {
            super(owner, eStructuralFeature);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unset() {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.unset();
                return;
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                try {
                    super.unset();
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.inverseAdd(object, notifications);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                NotificationChain notificationChain;
                view.lockView();
                try {
                    notificationChain = super.inverseAdd(object, notifications);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return notificationChain;
            }
        }

        public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.inverseRemove(object, notifications);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                NotificationChain notificationChain;
                view.lockView();
                try {
                    notificationChain = super.inverseRemove(object, notifications);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return notificationChain;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object newValue) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.set(newValue);
                return;
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                try {
                    super.set(newValue);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(Object object) {
            Object viewMonitor;
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.addUnique(object);
                return;
            }
            Object object2 = viewMonitor = view.getViewMonitor();
            synchronized (object2) {
                view.lockView();
                try {
                    super.addUnique(object);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(int index, Object object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.addUnique(index, object);
                return;
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                view.lockView();
                try {
                    super.addUnique(index, object);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public boolean addAllUnique(Collection<? extends Object> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAllUnique(collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAllUnique(collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean addAllUnique(int index, Collection<? extends Object> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAllUnique(index, collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAllUnique(index, collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean addAllUnique(Object[] objects, int start, int end) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAllUnique(objects, start, end);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAllUnique(objects, start, end);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean addAllUnique(int index, Object[] objects, int start, int end) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAllUnique(index, objects, start, end);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAllUnique(index, objects, start, end);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public NotificationChain basicAdd(Object object, NotificationChain notifications) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.basicAdd(object, notifications);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                NotificationChain notificationChain;
                view.lockView();
                try {
                    notificationChain = super.basicAdd(object, notifications);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return notificationChain;
            }
        }

        public Object remove(int index) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.remove(index);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                Object object2;
                view.lockView();
                try {
                    object2 = super.remove(index);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return object2;
            }
        }

        public boolean removeAll(Collection<?> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.removeAll(collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.removeAll(collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.basicRemove(object, notifications);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                NotificationChain notificationChain;
                view.lockView();
                try {
                    notificationChain = super.basicRemove(object, notifications);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return notificationChain;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.clear();
                return;
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                try {
                    super.clear();
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public Object setUnique(int index, Object object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.setUnique(index, object);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                Object object3;
                view.lockView();
                try {
                    object3 = super.setUnique(index, object);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return object3;
            }
        }

        public NotificationChain basicSet(int index, Object object, NotificationChain notifications) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.basicSet(index, object, notifications);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                NotificationChain notificationChain;
                view.lockView();
                try {
                    notificationChain = super.basicSet(index, object, notifications);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return notificationChain;
            }
        }

        public Object move(int targetIndex, int sourceIndex) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.move(targetIndex, sourceIndex);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                Object object2;
                view.lockView();
                try {
                    object2 = super.move(targetIndex, sourceIndex);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return object2;
            }
        }

        public boolean remove(Object object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.remove(object);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.remove(object);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean retainAll(Collection<?> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.retainAll(collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.retainAll(collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public Object set(int index, Object object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.set(index, object);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                Object object3;
                view.lockView();
                try {
                    object3 = super.set(index, object);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return object3;
            }
        }

        public boolean add(Object object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.add(object);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.add(object);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.add(index, object);
                return;
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                view.lockView();
                try {
                    super.add(index, object);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public boolean addAll(Collection<? extends Object> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAll(collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAll(collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean addAll(int index, Collection<? extends Object> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAll(index, collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAll(index, collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(int index, Object object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.move(index, object);
                return;
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                view.lockView();
                try {
                    super.move(index, object);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        /* synthetic */ CDOStoreEList(InternalEObject internalEObject, EStructuralFeature eStructuralFeature, CDOStoreEList cDOStoreEList, CDOStoreEList cDOStoreEList2) {
            this(internalEObject, eStructuralFeature);
        }
    }

    private final class CDOStoreEcoreEMap
    extends EcoreEMap<Object, Object>
    implements InternalCDOLoadable {
        private static final long serialVersionUID = 1L;

        public CDOStoreEcoreEMap(EStructuralFeature eStructuralFeature) {
            super((EClass)eStructuralFeature.getEType(), BasicEMap.Entry.class, null);
            this.delegateEList = new EStoreEObjectImpl.BasicEStoreEList<BasicEMap.Entry<Object, Object>>((InternalEObject)CDOObjectImpl.this, eStructuralFeature){
                private static final long serialVersionUID = 1L;

                public void unset() {
                    super.unset();
                    this.doClear();
                }

                protected void didAdd(int index, BasicEMap.Entry<Object, Object> newObject) {
                    CDOStoreEcoreEMap.this.doPut(newObject);
                }

                protected void didSet(int index, BasicEMap.Entry<Object, Object> newObject, BasicEMap.Entry<Object, Object> oldObject) {
                    this.didRemove(index, oldObject);
                    this.didAdd(index, newObject);
                }

                protected void didRemove(int index, BasicEMap.Entry<Object, Object> oldObject) {
                    CDOStoreEcoreEMap.this.doRemove(oldObject);
                }

                protected void didClear(int size, Object[] oldObjects) {
                    CDOStoreEcoreEMap.this.doClear();
                }

                protected void didMove(int index, BasicEMap.Entry<Object, Object> movedObject, int oldIndex) {
                    CDOStoreEcoreEMap.this.doMove(movedObject);
                }
            };
            this.size = this.delegateEList.size();
        }

        private void checkListForReading() {
            if (!FSMUtil.isTransient(CDOObjectImpl.this)) {
                CDOStateMachine.INSTANCE.read(CDOObjectImpl.this);
            }
        }

        protected synchronized void ensureEntryDataExists() {
            this.checkListForReading();
            super.ensureEntryDataExists();
        }

        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.basicRemove(object, notifications);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                NotificationChain notificationChain;
                view.lockView();
                try {
                    notificationChain = super.basicRemove(object, notifications);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return notificationChain;
            }
        }

        public NotificationChain basicAdd(Map.Entry<Object, Object> object, NotificationChain notifications) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.basicAdd(object, notifications);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                NotificationChain notificationChain;
                view.lockView();
                try {
                    notificationChain = super.basicAdd(object, notifications);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return notificationChain;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(Map.Entry<Object, Object> object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.addUnique(object);
                return;
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                view.lockView();
                try {
                    super.addUnique(object);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(int index, Map.Entry<Object, Object> object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.addUnique(index, object);
                return;
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                view.lockView();
                try {
                    super.addUnique(index, object);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public boolean addAllUnique(Collection<? extends Map.Entry<Object, Object>> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAllUnique(collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAllUnique(collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean addAllUnique(int index, Collection<? extends Map.Entry<Object, Object>> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAllUnique(index, collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAllUnique(index, collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public Map.Entry<Object, Object> setUnique(int index, Map.Entry<Object, Object> object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.setUnique(index, object);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                Map.Entry entry;
                view.lockView();
                try {
                    entry = super.setUnique(index, object);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return entry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object value) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.set(value);
                return;
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                try {
                    super.set(value);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unset() {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.unset();
                return;
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                try {
                    super.unset();
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public Object put(Object key, Object value) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.put(key, value);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                Object object2;
                view.lockView();
                try {
                    object2 = super.put(key, value);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return object2;
            }
        }

        public Object removeKey(Object key) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.removeKey(key);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                Object object2;
                view.lockView();
                try {
                    object2 = super.removeKey(key);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return object2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map<? extends Object, ? extends Object> map) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.putAll(map);
                return;
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                try {
                    super.putAll(map);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(EMap<? extends Object, ? extends Object> map) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.putAll(map);
                return;
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                try {
                    super.putAll(map);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public Map.Entry<Object, Object> set(int index, Map.Entry<Object, Object> object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.set(index, object);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                Map.Entry entry;
                view.lockView();
                try {
                    entry = super.set(index, object);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return entry;
            }
        }

        public boolean add(Map.Entry<Object, Object> object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.add(object);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.add(object);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Map.Entry<Object, Object> object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.add(index, object);
                return;
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                view.lockView();
                try {
                    super.add(index, object);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public boolean addAll(Collection<? extends Map.Entry<Object, Object>> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAll(collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAll(collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean addAll(int index, Collection<? extends Map.Entry<Object, Object>> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.addAll(index, collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.addAll(index, collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean remove(Object object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.remove(object);
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.remove(object);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public boolean removeAll(Collection<?> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.removeAll(collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.removeAll(collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        public Map.Entry<Object, Object> remove(int index) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.remove(index);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                Map.Entry entry;
                view.lockView();
                try {
                    entry = super.remove(index);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return entry;
            }
        }

        public boolean retainAll(Collection<?> collection) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.retainAll(collection);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                boolean bl;
                view.lockView();
                try {
                    bl = super.retainAll(collection);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.clear();
                return;
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                try {
                    super.clear();
                }
                finally {
                    view.unlockView();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(int index, Map.Entry<Object, Object> object) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                super.move(index, object);
                return;
            }
            Object object2 = view.getViewMonitor();
            synchronized (object2) {
                view.lockView();
                try {
                    super.move(index, object);
                }
                finally {
                    view.unlockView();
                }
            }
        }

        public Map.Entry<Object, Object> move(int targetIndex, int sourceIndex) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return super.move(targetIndex, sourceIndex);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                Map.Entry entry;
                view.lockView();
                try {
                    entry = super.move(targetIndex, sourceIndex);
                    view.unlockView();
                }
                catch (Throwable throwable) {
                    view.unlockView();
                    throw throwable;
                }
                return entry;
            }
        }

        public int size() {
            this.checkListForReading();
            return this.size;
        }

        public boolean isEmpty() {
            this.checkListForReading();
            return this.size == 0;
        }

        public boolean contains(Object object) {
            this.checkListForReading();
            return super.contains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            this.checkListForReading();
            return super.containsAll(collection);
        }

        public boolean containsKey(Object key) {
            this.checkListForReading();
            return super.containsKey(key);
        }

        public boolean containsValue(Object value) {
            this.checkListForReading();
            return super.containsValue(value);
        }

        @Override
        public void cdoInternalPreLoad() {
        }

        @Override
        public void cdoInternalPostLoad() {
            this.entryData = null;
            this.size = this.delegateEList.size();
        }
    }

    private final class CDOStoreFeatureMap
    extends EStoreEObjectImpl.BasicEStoreFeatureMap {
        private static final long serialVersionUID = 1L;

        public CDOStoreFeatureMap(EStructuralFeature eStructuralFeature) {
            super((InternalEObject)CDOObjectImpl.this, eStructuralFeature);
        }
    }

    private final class CDOStoreUnorderedEList<E>
    extends CDOStoreEList {
        private static final long serialVersionUID = 1L;

        public CDOStoreUnorderedEList(EStructuralFeature feature) {
            super(CDOObjectImpl.this, feature);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public E remove(int index) {
            InternalCDOView view = ((CDOObjectImpl)CDOObjectImpl.this).viewAndState.view;
            if (view == null) {
                return this.internalRemove(index);
            }
            Object object = view.getViewMonitor();
            synchronized (object) {
                view.lockView();
                E e = this.internalRemove(index);
                return e;
                finally {
                    view.unlockView();
                }
            }
        }

        private E internalRemove(int index) {
            boolean oldObjectIsLast = index == this.size() - 1;
            Object oldObject = super.remove(index);
            if (!oldObjectIsLast) {
                this.move(index, this.size() - 1);
            }
            return (E)oldObject;
        }
    }

    private static final class TransientStore
    implements InternalEObject.EStore {
        public static TransientStore INSTANCE = new TransientStore();

        private TransientStore() {
        }

        private Object getValue(InternalEObject eObject, int transientIndex) {
            Object[] settings = this.getSettings(eObject);
            return settings[transientIndex];
        }

        private EList<Object> getValueAsList(InternalEObject eObject, int transientIndex) {
            Object[] settings = this.getSettings(eObject);
            EList result = (EList)settings[transientIndex];
            if (result == null) {
                result = new BasicEList();
                settings[transientIndex] = result;
            }
            return result;
        }

        private Object setValue(InternalEObject eObject, int transientIndex, Object newValue) {
            Object[] settings = this.getSettings(eObject);
            Object oldValue = settings[transientIndex];
            settings[transientIndex] = newValue;
            return oldValue;
        }

        private Object[] getSettings(InternalEObject eObject) {
            CDOObjectImpl object = (CDOObjectImpl)eObject;
            object.eSettings();
            return object.eSettings;
        }

        private int getTransientFeatureIndex(InternalEObject eObject, EStructuralFeature feature) {
            CDOObjectImpl object = (CDOObjectImpl)eObject;
            InternalCDOClassInfo classInfo = object.cdoClassInfo();
            return classInfo.getTransientFeatureIndex(feature);
        }

        public Object get(InternalEObject eObject, EStructuralFeature feature, int index) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            if (index != -1) {
                return this.getValueAsList(eObject, transientIndex).get(index);
            }
            return this.getValue(eObject, transientIndex);
        }

        public Object set(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            if (index != -1) {
                return this.getValueAsList(eObject, transientIndex).set(index, value);
            }
            return this.setValue(eObject, transientIndex, value);
        }

        public void add(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            this.getValueAsList(eObject, transientIndex).add(index, value);
        }

        public Object remove(InternalEObject eObject, EStructuralFeature feature, int index) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).remove(index);
        }

        public Object move(InternalEObject eObject, EStructuralFeature feature, int targetIndex, int sourceIndex) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).move(targetIndex, sourceIndex);
        }

        public void clear(InternalEObject eObject, EStructuralFeature feature) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            if (feature.isMany()) {
                this.getValueAsList(eObject, transientIndex).clear();
            }
            this.setValue(eObject, transientIndex, null);
        }

        public int size(InternalEObject eObject, EStructuralFeature feature) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).size();
        }

        public int indexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).indexOf(value);
        }

        public int lastIndexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).lastIndexOf(value);
        }

        public Object[] toArray(InternalEObject eObject, EStructuralFeature feature) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).toArray();
        }

        public <T> T[] toArray(InternalEObject eObject, EStructuralFeature feature, T[] array) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).toArray((Object[])array);
        }

        public boolean isEmpty(InternalEObject eObject, EStructuralFeature feature) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).isEmpty();
        }

        public boolean contains(InternalEObject eObject, EStructuralFeature feature, Object value) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).contains(value);
        }

        public int hashCode(InternalEObject eObject, EStructuralFeature feature) {
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return this.getValueAsList(eObject, transientIndex).hashCode();
        }

        public InternalEObject getContainer(InternalEObject eObject) {
            return null;
        }

        public EStructuralFeature getContainingFeature(InternalEObject eObject) {
            throw new UnsupportedOperationException("Should never be called");
        }

        public EObject create(EClass eClass) {
            throw new UnsupportedOperationException("Should never be called");
        }

        public boolean isSet(InternalEObject eObject, EStructuralFeature feature) {
            if (!feature.isUnsettable()) {
                if (feature.isMany()) {
                    InternalEList list = (InternalEList)eObject.eGet(feature, false);
                    return list != null && !list.isEmpty();
                }
                return !ObjectUtil.equals((Object)eObject.eGet(feature, false), (Object)feature.getDefaultValue());
            }
            Object[] settings = ((CDOObjectImpl)eObject).eSettings;
            if (settings == null) {
                return false;
            }
            int transientIndex = this.getTransientFeatureIndex(eObject, feature);
            return settings[transientIndex] != null;
        }

        public void unset(InternalEObject eObject, EStructuralFeature feature) {
            CDOObjectImpl cdoObject = (CDOObjectImpl)eObject;
            if (feature.isMany()) {
                Object object = cdoObject.eGet(feature, false);
                if (object instanceof List) {
                    List list = (List)object;
                    list.clear();
                }
            } else {
                Object[] settings = cdoObject.eSettings;
                if (settings == null) {
                    return;
                }
                int transientIndex = this.getTransientFeatureIndex(eObject, feature);
                settings[transientIndex] = null;
            }
        }
    }
}

