/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.internal.workspace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.spi.ui.NativeObjectLabelProvider;
import org.eclipse.emf.cdo.transfer.spi.ui.TransferUIProvider;
import org.eclipse.emf.cdo.transfer.spi.workspace.WorkspaceTransferSystem;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ResourceTransfer;

public class WorkspaceUIProvider
implements TransferUIProvider {
    private static final ILabelDecorator DECORATOR = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();

    public ILabelProvider createLabelProvider(CDOTransferSystem system) {
        DecoratingLabelProvider delegate = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), DECORATOR);
        return new NativeObjectLabelProvider((ILabelProvider)delegate);
    }

    public void addSupportedTransfers(List<Transfer> transfers) {
        transfers.add((Transfer)ResourceTransfer.getInstance());
    }

    public List<CDOTransferElement> convertTransferData(Object data) {
        if (data instanceof IResource[]) {
            IResource[] resources = (IResource[])data;
            ArrayList<CDOTransferElement> result = new ArrayList<CDOTransferElement>(resources.length);
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                IPath path = resource.getFullPath();
                CDOTransferElement element = WorkspaceTransferSystem.INSTANCE.getElement(path);
                result.add(element);
                ++i;
            }
            return result;
        }
        return null;
    }

    public CDOTransferElement convertTransferTarget(Object target) {
        if (target instanceof IResource) {
            IResource resource = (IResource)target;
            IPath path = resource.getFullPath();
            return WorkspaceTransferSystem.INSTANCE.getElement(path);
        }
        return null;
    }

    public Object convertSelection(IStructuredSelection selection) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    extends TransferUIProvider.Factory {
        public Factory() {
            super("workspace");
        }

        public TransferUIProvider create(String description) throws ProductCreationException {
            return new WorkspaceUIProvider();
        }
    }
}

