/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.ConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketListeningConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketTransportImpl;
import org.eclipse.osgi.util.NLS;

public class SocketLaunchingConnectorImpl
extends ConnectorImpl
implements LaunchingConnector {
    private static final int ACCEPT_TIMEOUT = 10000;
    private String fHome;
    private String fOptions;
    private String fMain;
    private boolean fSuspend;
    private String fLauncher;

    public SocketLaunchingConnectorImpl(VirtualMachineManagerImpl virtualMachineManager) {
        super(virtualMachineManager);
        SocketTransportImpl transport = new SocketTransportImpl();
        this.setTransport(transport);
    }

    @Override
    public Map<String, Connector.Argument> defaultArguments() {
        HashMap<String, Connector.Argument> arguments = new HashMap<String, Connector.Argument>(6);
        ConnectorImpl.StringArgumentImpl strArg = new ConnectorImpl.StringArgumentImpl(this, "home", ConnectMessages.SocketLaunchingConnectorImpl_Home_directory_of_the_SDK_or_runtime_environment_used_to_launch_the_application_1, ConnectMessages.SocketLaunchingConnectorImpl_Home_2, false);
        strArg.setValue(System.getProperty("java.home"));
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl(this, "options", ConnectMessages.SocketLaunchingConnectorImpl_Launched_VM_options_3, ConnectMessages.SocketLaunchingConnectorImpl_Options_4, false);
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl(this, "main", ConnectMessages.SocketLaunchingConnectorImpl_Main_class_and_arguments__or_if__jar_is_an_option__the_main_jar_file_and_arguments_5, ConnectMessages.SocketLaunchingConnectorImpl_Main_6, true);
        arguments.put(strArg.name(), strArg);
        ConnectorImpl.BooleanArgumentImpl boolArg = new ConnectorImpl.BooleanArgumentImpl(this, "suspend", ConnectMessages.SocketLaunchingConnectorImpl_All_threads_will_be_suspended_before_execution_of_main_7, ConnectMessages.SocketLaunchingConnectorImpl_Suspend_8, false);
        boolArg.setValue(true);
        arguments.put(boolArg.name(), boolArg);
        strArg = new ConnectorImpl.StringArgumentImpl(this, "quote", ConnectMessages.SocketLaunchingConnectorImpl_Character_used_to_combine_space_delimited_text_into_a_single_command_line_argument_9, ConnectMessages.SocketLaunchingConnectorImpl_Quote_10, true);
        strArg.setValue("\"");
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl(this, "vmexec", ConnectMessages.SocketLaunchingConnectorImpl_Name_of_the_Java_VM_launcher_11, ConnectMessages.SocketLaunchingConnectorImpl_Launcher_12, true);
        strArg.setValue("java");
        arguments.put(strArg.name(), strArg);
        return arguments;
    }

    @Override
    public String name() {
        return "com.sun.jdi.CommandLineLaunch";
    }

    @Override
    public String description() {
        return ConnectMessages.SocketLaunchingConnectorImpl_Launches_target_using_Sun_Java_VM_command_line_and_attaches_to_it_13;
    }

    private void getConnectionArguments(Map<String, ? extends Connector.Argument> connectionArgs) throws IllegalConnectorArgumentsException {
        String attribute = "";
        try {
            attribute = "home";
            this.fHome = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "options";
            this.fOptions = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "main";
            this.fMain = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "suspend";
            this.fSuspend = ((Connector.BooleanArgument)connectionArgs.get(attribute)).booleanValue();
            attribute = "quote";
            ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "vmexec";
            this.fLauncher = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.SocketLaunchingConnectorImpl_Connection_argument_is_not_of_the_right_type_14, attribute);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.SocketLaunchingConnectorImpl_Necessary_connection_argument_is_null_15, attribute);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.SocketLaunchingConnectorImpl_Connection_argument_is_not_a_number_16, attribute);
        }
    }

    @Override
    public VirtualMachine launch(Map<String, ? extends Connector.Argument> connectionArgs) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        VirtualMachineImpl virtualMachine;
        this.getConnectionArguments(connectionArgs);
        SocketListeningConnectorImpl listenConnector = new SocketListeningConnectorImpl(this.virtualMachineManager());
        Map<String, Connector.Argument> args = listenConnector.defaultArguments();
        ((Connector.IntegerArgument)args.get("timeout")).setValue(10000);
        String address = listenConnector.startListening(args);
        String execString = String.valueOf(this.fHome) + File.separatorChar + "bin" + File.separatorChar + this.fLauncher;
        execString = String.valueOf(execString) + " -Xdebug -Xnoagent -Djava.compiler=NONE";
        execString = String.valueOf(execString) + " -Xrunjdwp:transport=dt_socket,address=" + address + ",server=n,suspend=" + (this.fSuspend ? "y" : "n");
        if (this.fOptions != null) {
            execString = String.valueOf(execString) + " " + this.fOptions;
        }
        execString = String.valueOf(execString) + " " + this.fMain;
        String[] cmdLine = DebugPlugin.parseArguments((String)execString);
        Process proc = Runtime.getRuntime().exec(cmdLine);
        try {
            virtualMachine = (VirtualMachineImpl)listenConnector.accept(args);
        }
        catch (InterruptedIOException interruptedIOException) {
            proc.destroy();
            String message = NLS.bind((String)ConnectMessages.SocketLaunchingConnectorImpl_VM_did_not_connect_within_given_time___0__ms_1, (Object[])new String[]{((Connector.IntegerArgument)args.get("timeout")).value()});
            throw new VMStartException(message, proc);
        }
        virtualMachine.setLaunchedProcess(proc);
        return virtualMachine;
    }

    public static int findFreePort() {
        try {
            Throwable throwable = null;
            Object var1_2 = null;
            try (ServerSocket socket = new ServerSocket(0);){
                return socket.getLocalPort();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

