/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.tasks.core.ITask;

class LazyTransferList
implements ITransferList {
    private final Map<String, ITask> untransferedTasks = new HashMap<String, ITask>();
    private final ITransferList taskList;

    LazyTransferList(ITransferList taskList) {
        this.taskList = taskList;
    }

    @Override
    public void addCategory(TaskCategory category) {
        this.taskList.addCategory(category);
    }

    @Override
    public void addQuery(RepositoryQuery query) {
        this.taskList.addQuery(query);
    }

    @Override
    public void addTask(ITask task) {
        this.untransferedTasks.put(task.getHandleIdentifier(), task);
    }

    @Override
    public boolean addTask(ITask task, AbstractTaskContainer parentContainer) {
        boolean result = this.taskList.addTask(task, this.commit(parentContainer));
        this.untransferedTasks.remove(task.getHandleIdentifier());
        return result;
    }

    @Override
    public AbstractTaskCategory getContainerForHandle(String handle) {
        return this.taskList.getContainerForHandle(handle);
    }

    @Override
    public Collection<AbstractTask> getAllTasks() {
        return this.taskList.getAllTasks();
    }

    @Override
    public Set<AbstractTaskCategory> getCategories() {
        return this.taskList.getCategories();
    }

    @Override
    public Set<RepositoryQuery> getQueries() {
        return this.taskList.getQueries();
    }

    @Override
    public AbstractTask getTask(String handleIdentifier) {
        AbstractTask task = (AbstractTask)this.untransferedTasks.get(handleIdentifier);
        if (task == null) {
            task = this.taskList.getTask(handleIdentifier);
        }
        return task;
    }

    @Override
    public ITask getTask(String repositoryUrl, String taskId) {
        return this.taskList.getTask(repositoryUrl, taskId);
    }

    private AbstractTaskContainer commit(AbstractTaskContainer container) {
        AbstractTask task;
        if (container instanceof ITask && (task = (AbstractTask)this.untransferedTasks.get(container.getHandleIdentifier())) != null) {
            this.taskList.addTask(task);
            this.untransferedTasks.remove(container.getHandleIdentifier());
        }
        return container;
    }

    public void commit() {
        for (ITask task : this.untransferedTasks.values()) {
            this.taskList.addTask(task);
        }
        this.untransferedTasks.clear();
    }
}

