/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.AbstractViewerAdvisor;
import org.eclipse.team.internal.ui.synchronize.ChangesSection;
import org.eclipse.team.internal.ui.synchronize.actions.DirectionFilterActionGroup;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;

public abstract class AbstractSynchronizePage
extends Page
implements ISynchronizePage,
IAdaptable {
    private ISynchronizePageConfiguration configuration;
    private ISynchronizePageSite site;
    private Composite composite;
    private ChangesSection changesSection;
    private Viewer changesViewer;
    private AbstractViewerAdvisor viewerAdvisor;

    protected AbstractSynchronizePage(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        configuration.setPage(this);
        configuration.addActionContribution(new ModeFilterActions());
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.composite.setLayoutData((Object)data);
        this.changesSection = this.createChangesSection(this.composite);
        this.createChangesViewer((Composite)this.changesSection.getContainer());
        this.changesSection.setViewer(this.changesViewer);
    }

    protected abstract ChangesSection createChangesSection(Composite var1);

    private void createChangesViewer(Composite parent) {
        this.viewerAdvisor = this.createViewerAdvisor(parent);
        this.changesViewer = this.viewerAdvisor.getViewer();
        this.viewerAdvisor.setInitialInput();
    }

    protected abstract AbstractViewerAdvisor createViewerAdvisor(Composite var1);

    public AbstractViewerAdvisor getViewerAdvisor() {
        return this.viewerAdvisor;
    }

    public void setActionBars(IActionBars actionBars) {
        this.viewerAdvisor.setActionBars(actionBars);
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        this.changesSection.setFocus();
    }

    @Override
    public void init(ISynchronizePageSite site) {
        this.site = site;
        IDialogSettings settings = this.getSettings();
        if (settings != null) {
            try {
                int mode = settings.getInt("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE");
                if (mode != 0) {
                    this.configuration.setMode(mode);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void dispose() {
        this.changesSection.dispose();
        this.composite.dispose();
        super.dispose();
    }

    @Override
    public Viewer getViewer() {
        return this.changesViewer;
    }

    @Override
    public boolean aboutToChangeProperty(ISynchronizePageConfiguration configuration, String key, Object newValue) {
        if (key.equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE")) {
            return this.internalSetMode(configuration.getMode(), (Integer)newValue);
        }
        return true;
    }

    private boolean internalSetMode(int oldMode, int mode) {
        if (oldMode == mode) {
            return false;
        }
        this.updateMode(mode);
        IDialogSettings settings = this.getSettings();
        if (settings != null) {
            settings.put("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE", mode);
        }
        return true;
    }

    public <T> T getAdapter(Class<T> key) {
        if (key.equals(ISelectionProvider.class)) {
            return (T)this.changesViewer;
        }
        if (key == IShowInSource.class) {
            return (T)((IShowInSource)() -> {
                StructuredViewer v = (StructuredViewer)this.changesViewer;
                if (v == null) {
                    return null;
                }
                ISelection s = v.getSelection();
                if (s instanceof IStructuredSelection) {
                    Object[] resources = Utils.getResources(((IStructuredSelection)s).toArray());
                    return new ShowInContext(null, (ISelection)new StructuredSelection(resources));
                }
                return null;
            });
        }
        if (key == IShowInTargetList.class) {
            return (T)((IShowInTargetList)() -> new String[]{"org.eclipse.ui.views.ResourceNavigator"});
        }
        return null;
    }

    public ISynchronizePageSite getSynchronizePageSite() {
        return this.site;
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected IDialogSettings getSettings() {
        return this.configuration.getSite().getPageSettings();
    }

    public abstract void reset();

    protected abstract void updateMode(int var1);

    public ChangesSection getChangesSection() {
        return this.changesSection;
    }

    class ModeFilterActions
    extends SynchronizePageActionGroup {
        private DirectionFilterActionGroup modes;

        ModeFilterActions() {
        }

        @Override
        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            if (this.isThreeWay()) {
                this.modes = new DirectionFilterActionGroup(configuration);
            }
        }

        @Override
        public void fillActionBars(IActionBars actionBars) {
            super.fillActionBars(actionBars);
            if (this.modes == null) {
                return;
            }
            IToolBarManager manager = actionBars.getToolBarManager();
            IContributionItem group = this.findGroup((IContributionManager)manager, "modes");
            if (manager != null && group != null) {
                this.modes.fillToolBar(group.getId(), manager);
            }
            IMenuManager viewMenu = actionBars.getMenuManager();
            group = this.findGroup((IContributionManager)manager, "modes");
            if (viewMenu != null && group != null) {
                IContributionItem layoutGroup = this.findGroup((IContributionManager)manager, "layout");
                if (layoutGroup != null) {
                    group = layoutGroup;
                }
                MenuManager modesItem = new MenuManager(Utils.getString("action.modes.label", Policy.getActionBundle()));
                viewMenu.appendToGroup(group.getId(), (IContributionItem)modesItem);
                this.modes.fillMenu((IContributionManager)modesItem);
            }
        }

        private boolean isThreeWay() {
            return "three-way".equals(AbstractSynchronizePage.this.configuration.getComparisonType());
        }
    }
}

