/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource.sasheditor;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.AbstractSashModelProvider;
import org.eclipse.papyrus.infra.core.resource.sasheditor.ISashModelProvider;

class SashModelProviderManager {
    private static final String E_PROVIDER = "sashModelProvider";
    private static final String EXT_PT = "org.eclipse.papyrus.infra.core.sashModelProvider";
    private final ModelSet modelSet;
    private final ISashModelProvider defaultSashModelProvider;
    private final List<ProviderDescriptor> descriptors;

    SashModelProviderManager(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.defaultSashModelProvider = this.createDefaultSashModelProvider();
        this.descriptors = new CopyOnWriteArrayList<ProviderDescriptor>(this.createDescriptors());
    }

    void dispose() {
        for (ProviderDescriptor next : this.descriptors) {
            next.dispose();
        }
    }

    ISashModelProvider getSashModelProvider(final URI userModelURI) {
        ISashModelProvider result = null;
        ProviderDescriptor descriptor = (ProviderDescriptor)Iterables.find(this.descriptors, (Predicate)new Predicate<Predicate<URI>>(){

            public boolean apply(Predicate<URI> input) {
                return input.apply((Object)userModelURI);
            }
        });
        try {
            result = descriptor.getProvider();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            result = this.defaultSashModelProvider;
            this.descriptors.remove(descriptor);
        }
        return result;
    }

    private List<ProviderDescriptor> createDescriptors() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)1);
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement next = iConfigurationElementArray[n2];
            if (E_PROVIDER.equals(next.getName())) {
                try {
                    result.add(new ProviderDescriptor(next));
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        result.add(new ProviderDescriptor(this.defaultSashModelProvider));
        return result;
    }

    private ISashModelProvider createDefaultSashModelProvider() {
        return new AbstractSashModelProvider(){

            @Override
            public URI getSashModelURI(URI userModelURI) {
                URI uriWithoutExtension = userModelURI.trimFileExtension();
                IPath stateLocation = Activator.getDefault().getStateLocation();
                stateLocation = uriWithoutExtension.isPlatform() ? stateLocation.append(uriWithoutExtension.toPlatformString(true)) : stateLocation.append(URI.decode((String)uriWithoutExtension.toString()));
                URI workspaceFileURI = URI.createFileURI((String)stateLocation.toString()).appendFileExtension("sash");
                return workspaceFileURI;
            }
        };
    }

    private class ProviderDescriptor
    implements Predicate<URI> {
        private static final String A_SCHEME = "scheme";
        private static final String A_PATTERN = "pattern";
        private static final String A_CLASS = "class";
        private final IConfigurationElement config;
        private final String scheme;
        private final Pattern pattern;
        private ISashModelProvider provider;

        ProviderDescriptor(ISashModelProvider provider) {
            this.provider = provider;
            this.config = null;
            this.scheme = null;
            this.pattern = null;
        }

        ProviderDescriptor(IConfigurationElement config) throws CoreException {
            this.config = config;
            this.scheme = config.getAttribute(A_SCHEME);
            String pattern = config.getAttribute(A_PATTERN);
            if (Strings.isNullOrEmpty((String)this.scheme) && Strings.isNullOrEmpty((String)pattern)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.core", "Sash model provider missing both scheme and pattern filter."));
            }
            try {
                this.pattern = pattern == null ? null : Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.core", "Invalid sash model provider URI pattern filter.", (Throwable)e));
            }
        }

        public boolean apply(URI input) {
            return !(this.scheme != null && !this.scheme.equals(input.scheme()) || this.pattern != null && !this.pattern.matcher(input.toString()).find());
        }

        ISashModelProvider getProvider() throws CoreException {
            if (this.provider == null) {
                try {
                    this.provider = (ISashModelProvider)this.config.createExecutableExtension(A_CLASS);
                    this.provider.initialize(SashModelProviderManager.this.modelSet);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (ClassCastException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.core", "Invalid sash model provider implementation.", (Throwable)e));
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.core", "Failed to initialize sash model provider implementation.", (Throwable)e));
                }
            }
            return this.provider;
        }

        void dispose() {
            if (this.provider != null) {
                try {
                    this.provider.dispose();
                }
                catch (Exception e) {
                    Activator.log.error("Failed to initialize sash model provider implementation.", (Throwable)e);
                }
                this.provider = null;
            }
        }
    }
}

