/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.etypes.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.EtypesFactory;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.etypes.impl.AnnotationImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

public class EtypesFactoryImpl
extends EFactoryImpl
implements EtypesFactory {
    public static EtypesFactory init() {
        try {
            EtypesFactory theEtypesFactory = (EtypesFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/CDO/Etypes/4.0.0");
            if (theEtypesFactory != null) {
                return theEtypesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new EtypesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createAnnotation();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createBlobFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createClobFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertBlobToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertClobToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Annotation createAnnotation() {
        AnnotationImpl annotation = new AnnotationImpl();
        return annotation;
    }

    public CDOBlob createBlobFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            HexUtil.hexToBytes((Reader)new StringReader(initialValue), (OutputStream)baos);
            return new CDOBlob((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public String convertBlobToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        CDOBlob blob = (CDOBlob)instanceValue;
        try {
            InputStream inputStream = blob.getContents();
            StringWriter writer = new StringWriter();
            HexUtil.bytesToHex((InputStream)inputStream, (Writer)writer);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public CDOClob createClobFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        try {
            return new CDOClob((Reader)new StringReader(initialValue));
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public String convertClobToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        CDOClob clob = (CDOClob)instanceValue;
        try {
            Reader reader = clob.getContents();
            StringWriter writer = new StringWriter();
            IOUtil.copyCharacter((Reader)reader, (Writer)writer);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public CDOLob<?> createLobFromString(EDataType eDataType, String initialValue) {
        return (CDOLob)super.createFromString(eDataType, initialValue);
    }

    @Override
    public EtypesPackage getEtypesPackage() {
        return (EtypesPackage)this.getEPackage();
    }

    @Deprecated
    public static EtypesPackage getPackage() {
        return EtypesPackage.eINSTANCE;
    }
}

