/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.validation.constraints;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.RobotML.DataFlowPort;
import org.eclipse.papyrus.RobotML.ServicePort;
import org.eclipse.papyrus.robotml.validation.constraints.ConstraintsUtil;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PortsAreCorrectlyConnected
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Connector elt = (Connector)ctx.getTarget();
        if (ConstraintsUtil.verifyRobotMLApplied((Element)elt).booleanValue()) {
            EList cends = new ArrayList();
            cends = elt.getEnds();
            if (cends != null && cends.size() == 2 && cends.get(0) instanceof ConnectorEnd && cends.get(1) instanceof ConnectorEnd) {
                ConnectableElement connectorEndRole0 = ((ConnectorEnd)cends.get(0)).getRole();
                ConnectableElement connectorEndRole1 = ((ConnectorEnd)cends.get(1)).getRole();
                if (connectorEndRole0 instanceof Port && connectorEndRole1 instanceof Port && !connectorEndRole0.getAppliedStereotypes().isEmpty() && !connectorEndRole1.getAppliedStereotypes().isEmpty()) {
                    EList steretypesPort0 = new ArrayList();
                    steretypesPort0 = connectorEndRole0.getAppliedStereotypes();
                    EList steretypesPort1 = new ArrayList();
                    steretypesPort1 = connectorEndRole1.getAppliedStereotypes();
                    if (((Stereotype)steretypesPort0.get(0)).getName().equals(((Stereotype)steretypesPort1.get(0)).getName())) {
                        if (!connectorEndRole0.getType().equals(connectorEndRole1.getType())) {
                            return ctx.createFailureStatus(new Object[]{"Connection must be set between ports that have the same type (" + elt.getQualifiedName() + ")"});
                        }
                        Boolean areSubsystems = true;
                        if (elt.getOwner() == connectorEndRole0.getOwner() || elt.getOwner() == connectorEndRole1.getOwner()) {
                            areSubsystems = false;
                        }
                        DataFlowPort flowport0 = (DataFlowPort)UMLUtil.getStereotypeApplication((Element)connectorEndRole0, DataFlowPort.class);
                        DataFlowPort flowport1 = (DataFlowPort)UMLUtil.getStereotypeApplication((Element)connectorEndRole1, DataFlowPort.class);
                        if (flowport0 != null && flowport1 != null) {
                            if (flowport0.getDirection().getValue() == flowport1.getDirection().getValue() && areSubsystems.booleanValue()) {
                                return ctx.createFailureStatus(new Object[]{"Connection must be set between Flow ports that have opposite direction (" + elt.getQualifiedName() + ")"});
                            }
                            if (flowport0.getDirection().getValue() != flowport1.getDirection().getValue() && !areSubsystems.booleanValue()) {
                                return ctx.createFailureStatus(new Object[]{"Connection must be set between Flow ports that have the same direction (" + elt.getQualifiedName() + ")"});
                            }
                        }
                        ServicePort serviceport0 = (ServicePort)UMLUtil.getStereotypeApplication((Element)connectorEndRole0, ServicePort.class);
                        ServicePort serviceport1 = (ServicePort)UMLUtil.getStereotypeApplication((Element)connectorEndRole1, ServicePort.class);
                        if (serviceport0 != null && serviceport1 != null) {
                            if (serviceport0.getKind().getValue() == serviceport1.getKind().getValue() && areSubsystems.booleanValue()) {
                                return ctx.createFailureStatus(new Object[]{"Connection must be set between Service ports that have opposite direction (" + elt.getQualifiedName() + ")"});
                            }
                            if (serviceport0.getKind().getValue() != serviceport1.getKind().getValue() && !areSubsystems.booleanValue()) {
                                return ctx.createFailureStatus(new Object[]{"Connection must be set between Service ports that have the same direction (" + elt.getQualifiedName() + ")"});
                            }
                        }
                        return ctx.createSuccessStatus();
                    }
                    return ctx.createFailureStatus(new Object[]{"Connection must be set between ports of same kind (" + elt.getQualifiedName() + ")"});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

