/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.RobotML.Platform;
import org.eclipse.papyrus.robotml.deployment.CommandSupport;
import org.eclipse.papyrus.robotml.deployment.DepCreation;
import org.eclipse.papyrus.robotml.deployment.TransformationException;
import org.eclipse.papyrus.robotml.deployment.Utils;
import org.eclipse.papyrus.robotml.deployment.handlers.CmdHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CreatePlatformHandler
extends CmdHandler {
    private Package platform;

    public boolean isEnabled() {
        this.updateSelectedEObject();
        EObject selectedObj = this.getSelectedEObject();
        return selectedObj instanceof Class && this.isPlatform((Class)selectedObj);
    }

    private boolean isPlatform(Class elt) {
        Platform platform = (Platform)UMLUtil.getStereotypeApplication((Element)elt, Platform.class);
        return platform != null;
    }

    @Override
    public Object execute(ExecutionEvent event) {
        if (!(this.getSelectedEObject() instanceof Class)) {
            return null;
        }
        final Class selectedComposite = (Class)this.getSelectedEObject();
        CommandSupport.exec("Create platform model", event, new Runnable(){

            @Override
            public void run() {
                CreatePlatformHandler.this.platform = Utils.getRoot((Element)selectedComposite, "PlatformModel");
            }
        });
        final String newPlatform = String.valueOf(selectedComposite.getName()) + "Platform";
        try {
            if (this.platform.getMember(newPlatform) != null) {
                Shell shell = new Shell();
                MessageDialog.openInformation((Shell)shell, (String)"Error", (String)("Platform definition \"" + newPlatform + "\" exists already"));
            } else {
                CommandSupport.exec("Create platform definition", event, new Runnable(){

                    @Override
                    public void run() {
                        Package platformPkg = CreatePlatformHandler.this.platform.createNestedPackage(newPlatform);
                        try {
                            DepCreation.createPlatformInstances(platformPkg, selectedComposite, null);
                        }
                        catch (TransformationException e) {
                            System.err.println(e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

