/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.types.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Assertion;
import org.eclipse.papyrus.robotics.assertions.profile.util.AssertionsResource;
import org.eclipse.papyrus.robotics.core.types.advice.AbstractApplyStereotypeEditHelperAdvice;
import org.eclipse.papyrus.robotics.core.utils.NamingUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.NamedElement;

public class AssertionAdvice
extends AbstractApplyStereotypeEditHelperAdvice {
    private static final String ASSERTION_PREFIX = "A";

    public boolean approveRequest(IEditCommandRequest request) {
        CreateElementRequest createReq;
        GetEditContextRequest context;
        if (request instanceof GetEditContextRequest && (context = (GetEditContextRequest)request).getEditCommandRequest() instanceof CreateElementRequest && !((createReq = (CreateElementRequest)context.getEditCommandRequest()).getContainer() instanceof Class)) {
            return false;
        }
        return super.approveRequest(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Configure Assertion");
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Constraint)) {
            return super.getAfterConfigureCommand(request);
        }
        final Constraint assertion = (Constraint)newElement;
        RecordingCommand defaultValue = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                NamingUtil.setName((NamedElement)assertion, (String)AssertionAdvice.ASSERTION_PREFIX);
                assertion.getConstrainedElements().add((Object)assertion.getContext());
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)defaultValue));
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }

    protected URI getProfileURI() {
        return AssertionsResource.PROFILE_PATH_URI;
    }

    protected java.lang.Class<? extends EObject> stereotypeToApply() {
        return Assertion.class;
    }
}

