/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.transcriber;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractList;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractTable;
import org.eclipse.papyrus.model2doc.core.builtintypes.IFileReference;
import org.eclipse.papyrus.model2doc.core.transcriber.Transcriber;
import org.eclipse.papyrus.model2doc.core.transcription.Transcription;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Body;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.ComposedBodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Image;
import org.eclipse.papyrus.model2doc.emf.documentstructure.InsertedFile;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Paragraph;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TableOfContents;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocumentPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Title;

public class StructureToODTTranscriber
implements Transcriber {
    private Transcription transcription = null;
    private TextDocument textDocument;
    private boolean refreshTableOfContents = false;

    public StructureToODTTranscriber(TextDocument document, Transcription transcription) {
        this.textDocument = document;
        this.transcription = transcription;
    }

    public void transcribe() {
        String mainTitle = this.textDocument.getMainTitle();
        if (mainTitle != null && !mainTitle.isEmpty()) {
            this.transcription.writeDocumentMainTitle(mainTitle);
            this.transcription.writeAuthors((Collection)this.textDocument.getAuthors());
            if (this.textDocument.getVersion() != null) {
                this.transcription.writeVersion(this.textDocument.getVersion().getVersion());
            }
        }
        Iterator iter = this.textDocument.getTextDocumentParts().iterator();
        while (iter.hasNext()) {
            this.transcribe((TextDocumentPart)iter.next());
        }
        if (this.refreshTableOfContents) {
            this.transcription.refreshTableOfContents();
        }
        this.transcription.save("");
    }

    private void transcribe(TextDocumentPart part) {
        if (part instanceof TableOfContents) {
            this.transcribeTableOfContent((TableOfContents)part);
        } else if (part instanceof Body) {
            this.transcribeBody((Body)part);
        }
    }

    private void transcribeBody(Body body) {
        Iterator iter = body.getBodyParts().iterator();
        while (iter.hasNext()) {
            this.transcribeBodyPart((BodyPart)iter.next());
        }
    }

    private void transcribeBodyPart(BodyPart bodyPart) {
        if (bodyPart instanceof Title) {
            this.transcribeTitle((Title)bodyPart);
        } else if (bodyPart instanceof TableOfContents) {
            this.transcribeTableOfContent((TableOfContents)bodyPart);
        } else if (bodyPart instanceof Paragraph) {
            this.transcribteParagraph((Paragraph)bodyPart);
        } else if (bodyPart instanceof Image) {
            this.transcribeImage((Image)bodyPart);
        } else if (bodyPart instanceof AbstractTable) {
            this.transcribeTable((AbstractTable)bodyPart);
        } else if (bodyPart instanceof AbstractList) {
            this.transcribeList((AbstractList)bodyPart);
        } else if (bodyPart instanceof InsertedFile) {
            this.transcribeInsertedFile((InsertedFile)bodyPart);
        }
        if (bodyPart instanceof ComposedBodyPart) {
            Iterator iter = ((ComposedBodyPart)bodyPart).getSubBodyParts().iterator();
            while (iter.hasNext()) {
                this.transcribeBodyPart((BodyPart)iter.next());
            }
        }
    }

    private void transcribeInsertedFile(InsertedFile insertedFile) {
        this.transcription.insertFile((IFileReference)insertedFile);
    }

    private void transcribeTitle(Title title) {
        this.transcription.writeSectionTitle(title.getTitle(), title.getLevel());
    }

    private void transcribeTableOfContent(TableOfContents toc) {
        this.transcription.writeTableOfContents(toc.getTocTitle());
        this.refreshTableOfContents = true;
    }

    private void transcribeImage(Image image) {
        this.transcription.writeImage(image.getImagePath(), image.getCaption());
    }

    private void transcribteParagraph(Paragraph paragraph) {
        this.transcription.writeParagraph(paragraph.getText(), false);
    }

    private void transcribeTable(AbstractTable table) {
        this.transcription.writeTable(table);
    }

    private void transcribeList(AbstractList list) {
        this.transcription.writeList(list, false);
    }
}

