/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.resource.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Brokering.DeviceBroker;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Brokering.MemoryBroker;

import org.eclipse.papyrus.iotml.software.resource.OnDeviceResource;
import org.eclipse.papyrus.iotml.software.resource.ResourcePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>On Device Resource</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.software.resource.impl.OnDeviceResourceImpl#getBase_Class <em>Base Class</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.software.resource.impl.OnDeviceResourceImpl#getDeviceBroker <em>Device Broker</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.software.resource.impl.OnDeviceResourceImpl#getMemoryBroker <em>Memory Broker</em>}</li>
 * </ul>
 *
 * @generated
 */
public class OnDeviceResourceImpl extends MinimalEObjectImpl.Container implements OnDeviceResource {
	/**
	 * The cached value of the '{@link #getBase_Class() <em>Base Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBase_Class()
	 * @generated
	 * @ordered
	 */
	protected org.eclipse.uml2.uml.Class base_Class;

	/**
	 * The cached value of the '{@link #getDeviceBroker() <em>Device Broker</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceBroker()
	 * @generated
	 * @ordered
	 */
	protected DeviceBroker deviceBroker;

	/**
	 * The cached value of the '{@link #getMemoryBroker() <em>Memory Broker</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMemoryBroker()
	 * @generated
	 * @ordered
	 */
	protected MemoryBroker memoryBroker;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OnDeviceResourceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ResourcePackage.Literals.ON_DEVICE_RESOURCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public org.eclipse.uml2.uml.Class getBase_Class() {
		if (base_Class != null && base_Class.eIsProxy()) {
			InternalEObject oldBase_Class = (InternalEObject)base_Class;
			base_Class = (org.eclipse.uml2.uml.Class)eResolveProxy(oldBase_Class);
			if (base_Class != oldBase_Class) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ResourcePackage.ON_DEVICE_RESOURCE__BASE_CLASS, oldBase_Class, base_Class));
			}
		}
		return base_Class;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public org.eclipse.uml2.uml.Class basicGetBase_Class() {
		return base_Class;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBase_Class(org.eclipse.uml2.uml.Class newBase_Class) {
		org.eclipse.uml2.uml.Class oldBase_Class = base_Class;
		base_Class = newBase_Class;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.ON_DEVICE_RESOURCE__BASE_CLASS, oldBase_Class, base_Class));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceBroker getDeviceBroker() {
		if (deviceBroker != null && deviceBroker.eIsProxy()) {
			InternalEObject oldDeviceBroker = (InternalEObject)deviceBroker;
			deviceBroker = (DeviceBroker)eResolveProxy(oldDeviceBroker);
			if (deviceBroker != oldDeviceBroker) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ResourcePackage.ON_DEVICE_RESOURCE__DEVICE_BROKER, oldDeviceBroker, deviceBroker));
			}
		}
		return deviceBroker;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceBroker basicGetDeviceBroker() {
		return deviceBroker;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeviceBroker(DeviceBroker newDeviceBroker) {
		DeviceBroker oldDeviceBroker = deviceBroker;
		deviceBroker = newDeviceBroker;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.ON_DEVICE_RESOURCE__DEVICE_BROKER, oldDeviceBroker, deviceBroker));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MemoryBroker getMemoryBroker() {
		if (memoryBroker != null && memoryBroker.eIsProxy()) {
			InternalEObject oldMemoryBroker = (InternalEObject)memoryBroker;
			memoryBroker = (MemoryBroker)eResolveProxy(oldMemoryBroker);
			if (memoryBroker != oldMemoryBroker) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ResourcePackage.ON_DEVICE_RESOURCE__MEMORY_BROKER, oldMemoryBroker, memoryBroker));
			}
		}
		return memoryBroker;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MemoryBroker basicGetMemoryBroker() {
		return memoryBroker;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMemoryBroker(MemoryBroker newMemoryBroker) {
		MemoryBroker oldMemoryBroker = memoryBroker;
		memoryBroker = newMemoryBroker;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResourcePackage.ON_DEVICE_RESOURCE__MEMORY_BROKER, oldMemoryBroker, memoryBroker));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ResourcePackage.ON_DEVICE_RESOURCE__BASE_CLASS:
				if (resolve) return getBase_Class();
				return basicGetBase_Class();
			case ResourcePackage.ON_DEVICE_RESOURCE__DEVICE_BROKER:
				if (resolve) return getDeviceBroker();
				return basicGetDeviceBroker();
			case ResourcePackage.ON_DEVICE_RESOURCE__MEMORY_BROKER:
				if (resolve) return getMemoryBroker();
				return basicGetMemoryBroker();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ResourcePackage.ON_DEVICE_RESOURCE__BASE_CLASS:
				setBase_Class((org.eclipse.uml2.uml.Class)newValue);
				return;
			case ResourcePackage.ON_DEVICE_RESOURCE__DEVICE_BROKER:
				setDeviceBroker((DeviceBroker)newValue);
				return;
			case ResourcePackage.ON_DEVICE_RESOURCE__MEMORY_BROKER:
				setMemoryBroker((MemoryBroker)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ResourcePackage.ON_DEVICE_RESOURCE__BASE_CLASS:
				setBase_Class((org.eclipse.uml2.uml.Class)null);
				return;
			case ResourcePackage.ON_DEVICE_RESOURCE__DEVICE_BROKER:
				setDeviceBroker((DeviceBroker)null);
				return;
			case ResourcePackage.ON_DEVICE_RESOURCE__MEMORY_BROKER:
				setMemoryBroker((MemoryBroker)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ResourcePackage.ON_DEVICE_RESOURCE__BASE_CLASS:
				return base_Class != null;
			case ResourcePackage.ON_DEVICE_RESOURCE__DEVICE_BROKER:
				return deviceBroker != null;
			case ResourcePackage.ON_DEVICE_RESOURCE__MEMORY_BROKER:
				return memoryBroker != null;
		}
		return super.eIsSet(featureID);
	}

} //OnDeviceResourceImpl
