/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.cpp.codegen.transformation.CppLocationStrategy;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.BatchReverseFunctionBody;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseCpp2Uml;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RoundtripCppUtils {
    private static String ansiUri = "pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml";
    public static String cppProfileUri = "pathmap://PapyrusC_Cpp_PROFILES/C_Cpp.profile.uml";
    public static String umlStandardProfileUri = "pathmap://UML_PROFILES/Standard.profile.uml";
    public static final String EXTERNAL_PACKAGE_NAME = "external";

    public static Classifier getOrCreateClassifier(IStructure iStructure, ITranslationUnit iTu, String projectName, Model model) {
        Classifier classifier = null;
        IPath _location = iTu.getLocation();
        String _string = _location.toString();
        String[] _split = _string.split(projectName);
        String _last = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
        String _substring = _last.substring(1);
        String[] arrayNames = _substring.split("/");
        final ArrayList names = new ArrayList();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String it) {
                names.add(it);
            }
        };
        ((List)Conversions.doWrapArray((Object)arrayNames)).forEach(_function);
        boolean _equals = Objects.equal(classifier, null);
        if (_equals) {
            names.remove(0);
            Model parentPack = model;
            for (String name : names) {
                boolean _not;
                String _last_1;
                boolean _equals_1 = name.equals(_last_1 = (String)IterableExtensions.last(names));
                boolean bl = _not = !_equals_1;
                if (!_not) continue;
                Package _nestedPackage = parentPack.getNestedPackage(name);
                boolean _equals_2 = Objects.equal((Object)_nestedPackage, null);
                if (_equals_2) {
                    parentPack.createNestedPackage(name);
                }
                Package _nestedPackage_1 = parentPack.getNestedPackage(name);
                parentPack = _nestedPackage_1;
            }
            String _elementName = iStructure.getElementName();
            Type _ownedType = parentPack.getOwnedType(_elementName);
            boolean _equals_3 = Objects.equal((Object)_ownedType, null);
            if (_equals_3) {
                String _elementName_1 = iStructure.getElementName();
                parentPack.createOwnedClass(_elementName_1, false);
            }
            String _elementName_2 = iStructure.getElementName();
            Type _ownedType_1 = parentPack.getOwnedType(_elementName_2);
            classifier = (Classifier)_ownedType_1;
        }
        return classifier;
    }

    public static String getFileName(NamedElement element) {
        CppLocationStrategy cppLocationStrategy = new CppLocationStrategy();
        return cppLocationStrategy.getFileName(element);
    }

    public static Type getPrimitiveType(String name, Model model) {
        boolean isPrimitive = RoundtripCppUtils.isPrimitiveCppType(name);
        if (isPrimitive) {
            Package ansiPack = RoundtripCppUtils.importOrgetAModel(model, ansiUri);
            return RoundtripCppUtils.getTypeFromModel(name, ansiPack);
        }
        return null;
    }

    public static boolean isPrimitiveCppType(final String name) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return it.equals(name);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)BatchReverseFunctionBody.ansiTypes)), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
        return !_isEmpty;
    }

    public static Type getTypeFromModel(String name, Package pack) {
        boolean _equals = Objects.equal((Object)pack, null);
        if (_equals) {
            return null;
        }
        PackageableElement ret = pack.getPackagedElement(name);
        boolean _or = false;
        boolean _equals_1 = Objects.equal((Object)ret, null);
        if (_equals_1) {
            _or = true;
        } else {
            boolean bl = _or = !(ret instanceof Type);
        }
        if (_or) {
            return null;
        }
        return (Type)ret;
    }

    public static Package importOrgetAModel(Model model, final String uri) {
        try {
            Model _head;
            Resource _eResource = model.eResource();
            ResourceSet _resourceSet = _eResource.getResourceSet();
            EList _resources = _resourceSet.getResources();
            Functions.Function1<Resource, Boolean> _function = new Functions.Function1<Resource, Boolean>(){

                public Boolean apply(Resource it) {
                    URI _uRI = it.getURI();
                    String _path = _uRI.path();
                    return _path.equals(uri);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_resources, (Functions.Function1)_function);
            Resource resource = (Resource)IterableExtensions.head((Iterable)_filter);
            boolean _equals = Objects.equal((Object)resource, null);
            if (_equals) {
                Resource _createResource;
                Resource _eResource_1 = model.eResource();
                ResourceSet _resourceSet_1 = _eResource_1.getResourceSet();
                URI _createURI = URI.createURI((String)uri);
                resource = _createResource = _resourceSet_1.createResource(_createURI);
                resource.load(null);
            }
            Model pack = null;
            EList _contents = resource.getContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_contents, Model.class);
            pack = _head = (Model)IterableExtensions.head((Iterable)_filter_1);
            return pack;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static EList<EObject> applyProfile(Model model, String uri) {
        try {
            boolean _isProfileApplied;
            boolean _not;
            boolean _notEquals;
            EList _xblockexpression = null;
            Resource _eResource = model.eResource();
            ResourceSet _resourceSet = _eResource.getResourceSet();
            URI _createURI = URI.createURI((String)uri);
            Resource resource = _resourceSet.getResource(_createURI, false);
            boolean _equals = Objects.equal((Object)resource, null);
            if (_equals) {
                Resource _createResource;
                Resource _eResource_1 = model.eResource();
                ResourceSet _resourceSet_1 = _eResource_1.getResourceSet();
                URI _createURI_1 = URI.createURI((String)uri);
                resource = _createResource = _resourceSet_1.createResource(_createURI_1);
                resource.load(null);
            }
            EList _contents = resource.getContents();
            Iterable _filter = Iterables.filter((Iterable)_contents, Profile.class);
            Profile profile = (Profile)IterableExtensions.head((Iterable)_filter);
            EList _xifexpression = null;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)profile, null);
            _and = !_notEquals ? false : (_not = !(_isProfileApplied = model.isProfileApplied(profile)));
            if (_and) {
                _xifexpression = model.applyProfile(profile);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Operation findMatchOperation(Classifier classifier, IASTFunctionDeclarator declarator, String[] names, ReverseCpp2Uml reverseCppUml, ITranslationUnit iTu) {
        Operation ret;
        block20: {
            String classifierName;
            block21: {
                boolean _greaterThan;
                block19: {
                    boolean _equals;
                    boolean _notEquals_4;
                    boolean _notEquals_3;
                    boolean _notEquals_2;
                    boolean _notEquals_1;
                    boolean _notEquals;
                    ret = null;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _and_2 = false;
                    boolean _and_3 = false;
                    boolean bl = _notEquals = !Objects.equal((Object)classifier, null);
                    _and_3 = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)declarator, null));
                    _and_2 = !_and_3 ? false : (_notEquals_2 = !Objects.equal((Object)names, null));
                    _and_1 = !_and_2 ? false : (_notEquals_3 = !Objects.equal((Object)reverseCppUml, null));
                    _and = !_and_1 ? false : (_notEquals_4 = !Objects.equal((Object)iTu, null));
                    if (!_and) return ret;
                    int _length = names.length;
                    if (_length == 1) {
                        return null;
                    }
                    boolean bl2 = _equals = false;
                    if (!_equals) break block19;
                    return null;
                }
                int _length_1 = names.length;
                boolean bl = _greaterThan = _length_1 > 1;
                if (!_greaterThan) break block20;
                int _length_2 = names.length;
                int _minus = _length_2 - 2;
                classifierName = names[_minus];
                String _name = classifier.getName();
                boolean _equals_1 = _name.equals(classifierName);
                if (!_equals_1) return null;
                boolean bl3 = false;
                boolean _not = bl3;
                if (!_not) break block21;
                return null;
            }
            UniqueEList contextNamespaces = new UniqueEList();
            String qualifiedTypeName = "";
            int _length_3 = names.length;
            int _minus_1 = _length_3 - 1;
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus_1, true);
            for (Integer i : _doubleDotLessThan) {
                boolean _notEquals_5;
                String _qualifiedTypeName = qualifiedTypeName;
                String _get = names[i];
                qualifiedTypeName = String.valueOf(_qualifiedTypeName) + _get;
                int _length_4 = names.length;
                int _minus_2 = _length_4 - 2;
                boolean bl = _notEquals_5 = i != _minus_2;
                if (!_notEquals_5) continue;
                String _qualifiedTypeName_1 = qualifiedTypeName;
                qualifiedTypeName = String.valueOf(_qualifiedTypeName_1) + "::";
            }
            contextNamespaces.add(qualifiedTypeName);
            Type ownerClass = reverseCppUml.getUMLType(classifierName, iTu, (List<String>)contextNamespaces);
            if (!(ownerClass instanceof Classifier)) break block20;
            if (!Objects.equal((Object)ownerClass, (Object)classifier)) return null;
            boolean bl = false;
            boolean _notEquals_5 = bl;
            if (!_notEquals_5) break block20;
            return null;
        }
        try {
            boolean _equals_2;
            IASTNode[] _children = declarator.getChildren();
            Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), IASTParameterDeclaration.class);
            int nParmeters = IterableExtensions.size((Iterable)_filter);
            IASTNode[] _children_1 = declarator.getChildren();
            Iterable parameterFunctionList = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_1)), IASTParameterDeclaration.class);
            IASTNode[] _children_2 = declarator.getChildren();
            Iterable _filter_1 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_2)), IASTParameterDeclaration.class);
            int _size = IterableExtensions.size((Iterable)_filter_1);
            boolean bl = _equals_2 = _size == 1;
            if (_equals_2) {
                boolean _notEquals_6;
                IASTNode[] _children_3 = declarator.getChildren();
                Iterable _filter_2 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_3)), IASTParameterDeclaration.class);
                IASTParameterDeclaration parameterNode = ((IASTParameterDeclaration[])Conversions.unwrapArray((Object)_filter_2, IASTParameterDeclaration.class))[0];
                IASTDeclSpecifier _declSpecifier = parameterNode.getDeclSpecifier();
                boolean bl4 = _notEquals_6 = !Objects.equal((Object)_declSpecifier, null);
                if (_notEquals_6) {
                    String type = "";
                    IASTDeclSpecifier _declSpecifier_1 = parameterNode.getDeclSpecifier();
                    IToken tokens = _declSpecifier_1.getSyntax();
                    while (!Objects.equal((Object)tokens, null)) {
                        IToken _next;
                        String _type = type;
                        String _string = tokens.toString();
                        type = String.valueOf(_type) + _string;
                        tokens = _next = tokens.getNext();
                    }
                    String _trim = type.trim();
                    boolean _equals_3 = _trim.equals("void");
                    if (_equals_3) {
                        nParmeters = 0;
                    }
                }
            }
            final int numberParameter = nParmeters;
            int _length_4 = names.length;
            int _minus_2 = _length_4 - 1;
            final String functionName = names[_minus_2];
            EList _allOperations = classifier.getAllOperations();
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    String _name = it.getName();
                    return _name.equals(functionName);
                }
            };
            Iterable sameNames = IterableExtensions.filter((Iterable)_allOperations, (Functions.Function1)_function);
            Functions.Function1<Operation, Boolean> _function_1 = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    Functions.Function1<Parameter, Boolean> _function;
                    EList _ownedParameters = it.getOwnedParameters();
                    Iterable _filter = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)(_function = new Functions.Function1<Parameter, Boolean>(){

                        public Boolean apply(Parameter it) {
                            ParameterDirectionKind _direction = it.getDirection();
                            return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                        }
                    }));
                    int _size = IterableExtensions.size((Iterable)_filter);
                    return _size == numberParameter;
                }
            };
            Iterable sameNumberOfParameters = IterableExtensions.filter((Iterable)sameNames, (Functions.Function1)_function_1);
            for (Operation op : sameNumberOfParameters) {
                boolean _equals_4 = Objects.equal(ret, null);
                if (!_equals_4) continue;
                boolean isMatch = true;
                EList _ownedParameters = op.getOwnedParameters();
                Functions.Function1<Parameter, Boolean> _function_2 = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter it) {
                        ParameterDirectionKind _direction = it.getDirection();
                        return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                    }
                };
                Iterable parameterList = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function_2);
                int i_1 = 0;
                while (i_1 < numberParameter) {
                    boolean _not_1;
                    IASTParameterDeclaration _get_1;
                    IASTDeclSpecifier _declSpecifier_2;
                    String _cppTypeName;
                    Iterable _converted_parameterList = parameterList;
                    Parameter _get = ((Parameter[])Conversions.unwrapArray((Object)_converted_parameterList, Parameter.class))[i_1];
                    Type _type = _get.getType();
                    String _name_1 = _type.getName();
                    boolean _equals_5 = _name_1.equals(_cppTypeName = RoundtripCppUtils.getCppTypeName(_declSpecifier_2 = (_get_1 = ((IASTParameterDeclaration[])Conversions.unwrapArray((Object)parameterFunctionList, IASTParameterDeclaration.class))[i_1]).getDeclSpecifier()));
                    boolean bl5 = _not_1 = !_equals_5;
                    if (_not_1) {
                        isMatch = false;
                    } else {
                        boolean _or = false;
                        Iterable _converted_parameterList_1 = parameterList;
                        Parameter _get_2 = ((Parameter[])Conversions.unwrapArray((Object)_converted_parameterList_1, Parameter.class))[i_1];
                        String _name_2 = _get_2.getName();
                        boolean _equals_6 = Objects.equal((Object)_name_2, null);
                        if (_equals_6) {
                            _or = true;
                        } else {
                            boolean _equals_7;
                            Iterable _converted_parameterList_2 = parameterList;
                            Parameter _get_3 = ((Parameter[])Conversions.unwrapArray((Object)_converted_parameterList_2, Parameter.class))[i_1];
                            String _name_3 = _get_3.getName();
                            _or = _equals_7 = _name_3.equals("");
                        }
                        if (_or) {
                            boolean _notEquals_7;
                            IASTParameterDeclaration _get_4 = ((IASTParameterDeclaration[])Conversions.unwrapArray((Object)parameterFunctionList, IASTParameterDeclaration.class))[i_1];
                            IASTDeclarator _declarator = _get_4.getDeclarator();
                            IASTName paramName = _declarator.getName();
                            boolean bl6 = _notEquals_7 = !Objects.equal((Object)paramName, null);
                            if (_notEquals_7) {
                                Iterable _converted_parameterList_3 = parameterList;
                                Parameter _get_5 = ((Parameter[])Conversions.unwrapArray((Object)_converted_parameterList_3, Parameter.class))[i_1];
                                String _string = paramName.toString();
                                _get_5.setName(_string);
                            }
                        }
                    }
                    ++i_1;
                }
                if (!isMatch) continue;
                ret = op;
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static String getCppTypeName(IASTDeclSpecifier declarator) {
        String parameterTypeName = "";
        try {
            IToken token = declarator.getSyntax();
            while (!Objects.equal((Object)token, null)) {
                IToken _next;
                boolean _equals_3;
                boolean _equals_2;
                boolean _equals_1;
                String tokenStr = token.toString();
                boolean _equals = tokenStr.equals("*");
                if (!(_equals || (_equals_1 = tokenStr.equals("&")) || (_equals_2 = tokenStr.equals("const")) || (_equals_3 = tokenStr.equals("volatile")))) {
                    boolean _greaterThan;
                    int _length = parameterTypeName.length();
                    boolean bl = _greaterThan = _length > 0;
                    if (_greaterThan) {
                        String _parameterTypeName = parameterTypeName;
                        parameterTypeName = String.valueOf(_parameterTypeName) + " ";
                    }
                    String _parameterTypeName_1 = parameterTypeName;
                    parameterTypeName = String.valueOf(_parameterTypeName_1) + tokenStr;
                }
                token = _next = token.getNext();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof ExpansionOverlapsBoundaryException) {
                ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException = (ExpansionOverlapsBoundaryException)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return parameterTypeName;
    }

    public static List<IStructureTemplate> getAllStructureTemplates(IParent parent) {
        try {
            UniqueEList ret = new UniqueEList();
            ICElement[] childrend = parent.getChildren();
            int i = 0;
            while (i < childrend.length) {
                ICElement child = childrend[i];
                boolean _matched = false;
                if (!_matched && child instanceof IStructureTemplate) {
                    _matched = true;
                    ICElement _get = childrend[i];
                    IStructureTemplate istructureTemplate = (IStructureTemplate)_get;
                    ret.add(istructureTemplate);
                }
                if (!_matched && child instanceof IParent) {
                    _matched = true;
                    List<IStructureTemplate> _allStructureTemplates = RoundtripCppUtils.getAllStructureTemplates((IParent)child);
                    ret.addAll(_allStructureTemplates);
                }
                ++i;
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Package getOrcreateExternalPackage(Package parentPack, boolean create) {
        Package _xblockexpression = null;
        Package _nestedPackage = parentPack.getNestedPackage(EXTERNAL_PACKAGE_NAME);
        boolean _equals = Objects.equal((Object)_nestedPackage, null);
        if (_equals && create) {
            Package createdPack = parentPack.createNestedPackage(EXTERNAL_PACKAGE_NAME);
            StereotypeUtil.apply((Element)createdPack, NoCodeGen.class);
        }
        _xblockexpression = parentPack.getNestedPackage(EXTERNAL_PACKAGE_NAME);
        return _xblockexpression;
    }
}

