/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.types.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.designer.ucm.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.designer.ucm.core.menu.MenuHelper;
import org.eclipse.papyrus.designer.ucm.core.provider.UCMContentProvider;
import org.eclipse.papyrus.designer.ucm.core.utils.PortUtils;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_components.ComponentType;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_components.PortTypeSpec;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions.IPortType;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PortEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest context;
        if (request instanceof GetEditContextRequest && (context = (GetEditContextRequest)request).getEditCommandRequest() instanceof CreateElementRequest) {
            return this.approveCreateElementRequest((CreateElementRequest)context.getEditCommandRequest());
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreateElementRequest(CreateElementRequest request) {
        IElementType type = request.getElementType();
        EObject container = request.getContainer();
        return type != null && container instanceof Class && UMLUtil.getStereotypeApplication((Element)((Class)container), ComponentType.class) != null;
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        Type type;
        EObject toEdit = request.getElementToEdit();
        EStructuralFeature feature = request.getFeature();
        if (toEdit instanceof Port && feature == UMLPackage.eINSTANCE.getNamedElement_Name() && (type = ((Port)toEdit).getType()) != null && StereotypeUtil.isApplied((Element)type, PortTypeSpec.class)) {
            String newName = PortUtils.calcName((String)request.getValue());
            if (!type.getName().equals(newName)) {
                SetRequest setRequest = new SetRequest((EObject)type, feature, (Object)newName);
                return ElementEditServiceUtils.getCommandProvider((EObject)type).getEditCommand((IEditCommandRequest)setRequest);
            }
        }
        return super.getAfterSetCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        Object result;
        CompositeCommand compositeCommand = new CompositeCommand("Port configuration command");
        final EObject newElement = request.getElementToConfigure();
        UCMContentProvider cp = new UCMContentProvider(PackageUtil.getRootPackage((Element)((Element)newElement)), UMLPackage.eINSTANCE.getType(), IPortType.class);
        EnhancedPopupMenu popupMenu = MenuHelper.createPopupMenu(cp, "Choose port type", false);
        if (popupMenu.show((Control)Display.getCurrent().getActiveShell()) && (result = popupMenu.getSubResult()) instanceof Type) {
            final Type portType = (Type)result;
            RecordingCommand setStereoCommand = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)portType)){

                protected void doExecute() {
                    Port newPort = (Port)newElement;
                    PortTypeSpec portTypeSpec = PortUtils.createPortTypeSpec(newPort);
                    EObject ucmPortType = UMLUtil.getStereotypeApplication((Element)portType, IPortType.class);
                    portTypeSpec.setType((IPortType)ucmPortType);
                    newPort.setType((Type)portTypeSpec.getBase_Class());
                }
            };
            compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)setStereoCommand));
        }
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }

    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest request) {
        Type type;
        EObject toDestroy = request.getElementToDestroy();
        if (toDestroy instanceof Port && (type = ((Port)toDestroy).getType()) != null && StereotypeUtil.isApplied((Element)type, PortTypeSpec.class)) {
            DestroyElementRequest destroyPortTypeSpec = new DestroyElementRequest(TransactionUtil.getEditingDomain((EObject)type), (EObject)type, false);
            return new DestroyElementCommand(destroyPortTypeSpec);
        }
        return super.getAfterDestroyDependentsCommand(request);
    }

    protected ICommand getBeforeDestroyElementCommand(DestroyElementRequest request) {
        return super.getBeforeDestroyElementCommand(request);
    }

    protected ICommand getAfterDestroyElementCommand(DestroyElementRequest request) {
        return super.getAfterDestroyElementCommand(request);
    }
}

