/**
 * Copyright (c) 2013 CEA LIST
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Ansgar Radermacher - Initial API and implementation
 *
 */

package org.eclipse.papyrus.designer.components.FCM.profile;

import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.FCM.PortKind;


/**
 * A specific mapping rule for template ports, i.e. ports that facilitate the
 * use of bound ports: i.e. instead of creating explicitly a binding for an extended
 * port, the type of the port is used as actual and the kind points to an extended
 * port
 */
public interface ITemplateMappingRule extends IMappingRule {

	/**
	 * Update the created binding
	 */
	public void updateBinding(Port port);

	/**
	 * Return the bound type
	 *
	 * @param port
	 * @return the port kind
	 */
	public PortKind getBoundType(Port port);
}
