/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.parser.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jet.core.parser.DefaultTemplateResolver;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.internal.parser.resources.WorkspaceTemplateResolverHelperFactory;

public final class WorkspaceTemplateResolverBuilder {
    private final List baseLocations = new ArrayList();

    public WorkspaceTemplateResolverBuilder(IProject project) {
        try {
            URI uri = new URI("platform", "/resource/" + project.getName() + "/", null);
            this.baseLocations.add(uri);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException wrapper = new IllegalArgumentException();
            wrapper.initCause(e);
            throw wrapper;
        }
    }

    public WorkspaceTemplateResolverBuilder addAltBaseLocations(URI[] baseLocations) {
        this.baseLocations.addAll(Arrays.asList(baseLocations));
        return this;
    }

    public ITemplateResolver build() {
        return new DefaultTemplateResolver.Builder(this.getBaseLocations()).templateResolverHelperFactory(WorkspaceTemplateResolverHelperFactory.getInstance()).build();
    }

    private URI[] getBaseLocations() {
        return this.baseLocations.toArray(new URI[this.baseLocations.size()]);
    }
}

