/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.inspectors;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.internal.xpath.inspectors.ResourceAttributeFactory;
import org.eclipse.jet.xpath.inspector.AddElementException;
import org.eclipse.jet.xpath.inspector.CopyElementException;
import org.eclipse.jet.xpath.inspector.ExpandedName;
import org.eclipse.jet.xpath.inspector.IElementInspector;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InvalidChildException;
import org.eclipse.jet.xpath.inspector.SimpleElementRequiresValueException;

public class ResourceInspector
implements INodeInspector,
IElementInspector {
    public ExpandedName expandedNameOf(Object node) {
        IResource resource = (IResource)node;
        ExpandedName result = null;
        switch (resource.getType()) {
            case 1: {
                result = new ExpandedName("file");
                break;
            }
            case 2: {
                result = new ExpandedName("folder");
                break;
            }
            case 4: {
                result = new ExpandedName("project");
                break;
            }
            case 8: {
                result = new ExpandedName("root");
            }
        }
        return result;
    }

    public Object[] getChildren(Object node) {
        IResource resource = (IResource)node;
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                return container.members();
            }
            catch (CoreException coreException) {
                return new Object[0];
            }
        }
        return new Object[0];
    }

    public Object getDocumentRoot(Object node) {
        IResource resource = (IResource)node;
        return resource.getWorkspace().getRoot();
    }

    public INodeInspector.NodeKind getNodeKind(Object obj) {
        return INodeInspector.NodeKind.ELEMENT;
    }

    public Object getParent(Object node) {
        IResource resource = (IResource)node;
        return resource.getParent();
    }

    public String nameOf(Object node) {
        ExpandedName expandedName = this.expandedNameOf(node);
        return expandedName.getLocalPart();
    }

    public String stringValueOf(Object node) {
        return "";
    }

    public boolean testExpandedName(Object node, ExpandedName testName) {
        return this.expandedNameOf(node).equals(testName);
    }

    public Object addElement(Object node, ExpandedName elementName, Object addBeforeThisSibling) throws SimpleElementRequiresValueException, InvalidChildException {
        throw new UnsupportedOperationException();
    }

    public Object addTextElement(Object parentElement, String name, String bodyContent, boolean asCData) throws AddElementException {
        throw new UnsupportedOperationException();
    }

    public Object copyElement(Object tgtParent, Object srcElement, String name, boolean recursive) throws CopyElementException {
        throw new UnsupportedOperationException();
    }

    public boolean createAttribute(Object node, String attributeName, String value) {
        throw new UnsupportedOperationException();
    }

    public Object[] getAttributes(Object node) {
        IResource resource = (IResource)node;
        ResourceAttributeFactory factory = new ResourceAttributeFactory();
        return new Object[]{factory.create(1, resource), factory.create(2, resource), factory.create(3, resource), factory.create(4, resource), factory.create(5, resource), factory.create(6, resource), factory.create(7, resource), factory.create(8, resource), factory.create(9, resource), factory.create(10, resource), factory.create(11, resource), factory.create(12, resource), factory.create(13, resource), factory.create(14, resource), factory.create(15, resource), factory.create(16, resource)};
    }

    public Object getNamedAttribute(Object node, ExpandedName nameTestExpandedName) {
        IResource resource = (IResource)node;
        return new ResourceAttributeFactory().create(nameTestExpandedName.getLocalPart(), resource);
    }

    public void removeAttribute(Object node, String name) {
        throw new UnsupportedOperationException();
    }

    public void removeElement(Object node) {
        throw new UnsupportedOperationException();
    }
}

