/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionWithContext;

public class Function
extends ExprNode {
    private final XPathFunction function;
    private final List argExprs;
    private final boolean requiresContext;
    private final String functionName;

    public Function(String functionName, XPathFunction function, List argExprs) {
        this.functionName = functionName;
        this.function = function;
        this.argExprs = argExprs;
        this.requiresContext = function instanceof XPathFunctionWithContext;
    }

    public Object evalAsObject(Context context) {
        Object var4_4;
        if (this.requiresContext) {
            ((XPathFunctionWithContext)((Object)this.function)).setContext(context);
        }
        ArrayList<Object> functionArgValues = new ArrayList<Object>(this.argExprs.size());
        Iterator i = this.argExprs.iterator();
        while (i.hasNext()) {
            ExprNode expr = (ExprNode)i.next();
            functionArgValues.add(expr.evalAsObject(context));
        }
        try {
            Object result;
            Object object = result = this.function.evaluate(functionArgValues);
            var4_4 = null;
            if (this.requiresContext) {
                ((XPathFunctionWithContext)((Object)this.function)).setContext(null);
            }
            return object;
        }
        catch (Throwable throwable) {
            block5: {
                var4_4 = null;
                if (!this.requiresContext) break block5;
                ((XPathFunctionWithContext)((Object)this.function)).setContext(null);
            }
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.functionName);
        buffer.append('(');
        Iterator i = this.argExprs.iterator();
        while (i.hasNext()) {
            ExprNode expr = (ExprNode)i.next();
            buffer.append(expr.toString());
            if (!i.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append(')');
        return buffer.toString();
    }
}

