/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.util.Iterator;
import org.eclipse.jet.compiler.DefaultJET2ASTVisitor;
import org.eclipse.jet.compiler.JET2ASTVisitor;
import org.eclipse.jet.compiler.JET2CompilationUnit;
import org.eclipse.jet.compiler.XMLBodyElement;
import org.eclipse.jet.compiler.XMLElement;
import org.eclipse.jet.compiler.XMLEmptyElement;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.parser.ParseProblemSeverity;
import org.eclipse.jet.taglib.TagAttributeDefinition;
import org.eclipse.jet.taglib.TagDefinition;

final class TagValidationVisitor
extends DefaultJET2ASTVisitor
implements JET2ASTVisitor {
    private final JET2CompilationUnit cu;

    public TagValidationVisitor(JET2CompilationUnit cu) {
        this.cu = cu;
    }

    public void visit(XMLBodyElement xmlBodyElement) {
        if (!xmlBodyElement.getTagDefinition().isContentAllowed()) {
            this.cu.createProblem(ParseProblemSeverity.ERROR, 12, JET2Messages.JET2Compiler_TagCannotHaveContent, new Object[0], xmlBodyElement.getStart(), xmlBodyElement.getEnd(), xmlBodyElement.getLine(), xmlBodyElement.getColumn());
        }
        this.validateAttributes(xmlBodyElement);
    }

    private void validateAttributes(XMLElement xmlElement) {
        TagDefinition tagDefinition = xmlElement.getTagDefinition();
        if (tagDefinition.isDeprecated() || tagDefinition.getTagLibrary().isDeprecated()) {
            this.cu.createProblem(ParseProblemSeverity.WARNING, 14, JET2Messages.JET2Compiler_DeprecatedTag, new Object[0], xmlElement.getStart(), xmlElement.getEnd(), xmlElement.getLine(), xmlElement.getColumn());
        }
        Iterator<Object> i = xmlElement.getAttributes().keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (tagDefinition.getAttributeDefinition(attrName) != null) continue;
            this.cu.createProblem(ParseProblemSeverity.ERROR, 6, JET2Messages.JET2Compiler_UnknownAttribute, new Object[]{attrName}, xmlElement.getStart(), xmlElement.getEnd(), xmlElement.getLine(), xmlElement.getColumn());
        }
        i = tagDefinition.getAttributeDefinitions().iterator();
        while (i.hasNext()) {
            TagAttributeDefinition tad = (TagAttributeDefinition)i.next();
            String attributeName = tad.getName();
            if (tad.isRequired() && !xmlElement.getAttributes().containsKey(attributeName)) {
                this.cu.createProblem(ParseProblemSeverity.ERROR, 3, JET2Messages.JET2Compiler_MissingRequiredAttribute, new Object[]{attributeName}, xmlElement.getStart(), xmlElement.getEnd(), xmlElement.getLine(), xmlElement.getColumn());
            }
            if (!tad.isDeprecated() || !xmlElement.getAttributes().containsKey(attributeName)) continue;
            this.cu.createProblem(ParseProblemSeverity.WARNING, 11, JET2Messages.JET2Compiler_DeprecatedAttribute, new Object[]{attributeName}, xmlElement.getStart(), xmlElement.getEnd(), xmlElement.getLine(), xmlElement.getColumn());
        }
    }

    public void visit(XMLEmptyElement xmlEmptyElement) {
        if (!xmlEmptyElement.getTagDefinition().isEmptyTagAllowed()) {
            this.cu.createProblem(ParseProblemSeverity.ERROR, 13, JET2Messages.JET2Compiler_TagRequiresContent, new Object[0], xmlEmptyElement.getStart(), xmlEmptyElement.getEnd(), xmlEmptyElement.getLine(), xmlEmptyElement.getColumn());
        }
        this.validateAttributes(xmlEmptyElement);
    }
}

