/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class JETOutlineContentProvider
implements ITreeContentProvider {
    private ImportsContainerInput importContainerInput;
    private CompilationUnitContainerInput astContainerInput;
    private OutputPackageInput outputPackageInput;
    private JETCompilationUnit cu;
    private OutputClassInput outputClassInput;
    private JETTextEditor editor;

    public JETOutlineContentProvider(JETTextEditor editor) {
        this.editor = editor;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.cu = (JETCompilationUnit)newInput;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (inputElement instanceof JETCompilationUnit) {
            JETCompilationUnit cu = (JETCompilationUnit)inputElement;
            this.outputPackageInput = new OutputPackageInput(cu);
            results.add(this.outputPackageInput);
            this.importContainerInput = new ImportsContainerInput(cu);
            results.add(this.importContainerInput);
            this.astContainerInput = new CompilationUnitContainerInput(cu);
            results.add(this.astContainerInput);
            results.addAll(Arrays.asList(cu.getTagLibraryReferences()));
        }
        return results.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.outputPackageInput) {
            Object[] objectArray = new Object[1];
            this.outputClassInput = new OutputClassInput(this.cu);
            objectArray[0] = this.outputClassInput;
            return objectArray;
        }
        if (parentElement == this.importContainerInput) {
            return this.importContainerInput.getImportImputs().toArray();
        }
        if (parentElement == this.astContainerInput) {
            return this.astContainerInput.bodyElements.toArray();
        }
        if (parentElement instanceof XMLBodyElement) {
            XMLBodyElement astElement = (XMLBodyElement)parentElement;
            return astElement.getBodyElements().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element == this.outputPackageInput || element == this.importContainerInput || element == this.astContainerInput) {
            return this.cu;
        }
        if (element == this.outputClassInput) {
            return this.outputPackageInput;
        }
        if (element instanceof ImportInput) {
            return ((ImportInput)element).getImportsContainerInput();
        }
        if (element instanceof JETASTElement) {
            if (((JETASTElement)element).getParent() == this.cu) {
                return this.astContainerInput;
            }
            return ((JETASTElement)element).getParent();
        }
        if (this.importContainerInput.getCompilationUnit().getImports().contains(element)) {
            return this.importContainerInput;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof XMLBodyElement || element == this.outputPackageInput || element == this.importContainerInput || element == this.astContainerInput;
    }

    public class CompilationUnitContainerInput {
        private Collection bodyElements = new ArrayList();
        private JETCompilationUnit compilationUnit;

        public CompilationUnitContainerInput(JETCompilationUnit cu) {
            this.compilationUnit = cu;
            Iterator iterator = cu.getBodyElements().iterator();
            while (iterator.hasNext()) {
                JETASTElement elt = (JETASTElement)iterator.next();
                if (this.isFiltered(elt)) continue;
                this.bodyElements.add(elt);
            }
        }

        public Collection getFilteredASTElements() {
            return this.bodyElements;
        }

        public JETCompilationUnit getCompilationUnit() {
            return this.compilationUnit;
        }

        private boolean isFiltered(JETASTElement elt) {
            if (elt instanceof TextElement) {
                String text = new String(((TextElement)elt).getText());
                text = text.replace('\r', ' ');
                text = text.replace('\n', ' ');
                text = text.replace('\t', ' ');
                return (text = text.trim()).length() == 0;
            }
            return false;
        }
    }

    public class ImportInput {
        private ImportsContainerInput container;
        private String imp;

        public ImportInput(ImportsContainerInput container, String imp) {
            this.container = container;
            this.imp = imp;
        }

        public ImportsContainerInput getImportsContainerInput() {
            return this.container;
        }

        public String toString() {
            return this.imp;
        }
    }

    public class ImportsContainerInput {
        private JETCompilationUnit compilationUnit;
        private Collection importInputs;

        public ImportsContainerInput(JETCompilationUnit cu) {
            this.compilationUnit = cu;
            this.importInputs = new ArrayList();
            Iterator iterator = cu.getImports().iterator();
            while (iterator.hasNext()) {
                String imp = (String)iterator.next();
                this.importInputs.add(new ImportInput(this, imp));
            }
        }

        public JETCompilationUnit getCompilationUnit() {
            return this.compilationUnit;
        }

        public Collection getImportImputs() {
            return this.importInputs;
        }
    }

    public class OutputClassInput {
        private JETCompilationUnit compilationUnit;

        public OutputClassInput(JETCompilationUnit cu) {
            this.compilationUnit = cu;
        }

        public JETCompilationUnit getCompilationUnit() {
            return this.compilationUnit;
        }
    }

    public class OutputPackageInput {
        private JETCompilationUnit compilationUnit;

        public OutputPackageInput(JETCompilationUnit cu) {
            this.compilationUnit = cu;
        }

        public JETCompilationUnit getCompilationUnit() {
            return this.compilationUnit;
        }
    }
}

