/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jet.core.parser.ast.Comment;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.JETDirective;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.core.parser.ast.JavaScriptlet;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;
import org.eclipse.jet.core.parser.ast.XMLBodyElementEnd;
import org.eclipse.jet.core.parser.ast.XMLEmptyElement;
import org.eclipse.jet.internal.compiler.CompilationHelper;
import org.eclipse.jet.internal.editor.Activator;
import org.eclipse.jet.internal.editor.JETSourceViewer;
import org.eclipse.jet.internal.editor.configuration.JETDocumentProvider;
import org.eclipse.jet.internal.editor.configuration.JETEditorPreferenceConstants;
import org.eclipse.jet.internal.editor.configuration.JETSourceViewerConfiguration;
import org.eclipse.jet.internal.editor.configuration.JETTokenStyleManager;
import org.eclipse.jet.internal.editor.configuration.delegates.IJETDefaultTextColorerDelegate;
import org.eclipse.jet.internal.editor.outline.JETOutlinePage;
import org.eclipse.jet.internal.editor.partition.JETDocumentPartitionScanner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.framework.Bundle;

public class JETTextEditor
extends TextEditor {
    private JETTokenStyleManager tokenStyleManager;
    private JETSourceViewer sourceViewer;
    private JETDocumentPartitionScanner partitionScanner;
    private ProjectionSupport projectionSupport;
    private IContentOutlinePage outlinePage;
    private JETCompilationUnit cUnit;
    private IProject project;
    private Map positions = Collections.EMPTY_MAP;
    private boolean cUnitInvalidated;
    private ArrayList defaultContentColorerDelegates;
    private IJETDefaultTextColorerDelegate currentDelegate;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public JETTextEditor() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        JETEditorPreferenceConstants.initializeDefaultValues(preferenceStore);
        this.setPreferenceStore(preferenceStore);
        this.tokenStyleManager = new JETTokenStyleManager(preferenceStore);
        this.partitionScanner = new JETDocumentPartitionScanner(this);
        this.setSourceViewerConfiguration(new JETSourceViewerConfiguration(this));
        this.setDocumentProvider((IDocumentProvider)new JETDocumentProvider(this));
    }

    public void dispose() {
        this.tokenStyleManager.dispose();
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            this.project = ((IFileEditorInput)input).getFile().getProject();
        }
        super.init(site, input);
        this.initDefaultContentColorerDelegetes();
        if (!this.defaultContentColorerDelegates.isEmpty()) {
            this.currentDelegate = (IJETDefaultTextColorerDelegate)this.defaultContentColorerDelegates.get(0);
        }
    }

    public void setCurrentColorerDelegate(IJETDefaultTextColorerDelegate delegate) {
        this.currentDelegate = delegate;
        this.partitionScanner.updateJETTextContentDamagerRepairer();
        if (this.isDirty()) {
            this.getSourceViewer().getDocument().set(this.getSourceViewer().getDocument().get());
        } else {
            this.setInput(this.getEditorInput());
        }
    }

    public IJETDefaultTextColorerDelegate getCurrentColorerDelegate() {
        return this.currentDelegate;
    }

    public IJETDefaultTextColorerDelegate[] getColorerDelegates() {
        IJETDefaultTextColorerDelegate[] results = new IJETDefaultTextColorerDelegate[this.defaultContentColorerDelegates.size()];
        this.defaultContentColorerDelegates.toArray(results);
        return results;
    }

    private void initDefaultContentColorerDelegetes() {
        this.defaultContentColorerDelegates = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.jet.internal.editor", "defaultContentColorerDelegates");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
            String delegateClass = element.getAttribute("delegateClass");
            IJETDefaultTextColorerDelegate delegate = null;
            try {
                Class clazz = bundle.loadClass(delegateClass);
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.jet.internal.editor.JETTextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class[] argTypes = classArray;
                Constructor ctorWithTextEditor = null;
                try {
                    ctorWithTextEditor = clazz.getConstructor(argTypes);
                }
                catch (SecurityException e) {
                    Activator.log(e);
                }
                catch (NoSuchMethodException e) {
                    Activator.log(e);
                }
                delegate = ctorWithTextEditor != null ? (IJETDefaultTextColorerDelegate)ctorWithTextEditor.newInstance(new Object[]{this}) : (IJETDefaultTextColorerDelegate)clazz.newInstance();
                this.defaultContentColorerDelegates.add(delegate);
            }
            catch (ClassNotFoundException e) {
                Activator.log(e);
            }
            catch (InstantiationException e) {
                Activator.log(e);
            }
            catch (IllegalAccessException e) {
                Activator.log(e);
            }
            catch (IllegalArgumentException e) {
                Activator.log(e);
            }
            catch (InvocationTargetException e) {
                Activator.log(e);
            }
            ++i;
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.sourceViewer = new JETSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, this.getPreferenceStore());
        this.getSourceViewerDecorationSupport((ISourceViewer)this.sourceViewer);
        this.projectionSupport = new ProjectionSupport((ProjectionViewer)this.sourceViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, JETTextEditor.this.getOrientation(), 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        });
        this.projectionSupport.install();
        return this.sourceViewer;
    }

    public ISourceViewer getEditorSourceViewer() {
        return this.sourceViewer;
    }

    public IPreferenceStore getEditorPreferenceStore() {
        return super.getPreferenceStore();
    }

    public JETDocumentPartitionScanner getPartitionScanner() {
        return this.partitionScanner;
    }

    public JETTokenStyleManager getTokenStyleManager() {
        return this.tokenStyleManager;
    }

    protected void handleEditorInputChanged() {
        super.handleEditorInputChanged();
        this.handleDocumentChange(null);
    }

    public void handleDocumentChange(DocumentEvent e) {
        this.cUnitInvalidated = true;
        if (this.outlinePage != null && this.outlinePage.getControl().isVisible()) {
            ((JETOutlinePage)this.outlinePage).setInput();
        }
    }

    public boolean isCUnitInvalidated() {
        return this.cUnitInvalidated;
    }

    public CompilationHelper compilationHelper() {
        CompilationHelper jetCompilationHelper = new CompilationHelper(this.project);
        return jetCompilationHelper;
    }

    public JETCompilationUnit requestCompilationUnit() {
        if (this.cUnit == null || this.cUnitInvalidated) {
            IEditorInput editorInput = this.getEditorInput();
            if (this.sourceViewer == null) {
                String templatePath = editorInput.getName();
                if (editorInput instanceof IFileEditorInput) {
                    templatePath = ((IFileEditorInput)editorInput).getFile().getProjectRelativePath().toString();
                }
                this.cUnit = this.compilationHelper().getAST(templatePath);
            } else {
                this.cUnit = this.compilationHelper().getASTFromSource(this.sourceViewer.getDocument().get());
            }
            PositionsCollector collector = new PositionsCollector();
            this.cUnit.accept((JETASTVisitor)collector);
            this.positions = collector.getPositions();
            this.cUnitInvalidated = false;
        }
        return this.cUnit;
    }

    public JETASTElement getASTElement(int offset) {
        this.requestCompilationUnit();
        return this.getCachedASTElement(offset);
    }

    public JETASTElement getCachedASTElement(int offset) {
        Iterator iterator = this.positions.keySet().iterator();
        while (iterator.hasNext()) {
            Position pos = (Position)iterator.next();
            if (pos.offset > offset || pos.length + pos.offset <= offset) continue;
            return (JETASTElement)this.positions.get(pos);
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.jet.internal.editor.i18n.TextEditorMessages");
        ContentAssistAction action = new ContentAssistAction(resourceBundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        if (event.getNewValue() instanceof RGB) {
            this.getTokenStyleManager().bindColor(event.getProperty(), (RGB)event.getNewValue());
        }
    }

    public Object getAdapter(Class required) {
        Object adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
            }
            return this.outlinePage;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.editors.text.IEncodingSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.fEncodingSupport;
        }
        if (this.projectionSupport != null && (adapter = this.projectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "settings", "setDelegateColorerActionID");
    }

    protected IContentOutlinePage createOutlinePage() {
        JETOutlinePage page = new JETOutlinePage(this);
        page.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JETTextEditor.this.handleContentOutlineSelection(event.getSelection());
            }
        });
        return page;
    }

    protected void handleContentOutlineSelection(ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        Object firstElement = ssel.getFirstElement();
        if (firstElement instanceof JETASTElement) {
            JETASTElement astElement = (JETASTElement)firstElement;
            int start = astElement.getStart();
            int end = astElement.getEnd();
            int length = end - start;
            if (astElement instanceof TextElement) {
                start = astElement.getPrevElement() != null ? astElement.getPrevElement().getEnd() : 0;
                length = ((TextElement)astElement).getText().length;
            }
            this.sourceViewer.setSelectedRange(start, length);
            this.sourceViewer.revealRange(start, length);
        }
    }

    private static class PositionsCollector
    extends JETASTVisitor {
        private Map positions = new HashMap();

        private PositionsCollector() {
        }

        public Map getPositions() {
            return this.positions;
        }

        public boolean visit(JavaDeclaration declaration) {
            return this.matchOffset((JETASTElement)declaration);
        }

        public boolean visit(JETDirective directive) {
            return this.matchOffset((JETASTElement)directive);
        }

        public boolean visit(JavaExpression expression) {
            return this.matchOffset((JETASTElement)expression);
        }

        public boolean visit(JavaScriptlet scriptlet) {
            return this.matchOffset((JETASTElement)scriptlet);
        }

        public boolean visit(XMLEmptyElement xmlEmptyElement) {
            return this.matchOffset((JETASTElement)xmlEmptyElement);
        }

        public boolean visit(XMLBodyElement xmlBodyElement) {
            return this.matchOffset((JETASTElement)xmlBodyElement);
        }

        public boolean visit(XMLBodyElementEnd xmlBodyElementEnd) {
            return this.matchOffset((JETASTElement)xmlBodyElementEnd);
        }

        public boolean visit(Comment comment) {
            return this.matchOffset((JETASTElement)comment);
        }

        public boolean matchOffset(JETASTElement astElement) {
            int start = astElement.getStart();
            int end = astElement.getEnd();
            int length = end - start;
            this.positions.put(new Position(start, length), astElement);
            return true;
        }
    }
}

