/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import org.eclipse.jet.core.parser.ast.BodyElements;
import org.eclipse.jet.core.parser.ast.JETAST;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;

public abstract class JETASTElement {
    private final int start;
    private final int end;
    private final JETAST ast;
    private final int line;
    private JETASTElement parent = null;
    private final int column;

    public final JETASTElement getParent() {
        return this.parent;
    }

    final void setParent(JETASTElement parent) {
        this.parent = parent;
    }

    JETASTElement(JETAST ast, int line, int column, int start, int end) {
        this.ast = ast;
        this.column = column;
        this.line = line;
        this.start = start;
        this.end = end;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final void accept(JETASTVisitor visitor) {
        visitor.preVisit(this);
        this.accept0(visitor);
        visitor.postVisit(this);
    }

    protected abstract void accept0(JETASTVisitor var1);

    public JETAST getAst() {
        return this.ast;
    }

    public final int getLine() {
        return this.line;
    }

    private BodyElements getBodyElements(JETASTElement element) {
        BodyElements bodyElements = null;
        if (this.parent instanceof JETCompilationUnit) {
            bodyElements = ((JETCompilationUnit)this.parent).getInternalBodyElements();
        } else if (this.parent instanceof XMLBodyElement) {
            bodyElements = ((XMLBodyElement)this.parent).getInternalBodyElements();
        }
        return bodyElements;
    }

    public JETASTElement getNextElement() {
        JETASTElement next = null;
        if (this.parent != null) {
            BodyElements bodyElements = this.getBodyElements(this.parent);
            next = bodyElements != null ? bodyElements.elementAfter(this) : this.parent.getNextElement();
        }
        return next;
    }

    public JETASTElement getPrevElement() {
        JETASTElement prev = null;
        if (this.parent != null) {
            BodyElements bodyElements = this.getBodyElements(this.parent);
            prev = bodyElements != null ? bodyElements.elementBefore(this) : this.parent.getPrevElement();
        }
        return prev;
    }

    public final int getColumn() {
        return this.column;
    }

    public abstract boolean removeLineWhenOtherwiseEmpty();
}

