/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast.analyze;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.gmf.internal.xpand.ast.AbstractAstVisitor;
import org.eclipse.gmf.internal.xpand.ocl.ExpressionHelper;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.ecore.OperationCallExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedModulesCollector
extends AbstractAstVisitor {
    private Set<Module> myUnusedModules;

    public UnusedModulesCollector(Set<Module> allModules) {
        this.myUnusedModules = new LinkedHashSet<Module>(allModules);
    }

    public Set<Module> getUnusedModules() {
        return this.myUnusedModules;
    }

    @Override
    protected void visitExpressionHelper(ExpressionHelper expressionHelper) {
        if (this.myUnusedModules.size() == 0) {
            return;
        }
        if (expressionHelper.getOCLExpression() != null) {
            this.purgeUsedModule((EObject)expressionHelper.getOCLExpression());
            TreeIterator it = expressionHelper.getOCLExpression().eAllContents();
            while (it.hasNext()) {
                this.purgeUsedModule((EObject)it.next());
            }
        }
    }

    private void purgeUsedModule(EObject oclAstElement) {
        EObject eContainer;
        OperationCallExp opCall;
        EOperation referredOperation;
        if (oclAstElement instanceof OperationCallExp && (referredOperation = (EOperation)(opCall = (OperationCallExp)oclAstElement).getReferredOperation()) != null && (eContainer = referredOperation.eContainer()) instanceof Module) {
            this.myUnusedModules.remove(eContainer);
        }
    }
}

