/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.figures;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.FanRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ForestRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;

public class ConnectionLayerEx
extends ConnectionLayer {
    private boolean dirtied = false;
    private static boolean allowJumpLinks = true;
    private ConnectionRouter obliqueRouter = null;
    private ConnectionRouter rectilinearRouter = null;
    private ConnectionRouter treeRouter = null;

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        this.dirtyJumpLinks(figure.getBounds());
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.dirtyJumpLinks(figure.getBounds());
    }

    public static boolean shouldJumpLinks() {
        return allowJumpLinks;
    }

    public static void setJumpLinks(boolean set) {
        allowJumpLinks = set;
    }

    public void cleanJumpLinks() {
        this.dirtied = false;
    }

    public void dirtyJumpLinks(Rectangle region) {
        if (!this.dirtied && ConnectionLayerEx.shouldJumpLinks()) {
            List children = this.getChildren();
            ListIterator childIter = children.listIterator();
            while (childIter.hasNext()) {
                IFigure poly = (IFigure)childIter.next();
                if (!(poly instanceof PolylineConnectionEx) || !poly.getBounds().intersects(region)) continue;
                ((PolylineConnectionEx)poly).refreshLine();
            }
            this.dirtied = true;
        }
    }

    public ConnectionRouter getConnectionRouter() {
        return this.getObliqueRouter();
    }

    public ConnectionRouter getObliqueRouter() {
        if (this.obliqueRouter == null) {
            FanRouter router = new FanRouter();
            router.setNextRouter((ConnectionRouter)new ObliqueRouter());
            this.obliqueRouter = router;
        }
        return this.obliqueRouter;
    }

    public ConnectionRouter getRectilinearRouter() {
        if (this.rectilinearRouter == null) {
            this.rectilinearRouter = new RectilinearRouter();
        }
        return this.rectilinearRouter;
    }

    public ConnectionRouter getTreeRouter() {
        if (this.treeRouter == null) {
            this.treeRouter = new ForestRouter();
        }
        return this.treeRouter;
    }
}

