/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.bridge.genmodel.DummyGenModel;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGenModelAccess
implements GenModelAccess {
    private final EPackage model;
    private GenModel genModel;
    private final List<URI> locations = new LinkedList<URI>();
    private boolean needUnload;

    public BasicGenModelAccess(EPackage aModel) {
        this.model = aModel;
    }

    public void initDefault() {
        this.registerLocation(this.constructDefaultFromModel());
        this.registerLocation(this.fromExtpoint());
    }

    protected final URI fromExtpoint() {
        return this.fromExtpoint(this.model.getNsURI());
    }

    protected final URI fromExtpoint(String nsURI) {
        return (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(nsURI);
    }

    protected final URI constructDefaultFromModel() {
        if (this.model.eResource() == null || this.model.getNsURI() == null) {
            return null;
        }
        URI domainModelURI = this.model.eResource().getURI();
        if (this.model.getNsURI().equals(domainModelURI.toString())) {
            return null;
        }
        URI genModelURI = domainModelURI.trimFileExtension().appendFileExtension("genmodel");
        if (genModelURI.equals((Object)domainModelURI)) {
            return null;
        }
        return genModelURI;
    }

    protected final EPackage original() {
        return this.model;
    }

    @Override
    public GenModel model() {
        return this.genModel;
    }

    public IStatus ensure() {
        IStatus loadStatus = this.load();
        if (loadStatus.isOK()) {
            return loadStatus;
        }
        return this.createDummy();
    }

    @Override
    public IStatus load() {
        ResourceSetImpl rs = this.model.eResource() == null || this.model.eResource().getResourceSet() == null ? new ResourceSetImpl() : this.model.eResource().getResourceSet();
        return this.load((ResourceSet)rs);
    }

    @Override
    public IStatus load(ResourceSet rs) {
        assert (!this.locations.isEmpty());
        LinkedList<Status> exceptions = new LinkedList<Status>();
        for (URI uri : this.locations) {
            try {
                Resource r = rs.getResource(uri, false);
                this.needUnload = r == null || !r.isLoaded();
                r = rs.getResource(uri, true);
                if (r == null) continue;
                this.genModel = (GenModel)r.getContents().get(0);
                return Status.OK_STATUS;
            }
            catch (WrappedException ex) {
                exceptions.add(new Status(4, "org.eclipse.gmf.bridge", ex.getMessage(), ex.getCause()));
            }
        }
        this.needUnload = false;
        if (exceptions.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        IStatus[] sa = exceptions.toArray(new IStatus[exceptions.size()]);
        return new MultiStatus("org.eclipse.gmf.bridge", 0, sa, "Problems while loading GenModel", null);
    }

    @Override
    public void unload() {
        if (this.needUnload && this.genModel != null) {
            this.genModel.eResource().unload();
            this.genModel = null;
        }
        this.needUnload = false;
    }

    public IStatus createDummy() {
        return this.createDummy(null);
    }

    public IStatus createDummy(Collection<EPackage> additionalPackages) {
        this.genModel = new DummyGenModel(this.model, additionalPackages).create();
        this.confineInResource();
        return Status.OK_STATUS;
    }

    private void confineInResource() {
        Resource r = new ResourceSetImpl().createResource(URI.createGenericURI((String)"uri", (String)this.genModel.getModelPluginID(), null));
        r.getContents().add((Object)this.genModel);
    }

    public boolean hasLocations() {
        return this.locations != null && !this.locations.isEmpty();
    }

    protected void registerLocation(URI location) {
        if (location != null) {
            this.locations.add(location);
        }
    }

    protected void unregsiterLocation(URI location) {
        this.locations.remove(location);
    }
}

